/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONString;
import org.json.JSONTokener;

public class JSONObject {
    private HashMap myHashMap;
    public static final Object NULL = new Null();

    public JSONObject() {
        this.myHashMap = new HashMap();
    }

    public JSONObject(JSONObject jo, String[] names) throws JSONException {
        this();
        for (int i2 = 0; i2 < names.length; ++i2) {
            this.putOpt(names[i2], jo.opt(names[i2]));
        }
    }

    public JSONObject(JSONTokener x2) throws JSONException {
        this();
        if (x2.nextClean() != '{') {
            throw x2.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c2 = x2.nextClean();
            switch (c2) {
                case '\u0000': {
                    throw x2.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x2.back();
            String key = x2.nextValue().toString();
            c2 = x2.nextClean();
            if (c2 == '=') {
                if (x2.next() != '>') {
                    x2.back();
                }
            } else if (c2 != ':') {
                throw x2.syntaxError("Expected a ':' after a key");
            }
            this.put(key, x2.nextValue());
            switch (x2.nextClean()) {
                case ',': 
                case ';': {
                    if (x2.nextClean() == '}') {
                        return;
                    }
                    x2.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x2.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(Map map) {
        this.myHashMap = map == null ? new HashMap() : new HashMap(map);
    }

    public JSONObject(Object bean) {
        this();
        Class<?> klass = bean.getClass();
        Method[] methods = klass.getMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            try {
                Method method = methods[i2];
                String name = method.getName();
                String key = "";
                if (name.startsWith("get")) {
                    key = name.substring(3);
                } else if (name.startsWith("is")) {
                    key = name.substring(2);
                }
                if (key.length() <= 0 || !Character.isUpperCase(key.charAt(0)) || method.getParameterTypes().length != 0) continue;
                if (key.length() == 1) {
                    key = key.toLowerCase();
                } else if (!Character.isUpperCase(key.charAt(1))) {
                    key = key.substring(0, 1).toLowerCase() + key.substring(1);
                }
                this.put(key, method.invoke(bean, null));
                continue;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    public JSONObject(Object object, String[] names) {
        this();
        Class<?> c2 = object.getClass();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            try {
                Field field = c2.getField(name);
                Object value = field.get(object);
                this.put(name, value);
                continue;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    public JSONObject(String source) throws JSONException {
        this(new JSONTokener(source));
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object o2 = this.opt(key);
        if (o2 == null) {
            this.put(key, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (o2 instanceof JSONArray) {
            ((JSONArray)o2).put(value);
        } else {
            this.put(key, new JSONArray().put(o2).put(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        JSONObject.testValidity(value);
        Object o2 = this.opt(key);
        if (o2 == null) {
            this.put(key, new JSONArray().put(value));
        } else if (o2 instanceof JSONArray) {
            this.put(key, ((JSONArray)o2).put(value));
        } else {
            throw new JSONException("JSONObject[" + key + "] is not a JSONArray.");
        }
        return this;
    }

    public static String doubleToString(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return "null";
        }
        String s2 = Double.toString(d2);
        if (s2.indexOf(46) > 0 && s2.indexOf(101) < 0 && s2.indexOf(69) < 0) {
            while (s2.endsWith("0")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
            if (s2.endsWith(".")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
        }
        return s2;
    }

    public Object get(String key) throws JSONException {
        Object o2 = this.opt(key);
        if (o2 == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] not found.");
        }
        return o2;
    }

    public boolean getBoolean(String key) throws JSONException {
        Object o2 = this.get(key);
        if (o2.equals(Boolean.FALSE) || o2 instanceof String && ((String)o2).equalsIgnoreCase("false")) {
            return false;
        }
        if (o2.equals(Boolean.TRUE) || o2 instanceof String && ((String)o2).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) throws JSONException {
        Object o2 = this.get(key);
        try {
            return o2 instanceof Number ? ((Number)o2).doubleValue() : Double.valueOf((String)o2).doubleValue();
        }
        catch (Exception e2) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a number.");
        }
    }

    public int getInt(String key) throws JSONException {
        Object o2 = this.get(key);
        return o2 instanceof Number ? ((Number)o2).intValue() : (int)this.getDouble(key);
    }

    public JSONArray getJSONArray(String key) throws JSONException {
        Object o2 = this.get(key);
        if (o2 instanceof JSONArray) {
            return (JSONArray)o2;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) throws JSONException {
        Object o2 = this.get(key);
        if (o2 instanceof JSONObject) {
            return (JSONObject)o2;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) throws JSONException {
        Object o2 = this.get(key);
        return o2 instanceof Number ? ((Number)o2).longValue() : (long)this.getDouble(key);
    }

    public static String[] getNames(JSONObject jo) {
        int length = jo.length();
        if (length == 0) {
            return null;
        }
        Iterator i2 = jo.keys();
        String[] names = new String[length];
        int j2 = 0;
        while (i2.hasNext()) {
            names[j2] = (String)i2.next();
            ++j2;
        }
        return names;
    }

    public static String[] getNames(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> klass = object.getClass();
        Field[] fields = klass.getFields();
        int length = fields.length;
        if (length == 0) {
            return null;
        }
        String[] names = new String[length];
        for (int i2 = 0; i2 < length; ++i2) {
            names[i2] = fields[i2].getName();
        }
        return names;
    }

    public String getString(String key) throws JSONException {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.myHashMap.containsKey(key);
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Iterator keys() {
        return this.myHashMap.keySet().iterator();
    }

    public int length() {
        return this.myHashMap.size();
    }

    public JSONArray names() {
        JSONArray ja = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.put(keys.next());
        }
        return ja.length() == 0 ? null : ja;
    }

    public static String numberToString(Number n2) throws JSONException {
        if (n2 == null) {
            throw new JSONException("Null pointer");
        }
        JSONObject.testValidity(n2);
        String s2 = n2.toString();
        if (s2.indexOf(46) > 0 && s2.indexOf(101) < 0 && s2.indexOf(69) < 0) {
            while (s2.endsWith("0")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
            if (s2.endsWith(".")) {
                s2 = s2.substring(0, s2.length() - 1);
            }
        }
        return s2;
    }

    public Object opt(String key) {
        return key == null ? null : this.myHashMap.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public JSONObject put(String key, Collection value) throws JSONException {
        this.put(key, new JSONArray(value));
        return this;
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        try {
            Object o2 = this.opt(key);
            return o2 instanceof Number ? ((Number)o2).doubleValue() : new Double((String)o2).doubleValue();
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key) {
        Object o2 = this.opt(key);
        return o2 instanceof JSONArray ? (JSONArray)o2 : null;
    }

    public JSONObject optJSONObject(String key) {
        Object o2 = this.opt(key);
        return o2 instanceof JSONObject ? (JSONObject)o2 : null;
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception e2) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object o2 = this.opt(key);
        return o2 != null ? o2.toString() : defaultValue;
    }

    public JSONObject put(String key, boolean value) throws JSONException {
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String key, double value) throws JSONException {
        this.put(key, new Double(value));
        return this;
    }

    public JSONObject put(String key, int value) throws JSONException {
        this.put(key, new Integer(value));
        return this;
    }

    public JSONObject put(String key, long value) throws JSONException {
        this.put(key, new Long(value));
        return this;
    }

    public JSONObject put(String key, Map value) throws JSONException {
        this.put(key, new JSONObject(value));
        return this;
    }

    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            JSONObject.testValidity(value);
            this.myHashMap.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c2 = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i2 = 0; i2 < len; ++i2) {
            char b2 = c2;
            c2 = string.charAt(i2);
            switch (c2) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c2);
                    continue block9;
                }
                case '/': {
                    if (b2 == '<') {
                        sb.append('\\');
                    }
                    sb.append(c2);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c2 < ' ' || c2 >= '\u0080' && c2 < '\u00a0' || c2 >= '\u2000' && c2 < '\u2100') {
                        String t2 = "000" + Integer.toHexString(c2);
                        sb.append("\\u" + t2.substring(t2.length() - 4));
                        continue block9;
                    }
                    sb.append(c2);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public Object remove(String key) {
        return this.myHashMap.remove(key);
    }

    static void testValidity(Object o2) throws JSONException {
        if (o2 != null && (o2 instanceof Double ? ((Double)o2).isInfinite() || ((Double)o2).isNaN() : o2 instanceof Float && (((Float)o2).isInfinite() || ((Float)o2).isNaN()))) {
            throw new JSONException("JSON does not allow non-finite numbers.");
        }
    }

    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i2 = 0; i2 < names.length(); ++i2) {
            ja.put(this.opt(names.getString(i2)));
        }
        return ja;
    }

    public String toString() {
        try {
            Iterator keys = this.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o2 = keys.next();
                sb.append(JSONObject.quote(o2.toString()));
                sb.append(':');
                sb.append(JSONObject.valueToString(this.myHashMap.get(o2)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String toString(int indentFactor) throws JSONException {
        return this.toString(indentFactor, 0);
    }

    String toString(int indentFactor, int indent) throws JSONException {
        int n2 = this.length();
        if (n2 == 0) {
            return "{}";
        }
        Iterator keys = this.keys();
        StringBuffer sb = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n2 == 1) {
            Object o2 = keys.next();
            sb.append(JSONObject.quote(o2.toString()));
            sb.append(": ");
            sb.append(JSONObject.valueToString(this.myHashMap.get(o2), indentFactor, indent));
        } else {
            int i2;
            while (keys.hasNext()) {
                Object o3 = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i2 = 0; i2 < newindent; ++i2) {
                    sb.append(' ');
                }
                sb.append(JSONObject.quote(o3.toString()));
                sb.append(": ");
                sb.append(JSONObject.valueToString(this.myHashMap.get(o3), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i2 = 0; i2 < indent; ++i2) {
                    sb.append(' ');
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    static String valueToString(Object value) throws JSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof JSONString) {
            String o2;
            try {
                o2 = ((JSONString)value).toJSONString();
            }
            catch (Exception e2) {
                throw new JSONException(e2);
            }
            if (o2 instanceof String) {
                return o2;
            }
            throw new JSONException("Bad value from toJSONString: " + o2);
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONObject || value instanceof JSONArray) {
            return value.toString();
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString();
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString();
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString();
        }
        return JSONObject.quote(value.toString());
    }

    static String valueToString(Object value, int indentFactor, int indent) throws JSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        try {
            String o2;
            if (value instanceof JSONString && (o2 = ((JSONString)value).toJSONString()) instanceof String) {
                return o2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONObject) {
            return ((JSONObject)value).toString(indentFactor, indent);
        }
        if (value instanceof JSONArray) {
            return ((JSONArray)value).toString(indentFactor, indent);
        }
        if (value instanceof Map) {
            return new JSONObject((Map)value).toString(indentFactor, indent);
        }
        if (value instanceof Collection) {
            return new JSONArray((Collection)value).toString(indentFactor, indent);
        }
        if (value.getClass().isArray()) {
            return new JSONArray(value).toString(indentFactor, indent);
        }
        return JSONObject.quote(value.toString());
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            boolean b2 = false;
            Iterator keys = this.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (b2) {
                    writer.write(44);
                }
                Object k2 = keys.next();
                writer.write(JSONObject.quote(k2.toString()));
                writer.write(58);
                Object v2 = this.myHashMap.get(k2);
                if (v2 instanceof JSONObject) {
                    ((JSONObject)v2).write(writer);
                } else if (v2 instanceof JSONArray) {
                    ((JSONArray)v2).write(writer);
                } else {
                    writer.write(JSONObject.valueToString(v2));
                }
                b2 = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException e2) {
            throw new JSONException(e2);
        }
    }

    private static final class Null {
        private Null() {
        }

        protected final Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }
    }
}

