/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.util.Iterator;
import org.json.HTTPTokener;
import org.json.JSONException;
import org.json.JSONObject;

public class HTTP {
    public static final String CRLF = "\r\n";

    public static JSONObject toJSONObject(String string) throws JSONException {
        JSONObject o2 = new JSONObject();
        HTTPTokener x2 = new HTTPTokener(string);
        String t2 = x2.nextToken();
        if (t2.toUpperCase().startsWith("HTTP")) {
            o2.put("HTTP-Version", t2);
            o2.put("Status-Code", x2.nextToken());
            o2.put("Reason-Phrase", x2.nextTo('\u0000'));
            x2.next();
        } else {
            o2.put("Method", t2);
            o2.put("Request-URI", x2.nextToken());
            o2.put("HTTP-Version", x2.nextToken());
        }
        while (x2.more()) {
            String name = x2.nextTo(':');
            x2.next(':');
            o2.put(name, x2.nextTo('\u0000'));
            x2.next();
        }
        return o2;
    }

    public static String toString(JSONObject o2) throws JSONException {
        Iterator keys = o2.keys();
        StringBuffer sb = new StringBuffer();
        if (o2.has("Status-Code") && o2.has("Reason-Phrase")) {
            sb.append(o2.getString("HTTP-Version"));
            sb.append(' ');
            sb.append(o2.getString("Status-Code"));
            sb.append(' ');
            sb.append(o2.getString("Reason-Phrase"));
        } else if (o2.has("Method") && o2.has("Request-URI")) {
            sb.append(o2.getString("Method"));
            sb.append(' ');
            sb.append('\"');
            sb.append(o2.getString("Request-URI"));
            sb.append('\"');
            sb.append(' ');
            sb.append(o2.getString("HTTP-Version"));
        } else {
            throw new JSONException("Not enough material for an HTTP header.");
        }
        sb.append(CRLF);
        while (keys.hasNext()) {
            String s2 = keys.next().toString();
            if (s2.equals("HTTP-Version") || s2.equals("Status-Code") || s2.equals("Reason-Phrase") || s2.equals("Method") || s2.equals("Request-URI") || o2.isNull(s2)) continue;
            sb.append(s2);
            sb.append(": ");
            sb.append(o2.getString(s2));
            sb.append(CRLF);
        }
        sb.append(CRLF);
        return sb.toString();
    }
}

