/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Cookie {
    public static String escape(String string) {
        String s2 = string.trim();
        StringBuffer sb = new StringBuffer();
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 < ' ' || c2 == '+' || c2 == '%' || c2 == '=' || c2 == ';') {
                sb.append('%');
                sb.append(Character.forDigit((char)(c2 >>> 4 & 0xF), 16));
                sb.append(Character.forDigit((char)(c2 & 0xF), 16));
                continue;
            }
            sb.append(c2);
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSONObject toJSONObject(String string) throws JSONException {
        JSONObject o2 = new JSONObject();
        JSONTokener x2 = new JSONTokener(string);
        o2.put("name", x2.nextTo('='));
        x2.next('=');
        o2.put("value", x2.nextTo(';'));
        x2.next();
        while (x2.more()) {
            Object v2;
            String n2 = Cookie.unescape(x2.nextTo("=;"));
            if (x2.next() != '=') {
                if (!n2.equals("secure")) throw x2.syntaxError("Missing '=' in cookie parameter.");
                v2 = Boolean.TRUE;
            } else {
                v2 = Cookie.unescape(x2.nextTo(';'));
                x2.next();
            }
            o2.put(n2, v2);
        }
        return o2;
    }

    public static String toString(JSONObject o2) throws JSONException {
        StringBuffer sb = new StringBuffer();
        sb.append(Cookie.escape(o2.getString("name")));
        sb.append("=");
        sb.append(Cookie.escape(o2.getString("value")));
        if (o2.has("expires")) {
            sb.append(";expires=");
            sb.append(o2.getString("expires"));
        }
        if (o2.has("domain")) {
            sb.append(";domain=");
            sb.append(Cookie.escape(o2.getString("domain")));
        }
        if (o2.has("path")) {
            sb.append(";path=");
            sb.append(Cookie.escape(o2.getString("path")));
        }
        if (o2.optBoolean("secure")) {
            sb.append(";secure");
        }
        return sb.toString();
    }

    public static String unescape(String s2) {
        int len = s2.length();
        StringBuffer b2 = new StringBuffer();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 == '+') {
                c2 = ' ';
            } else if (c2 == '%' && i2 + 2 < len) {
                int d2 = JSONTokener.dehexchar(s2.charAt(i2 + 1));
                int e2 = JSONTokener.dehexchar(s2.charAt(i2 + 2));
                if (d2 >= 0 && e2 >= 0) {
                    c2 = (char)(d2 * 16 + e2);
                    i2 += 2;
                }
            }
            b2.append(c2);
        }
        return b2.toString();
    }
}

