/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionConstructor {
    public static final <E> E construct(String classname, Class<E> targetclass) {
        try {
            Class<?> sclass = Class.forName(classname);
            if (!targetclass.isAssignableFrom(sclass)) {
                throw new ClassCastException("Class '" + classname + "' is not assignable to '" + targetclass.getName() + "'.");
            }
            Constructor<?> constructor = sclass.getConstructor(new Class[0]);
            Object o2 = constructor.newInstance(new Object[0]);
            return targetclass.cast(o2);
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalArgumentException("Unable to locate class '" + classname + "'.", e2);
        }
        catch (NoSuchMethodException e3) {
            throw new IllegalArgumentException("Unable to locate class no-arg constructor '" + classname + "'.", e3);
        }
        catch (SecurityException e4) {
            throw new IllegalStateException("Unable to access class constructor '" + classname + "'.", e4);
        }
        catch (IllegalAccessException e5) {
            throw new IllegalStateException("Unable to access class constructor '" + classname + "'.", e5);
        }
        catch (InstantiationException e6) {
            throw new IllegalStateException("Unable to instantiate class '" + classname + "'.", e6);
        }
        catch (InvocationTargetException e7) {
            throw new IllegalStateException("Unable to call class constructor '" + classname + "'.", e7);
        }
    }
}

