/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.jahia.configuration.configurators.AbstractConfigurator;
import org.jahia.configuration.configurators.ConfigFile;
import org.jahia.configuration.configurators.JahiaConfigInterface;

public class LDAPConfigurator
extends AbstractConfigurator {
    public LDAPConfigurator(Map dbProps, JahiaConfigInterface jahiaConfigInterface) {
        super(dbProps, jahiaConfigInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfiguration(ConfigFile sourceConfigFile, String destFileName) throws Exception {
        Map<String, String> groupProps = this.jahiaConfigInterface.getGroupLdapProviderProperties();
        Map<String, String> userProps = this.jahiaConfigInterface.getUserLdapProviderProperties();
        if (!Boolean.valueOf(this.jahiaConfigInterface.getLdapActivated()).booleanValue() || (groupProps == null || groupProps.isEmpty()) && (userProps == null || userProps.isEmpty())) {
            return;
        }
        SortedProperties ldapProperties = new SortedProperties();
        InputStream skeletonStream = this.getClass().getClassLoader().getResourceAsStream("ldap/org.jahia.services.usermanager.ldap-config.cfg");
        try {
            ldapProperties.load(skeletonStream);
        }
        finally {
            IOUtils.closeQuietly(skeletonStream);
        }
        for (String key : userProps.keySet()) {
            ldapProperties.setProperty("user." + key, userProps.get(key));
        }
        for (String key : groupProps.keySet()) {
            ldapProperties.setProperty("group." + key, groupProps.get(key));
        }
        File destFile = new File(destFileName);
        if (!destFile.exists()) {
            destFile.mkdir();
        }
        FileOutputStream out = new FileOutputStream(new File(destFile, "org.jahia.services.usermanager.ldap-config.cfg"));
        try {
            ldapProperties.store(out, null);
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public class SortedProperties
    extends Properties {
        private static final long serialVersionUID = -6967227749388633813L;
        private final TreeSet<Object> keys;

        public SortedProperties() {
            this.keys = new TreeSet();
        }

        public SortedProperties(Properties defaults) {
            super(defaults);
            this.keys = new TreeSet();
        }

        @Override
        public Set<Object> keySet() {
            return this.keys;
        }

        @Override
        public Enumeration<Object> keys() {
            return Collections.enumeration(this.keys);
        }

        @Override
        public Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }
    }
}

