/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.configurators;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jahia.configuration.configurators.AbstractConfigurator;
import org.jahia.configuration.configurators.JahiaConfigInterface;
import org.jahia.configuration.logging.AbstractLogger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;

public abstract class AbstractXMLConfigurator
extends AbstractConfigurator {
    public AbstractXMLConfigurator(Map dbProps, JahiaConfigInterface jahiaConfigInterface) {
        super(dbProps, jahiaConfigInterface);
    }

    public AbstractXMLConfigurator(Map dbProps, JahiaConfigInterface jahiaConfigInterface, AbstractLogger logger) {
        super(dbProps, jahiaConfigInterface, logger);
    }

    public void insertElementAfter(Document jdomDocument, String xPathExpression, Element element) throws JDOMException {
        Element rootElement = jdomDocument.getRootElement();
        String namespaceURI = rootElement.getNamespaceURI();
        XPath previousElementXPath = XPath.newInstance(xPathExpression);
        if (namespaceURI != null && !"".equals(namespaceURI)) {
            previousElementXPath.addNamespace("xp", namespaceURI);
        }
        Element previousElement = (Element)previousElementXPath.selectSingleNode(jdomDocument);
        int previousElementIndex = previousElement.getParent().indexOf(previousElement);
        previousElement.getParent().getContent().add(previousElementIndex + 1, element);
    }

    public void setElementAttribute(Element scopeElement, String xPathExpression, String attributeName, String attributeValue) throws JDOMException {
        XPath xPath = XPath.newInstance(xPathExpression);
        String namespaceURI = scopeElement.getDocument().getRootElement().getNamespaceURI();
        if (namespaceURI != null && !"".equals(namespaceURI)) {
            xPath.addNamespace("xp", namespaceURI);
        }
        List<?> elementList = xPath.selectNodes(scopeElement);
        for (Element element : elementList) {
            element.setAttribute(attributeName, attributeValue);
        }
    }

    public Element getElement(Element scopeElement, String xPathExpression) throws JDOMException {
        return this.getElement(scopeElement, xPathExpression, scopeElement.getDocument().getRootElement().getNamespaceURI());
    }

    public Element getElement(Element scopeElement, String xPathExpression, String namespaceURI) throws JDOMException {
        XPath xPath = XPath.newInstance(xPathExpression);
        if (namespaceURI != null && namespaceURI.length() > 0) {
            xPath.addNamespace("xp", namespaceURI);
        }
        return (Element)xPath.selectSingleNode(scopeElement);
    }

    public List<Element> getElements(Element scopeElement, String xPathExpression) throws JDOMException {
        LinkedList<Element> elems = new LinkedList<Element>();
        XPath xPath = XPath.newInstance(xPathExpression);
        String namespaceURI = scopeElement.getDocument().getRootElement().getNamespaceURI();
        if (namespaceURI != null && !"".equals(namespaceURI)) {
            xPath.addNamespace("xp", namespaceURI);
        }
        for (Object obj : xPath.selectNodes(scopeElement)) {
            if (!(obj instanceof Element)) continue;
            elems.add((Element)obj);
        }
        return elems;
    }

    protected void removeElementIfExists(Element scopeElement, String xPathExpression) throws JDOMException {
        Element el = this.getElement(scopeElement, xPathExpression);
        if (el != null) {
            el.getParent().removeContent(el);
        }
    }

    protected void removeAllElements(Element scopeElement, String xPathExpression) throws JDOMException {
        for (Element el : this.getElements(scopeElement, xPathExpression)) {
            el.getParent().removeContent(el);
        }
    }

    protected final void write(Document document, File destination) throws IOException {
        String lineSeparator = System.getProperty("line.separator");
        Format format = Format.getPrettyFormat().setLineSeparator(lineSeparator);
        this.write(document, destination, format);
    }

    protected final void write(Document document, File destination, Format format) throws IOException {
        XMLOutputter outputter = new XMLOutputter(format);
        try (FileOutputStream out = new FileOutputStream(destination);){
            outputter.output(document, (OutputStream)out);
        }
    }
}

