/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.commons;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;

public final class DatabaseScripts {
    private DatabaseScripts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getScriptStatements(Reader reader) throws IOException {
        LinkedList<String> scriptsRuntimeList = new LinkedList<String>();
        try (BufferedReader buffered = new BufferedReader(reader);){
            String buffer = "";
            StringBuilder curSQLStatement = new StringBuilder();
            while ((buffer = buffered.readLine()) != null) {
                String bufferLowerCase;
                if (buffer != null && buffer.trim().equals("/")) continue;
                int commentPos = buffer.indexOf(35);
                if (commentPos != -1 && !DatabaseScripts.isInQuotes(buffer, commentPos)) {
                    buffer = buffer.substring(0, commentPos);
                }
                if ((commentPos = buffer.indexOf("//")) != -1 && !DatabaseScripts.isInQuotes(buffer, commentPos)) {
                    buffer = buffer.substring(0, commentPos);
                }
                if ((commentPos = buffer.indexOf("/*")) != -1 && !DatabaseScripts.isInQuotes(buffer, commentPos)) {
                    buffer = buffer.substring(0, commentPos);
                }
                if ((commentPos = buffer.indexOf("REM ")) != -1 && !DatabaseScripts.isInQuotes(buffer, commentPos)) {
                    buffer = buffer.substring(0, commentPos);
                }
                if ((commentPos = buffer.indexOf("--")) != -1 && !DatabaseScripts.isInQuotes(buffer, commentPos)) {
                    buffer = buffer.substring(0, commentPos);
                }
                if (buffer.trim().length() == 0 || (bufferLowerCase = (buffer = buffer.trim()).toLowerCase()).startsWith("delimiter ")) continue;
                if (buffer.endsWith(";")) {
                    curSQLStatement.append(buffer.substring(0, bufferLowerCase.endsWith("end;") || bufferLowerCase.endsWith("end $$;") ? buffer.length() : buffer.length() - 1));
                    String sqlStatement = curSQLStatement.toString().trim();
                    if (!"".equals(sqlStatement)) {
                        String sqlStatementLowerCase = sqlStatement.toLowerCase();
                        if (sqlStatementLowerCase.endsWith("end $$;")) {
                            sqlStatement = sqlStatement.substring(0, sqlStatement.length() - " $$;".length()) + ";";
                        }
                        scriptsRuntimeList.add(sqlStatement);
                    }
                    curSQLStatement = new StringBuilder();
                    continue;
                }
                curSQLStatement.append(buffer);
                curSQLStatement.append('\n');
            }
            String sqlStatement = curSQLStatement.toString().trim();
            if (!"".equals(sqlStatement)) {
                scriptsRuntimeList.add(sqlStatement);
            }
        }
        return scriptsRuntimeList;
    }

    private static boolean isInQuotes(String sqlStatement, int pos) {
        if (pos < 0) {
            return false;
        }
        String beforeStr = sqlStatement.substring(0, pos);
        int quoteCount = 0;
        int curPos = 0;
        int quotePos = beforeStr.indexOf(39);
        while (quotePos != -1) {
            ++quoteCount;
            curPos = quotePos + 1;
            quotePos = beforeStr.indexOf(39, curPos);
        }
        return quoteCount % 2 != 0;
    }

    public static void executeScript(Reader scriptContent, Connection conn) throws SQLException, IOException {
        DatabaseScripts.executeStatements(DatabaseScripts.getScriptStatements(scriptContent), conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void executeStatements(List<String> sqlStatements, Connection conn) throws SQLException {
        if (sqlStatements.isEmpty()) {
            return;
        }
        Statement stmt = conn.createStatement();
        try {
            for (String sql : sqlStatements) {
                try {
                    stmt.execute(sql);
                }
                catch (SQLException e2) {
                    String lowerCaseSql = sql.toLowerCase();
                    if (lowerCaseSql.startsWith("drop ") || lowerCaseSql.contains(" drop ") || lowerCaseSql.contains("\ndrop ") || lowerCaseSql.contains(" drop\n") || lowerCaseSql.contains("\ndrop\n")) continue;
                    if (!lowerCaseSql.startsWith("alter table") && !lowerCaseSql.startsWith("create index")) throw e2;
                    System.err.println("Error executing statement:\n" + sql);
                    System.err.println(e2.getMessage());
                    e2.printStackTrace();
                    continue;
                    return;
                }
            }
        }
        finally {
            if (!stmt.isClosed()) {
                stmt.close();
            }
        }
    }
}

