/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.File;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;

final class FileEntryIterator
implements Iterator<String> {
    private final String rootPath;
    private final Deque<String> entryNames = new ArrayDeque<String>();
    private final boolean recurse;

    FileEntryIterator(URL url, String subPath, boolean recurse) {
        this.rootPath = FileEntryIterator.normalizePath(FileEntryIterator.toFile(url).getAbsoluteFile());
        this.recurse = recurse;
        this.appendEntries(subPath);
    }

    @Override
    public boolean hasNext() {
        return this.entryNames.size() > 0;
    }

    @Override
    public String next() {
        String name = this.entryNames.removeFirst();
        if (this.recurse && name.endsWith("/")) {
            this.appendEntries(name);
        }
        return name;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static File toFile(URL url) {
        StringBuilder buf = new StringBuilder();
        String authority = url.getAuthority();
        if (authority != null && authority.length() > 0) {
            buf.append(File.separatorChar).append(File.separatorChar).append(authority);
        }
        String path = url.getPath();
        int i2 = 0;
        int length = path.length();
        while (i2 < length) {
            char c2 = path.charAt(i2);
            if ('/' == c2) {
                buf.append(File.separatorChar);
            } else if ('%' == c2 && i2 < length - 2) {
                int hi = Character.digit(path.charAt(i2 + 1), 16);
                int lo = Character.digit(path.charAt(i2 + 2), 16);
                if (hi >= 0 && lo >= 0) {
                    buf.append((char)(hi << 4 | lo));
                    i2 += 2;
                } else {
                    buf.append('%');
                }
            } else {
                buf.append(c2);
            }
            ++i2;
        }
        return new File(buf.toString());
    }

    private void appendEntries(String subPath) {
        File[] listing = new File(String.valueOf(this.rootPath) + subPath).listFiles();
        if (listing != null) {
            File[] fileArray = listing;
            int n2 = listing.length;
            int n3 = 0;
            while (n3 < n2) {
                File f2 = fileArray[n3];
                this.entryNames.add(FileEntryIterator.normalizePath(f2).substring(this.rootPath.length()));
                ++n3;
            }
        }
    }

    private static String normalizePath(File file) {
        return file.toURI().getPath();
    }
}

