/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.sisu.bean.BeanLifecycle;
import org.eclipse.sisu.bean.BeanManager;
import org.eclipse.sisu.bean.BeanProperty;
import org.eclipse.sisu.bean.BeanScheduler;
import org.eclipse.sisu.bean.LifecycleBuilder;
import org.eclipse.sisu.bean.PropertyBinding;

public final class LifecycleManager
extends BeanScheduler
implements BeanManager {
    private final LifecycleBuilder builder = new LifecycleBuilder();
    private final Map<Class<?>, BeanLifecycle> lifecycles = new ConcurrentHashMap();
    private final List<Object> stoppableBeans = new ArrayList<Object>();

    @Override
    public boolean manage(Class<?> clazz) {
        return this.buildLifecycle(clazz);
    }

    @Override
    public PropertyBinding manage(BeanProperty<?> property) {
        return null;
    }

    @Override
    public boolean manage(Object bean) {
        BeanLifecycle lifecycle = this.lifecycleFor(bean);
        if (lifecycle.isStoppable()) {
            this.pushStoppable(bean);
        }
        if (lifecycle.isStartable()) {
            this.schedule(bean);
        }
        return true;
    }

    @Override
    public boolean unmanage(Object bean) {
        if (this.removeStoppable(bean)) {
            this.lifecycleFor(bean).stop(bean);
        }
        return true;
    }

    @Override
    public boolean unmanage() {
        Object bean;
        while ((bean = this.popStoppable()) != null) {
            this.lifecycleFor(bean).stop(bean);
        }
        return true;
    }

    @Override
    protected void activate(Object bean) {
        this.lifecycleFor(bean).start(bean);
    }

    private boolean buildLifecycle(Class<?> clazz) {
        BeanLifecycle lifecycle = this.lifecycles.get(clazz);
        if (lifecycle == null) {
            lifecycle = this.builder.build(clazz);
            this.lifecycles.put(clazz, lifecycle);
        }
        return lifecycle != BeanLifecycle.NO_OP;
    }

    private BeanLifecycle lifecycleFor(Object bean) {
        if (bean != null) {
            Class<?> c2 = bean.getClass();
            while (c2 != null && c2 != Object.class) {
                BeanLifecycle lifecycle = this.lifecycles.get(c2);
                if (lifecycle != null) {
                    return lifecycle;
                }
                c2 = c2.getSuperclass();
            }
        }
        return BeanLifecycle.NO_OP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pushStoppable(Object bean) {
        List<Object> list = this.stoppableBeans;
        synchronized (list) {
            return this.stoppableBeans.add(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeStoppable(Object bean) {
        List<Object> list = this.stoppableBeans;
        synchronized (list) {
            return this.stoppableBeans.remove(bean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object popStoppable() {
        List<Object> list = this.stoppableBeans;
        synchronized (list) {
            int size = this.stoppableBeans.size();
            return size > 0 ? this.stoppableBeans.remove(size - 1) : null;
        }
    }
}

