/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.codehaus.plexus.components.io.functions.FileSupplier;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.IOUtil;

public class ResourceUtils {
    private ResourceUtils() {
    }

    public static boolean isUptodate(PlexusIoResource source, File destination) {
        return ResourceUtils.isUptodate(source, destination.lastModified());
    }

    public static boolean isUptodate(PlexusIoResource source, long destinationDate) {
        long s2 = source.getLastModified();
        if (s2 == 0L) {
            return false;
        }
        if (destinationDate == 0L) {
            return false;
        }
        return destinationDate > s2;
    }

    public static boolean isUptodate(long sourceDate, long destinationDate) {
        if (sourceDate == 0L) {
            return false;
        }
        if (destinationDate == 0L) {
            return false;
        }
        return destinationDate > sourceDate;
    }

    public static void copyFile(PlexusIoResource in, File outFile) throws IOException {
        try (InputStream input = in.getContents();
             FileOutputStream output = new FileOutputStream(outFile);){
            IOUtil.copy(input, (OutputStream)output);
        }
    }

    public static void copyFile(InputStream input, File outFile) throws IOException {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(outFile);
            IOUtil.copy(input, (OutputStream)output);
            ((OutputStream)output).close();
            output = null;
            input.close();
            input = null;
        }
        finally {
            IOUtil.close(input);
            IOUtil.close(output);
        }
    }

    public static boolean isSame(PlexusIoResource resource, File file) {
        if (resource instanceof FileSupplier) {
            File resourceFile = ((FileSupplier)((Object)resource)).getFile();
            return file.equals(resourceFile);
        }
        return false;
    }

    public static boolean isCanonicalizedSame(PlexusIoResource resource, File file) throws IOException {
        if (resource instanceof FileSupplier) {
            File resourceFile = ((FileSupplier)((Object)resource)).getFile();
            return file.getCanonicalFile().equals(resourceFile.getCanonicalFile());
        }
        return false;
    }
}

