/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.tar;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.tar.TarFile;
import org.codehaus.plexus.archiver.tar.TarResource;
import org.codehaus.plexus.archiver.util.Streams;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.iq80.snappy.SnappyInputStream;

public class TarUnArchiver
extends AbstractUnArchiver {
    private UntarCompressionMethod compression = UntarCompressionMethod.NONE;

    public TarUnArchiver() {
    }

    public TarUnArchiver(File sourceFile) {
        super(sourceFile);
    }

    public void setCompression(UntarCompressionMethod method) {
        this.compression = method;
    }

    public void setEncoding(String encoding) {
        this.getLogger().warn("The TarUnArchiver doesn't support the encoding attribute");
    }

    @Override
    protected void execute() throws ArchiverException {
        this.execute(this.getSourceFile(), this.getDestDirectory(), this.getFileMappers());
    }

    @Override
    protected void execute(String path, File outputDirectory) {
        this.execute(new File(path), this.getDestDirectory(), this.getFileMappers());
    }

    protected void execute(File sourceFile, File destDirectory, FileMapper[] fileMappers) throws ArchiverException {
        try {
            this.getLogger().info("Expanding: " + sourceFile + " into " + destDirectory);
            TarFile tarFile = new TarFile(sourceFile);
            try (TarArchiveInputStream tis = new TarArchiveInputStream(this.decompress(this.compression, sourceFile, new BufferedInputStream(new FileInputStream(sourceFile))));){
                TarArchiveEntry te;
                while ((te = tis.getNextTarEntry()) != null) {
                    TarResource fileInfo = new TarResource(tarFile, te);
                    if (!this.isSelected(te.getName(), fileInfo)) continue;
                    String symlinkDestination = te.isSymbolicLink() ? te.getLinkName() : null;
                    this.extractFile(sourceFile, destDirectory, tis, te.getName(), te.getModTime(), te.isDirectory(), te.getMode() != 0 ? Integer.valueOf(te.getMode()) : null, symlinkDestination, fileMappers);
                }
                this.getLogger().debug("expand complete");
            }
        }
        catch (IOException ioe) {
            throw new ArchiverException("Error while expanding " + sourceFile.getAbsolutePath(), ioe);
        }
    }

    private InputStream decompress(UntarCompressionMethod compression, File file, InputStream istream) throws IOException, ArchiverException {
        if (compression == UntarCompressionMethod.GZIP) {
            return Streams.bufferedInputStream(new GZIPInputStream(istream));
        }
        if (compression == UntarCompressionMethod.BZIP2) {
            return new BZip2CompressorInputStream(istream);
        }
        if (compression == UntarCompressionMethod.SNAPPY) {
            return new SnappyInputStream(istream, true);
        }
        if (compression == UntarCompressionMethod.XZ) {
            return new XZCompressorInputStream(istream);
        }
        return istream;
    }

    public static enum UntarCompressionMethod {
        NONE("none"),
        GZIP("gzip"),
        BZIP2("bzip2"),
        SNAPPY("snappy"),
        XZ("xz");

        final String value;

        private UntarCompressionMethod(String value) {
            this.value = value;
        }
    }
}

