/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.gzip;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.Streams;

public class GZipUnArchiver
extends AbstractUnArchiver {
    private static final String OPERATION_GZIP = "gzip";

    public GZipUnArchiver() {
    }

    public GZipUnArchiver(File sourceFile) {
        super(sourceFile);
    }

    @Override
    protected void execute() throws ArchiverException {
        if (this.getSourceFile().lastModified() > this.getDestFile().lastModified()) {
            this.getLogger().info("Expanding " + this.getSourceFile().getAbsolutePath() + " to " + this.getDestFile().getAbsolutePath());
            Streams.copyFully(this.getGzipInputStream(Streams.fileInputStream(this.getSourceFile(), OPERATION_GZIP)), Streams.fileOutputStream(this.getDestFile(), OPERATION_GZIP), OPERATION_GZIP);
        }
    }

    private InputStream getGzipInputStream(FileInputStream in) throws ArchiverException {
        try {
            return Streams.bufferedInputStream(new GZIPInputStream(in));
        }
        catch (IOException e2) {
            throw new ArchiverException("Problem creating GZIP input stream", e2);
        }
    }

    @Override
    protected void execute(String path, File outputDirectory) {
        throw new UnsupportedOperationException("Targeted extraction not supported in GZIP format.");
    }
}

