/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.bzip2;

import java.io.IOException;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.Compressor;
import org.codehaus.plexus.archiver.util.Streams;

public class BZip2Compressor
extends Compressor {
    private BZip2CompressorOutputStream zOut;

    @Override
    public void compress() throws ArchiverException {
        try {
            this.zOut = new BZip2CompressorOutputStream(Streams.bufferedOutputStream(Streams.fileOutputStream(this.getDestFile())));
            this.compress(this.getSource(), this.zOut);
        }
        catch (IOException ioe) {
            String msg = "Problem creating bzip2 " + ioe.getMessage();
            throw new ArchiverException(msg, ioe);
        }
    }

    @Override
    public void close() {
        try {
            if (this.zOut != null) {
                this.zOut.close();
                this.zOut = null;
            }
        }
        catch (IOException e2) {
            throw new ArchiverException("Failure closing target.", e2);
        }
    }
}

