/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class SlowPeerReports {
    @Nonnull
    private final Map<String, Double> slowPeers;
    public static final SlowPeerReports EMPTY_REPORT = new SlowPeerReports(ImmutableMap.of());

    private SlowPeerReports(Map<String, Double> slowPeers) {
        this.slowPeers = slowPeers;
    }

    public static SlowPeerReports create(@Nullable Map<String, Double> slowPeers) {
        if (slowPeers == null || slowPeers.isEmpty()) {
            return EMPTY_REPORT;
        }
        return new SlowPeerReports(slowPeers);
    }

    public Map<String, Double> getSlowPeers() {
        return this.slowPeers;
    }

    public boolean haveSlowPeers() {
        return this.slowPeers.size() > 0;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof SlowPeerReports)) {
            return false;
        }
        SlowPeerReports that = (SlowPeerReports)o2;
        return this.slowPeers.equals(that.slowPeers);
    }

    public int hashCode() {
        return this.slowPeers.hashCode();
    }
}

