/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.hdfs.protocol.ReconfigurationProtocol;
import org.apache.hadoop.hdfs.protocol.proto.ReconfigurationProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolUtils;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.ProtocolMetaInterface;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcClientUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ReconfigurationProtocolTranslatorPB
implements ProtocolMetaInterface,
ReconfigurationProtocol,
ProtocolTranslator,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(ReconfigurationProtocolTranslatorPB.class);
    private static final RpcController NULL_CONTROLLER = null;
    private static final ReconfigurationProtocolProtos.StartReconfigurationRequestProto VOID_START_RECONFIG = ReconfigurationProtocolProtos.StartReconfigurationRequestProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.ListReconfigurablePropertiesRequestProto VOID_LIST_RECONFIGURABLE_PROPERTIES = ReconfigurationProtocolProtos.ListReconfigurablePropertiesRequestProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.GetReconfigurationStatusRequestProto VOID_GET_RECONFIG_STATUS = ReconfigurationProtocolProtos.GetReconfigurationStatusRequestProto.newBuilder().build();
    private final ReconfigurationProtocolPB rpcProxy;

    public ReconfigurationProtocolTranslatorPB(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        this.rpcProxy = ReconfigurationProtocolTranslatorPB.createReconfigurationProtocolProxy(addr, ticket, conf, factory, 0);
    }

    static ReconfigurationProtocolPB createReconfigurationProtocolProxy(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int socketTimeout) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ReconfigurationProtocolPB.class, ProtobufRpcEngine2.class);
        return (ReconfigurationProtocolPB)RPC.getProxy(ReconfigurationProtocolPB.class, (long)RPC.getProtocolVersion(ReconfigurationProtocolPB.class), (InetSocketAddress)addr, (UserGroupInformation)ticket, (Configuration)conf, (SocketFactory)factory, (int)socketTimeout);
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public void startReconfiguration() throws IOException {
        try {
            this.rpcProxy.startReconfiguration(NULL_CONTROLLER, VOID_START_RECONFIG);
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public ReconfigurationTaskStatus getReconfigurationStatus() throws IOException {
        try {
            return ReconfigurationProtocolUtils.getReconfigurationStatus(this.rpcProxy.getReconfigurationStatus(NULL_CONTROLLER, VOID_GET_RECONFIG_STATUS));
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    @Override
    public List<String> listReconfigurableProperties() throws IOException {
        try {
            ReconfigurationProtocolProtos.ListReconfigurablePropertiesResponseProto response = this.rpcProxy.listReconfigurableProperties(NULL_CONTROLLER, VOID_LIST_RECONFIGURABLE_PROPERTIES);
            return response.getNameList();
        }
        catch (ServiceException e2) {
            throw ProtobufHelper.getRemoteException((ServiceException)e2);
        }
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, ReconfigurationProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(ReconfigurationProtocolPB.class), (String)methodName);
    }
}

