/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsNamedFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface HdfsFileStatus
extends Writable,
Comparable<Object>,
Serializable,
ObjectInputValidation {
    public static final byte[] EMPTY_NAME;

    public long getFileId();

    public FileEncryptionInfo getFileEncryptionInfo();

    default public boolean isEmptyLocalName() {
        return this.getLocalNameInBytes().length == 0;
    }

    default public String getLocalName() {
        return DFSUtilClient.bytes2String(this.getLocalNameInBytes());
    }

    public byte[] getLocalNameInBytes();

    default public String getFullName(String parent) {
        if (this.isEmptyLocalName()) {
            return parent;
        }
        StringBuilder fullName = new StringBuilder(parent);
        if (!parent.endsWith("/")) {
            fullName.append("/");
        }
        fullName.append(this.getLocalName());
        return fullName.toString();
    }

    default public Path getFullPath(Path parent) {
        if (this.isEmptyLocalName()) {
            return parent;
        }
        return new Path(parent, this.getLocalName());
    }

    public byte[] getSymlinkInBytes();

    public int getChildrenNum();

    public ErasureCodingPolicy getErasureCodingPolicy();

    public byte getStoragePolicy();

    default public FileStatus makeQualified(URI defaultUri, Path parent) {
        this.setPath(this.getFullPath(parent).makeQualified(defaultUri, null));
        return (FileStatus)this;
    }

    public Path getPath();

    public void setPath(Path var1);

    public long getLen();

    public boolean isFile();

    public boolean isDirectory();

    public boolean isDir();

    public boolean isSymlink();

    public long getBlockSize();

    public short getReplication();

    public long getModificationTime();

    public long getAccessTime();

    public FsPermission getPermission();

    public void setPermission(FsPermission var1);

    public String getOwner();

    public void setOwner(String var1);

    public String getGroup();

    public void setGroup(String var1);

    public boolean hasAcl();

    public boolean isEncrypted();

    public boolean isErasureCoded();

    public boolean isSnapshotEnabled();

    public Path getSymlink() throws IOException;

    public void setSymlink(Path var1);

    @Override
    public int compareTo(FileStatus var1);

    public static FsPermission convert(boolean isdir, boolean symlink, FsPermission p2, Set<Flags> f2) {
        if (p2 instanceof FsPermissionExtension) {
            if (!1.$assertionsDisabled && p2.getAclBit() != f2.contains((Object)Flags.HAS_ACL)) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && p2.getEncryptedBit() != f2.contains((Object)Flags.HAS_CRYPT)) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && p2.getErasureCodedBit() != f2.contains((Object)Flags.HAS_EC)) {
                throw new AssertionError();
            }
            return p2;
        }
        if (null == p2) {
            p2 = isdir ? FsPermission.getDirDefault() : (symlink ? FsPermission.getDefault() : FsPermission.getFileDefault());
        }
        return new FsPermissionExtension(p2, f2.contains((Object)Flags.HAS_ACL), f2.contains((Object)Flags.HAS_CRYPT), f2.contains((Object)Flags.HAS_EC));
    }

    public static Set<FileStatus.AttrFlags> convert(Set<Flags> flags) {
        if (flags.isEmpty()) {
            return FileStatus.NONE;
        }
        EnumSet<FileStatus.AttrFlags> attr = EnumSet.noneOf(FileStatus.AttrFlags.class);
        if (flags.contains((Object)Flags.HAS_ACL)) {
            attr.add(FileStatus.AttrFlags.HAS_ACL);
        }
        if (flags.contains((Object)Flags.HAS_EC)) {
            attr.add(FileStatus.AttrFlags.HAS_EC);
        }
        if (flags.contains((Object)Flags.HAS_CRYPT)) {
            attr.add(FileStatus.AttrFlags.HAS_CRYPT);
        }
        if (flags.contains((Object)Flags.SNAPSHOT_ENABLED)) {
            attr.add(FileStatus.AttrFlags.SNAPSHOT_ENABLED);
        }
        return attr;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        EMPTY_NAME = new byte[0];
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class Builder {
        private long length = 0L;
        private boolean isdir = false;
        private int replication = 0;
        private long blocksize = 0L;
        private long mtime = 0L;
        private long atime = 0L;
        private FsPermission permission = null;
        private EnumSet<Flags> flags = EnumSet.noneOf(Flags.class);
        private String owner = null;
        private String group = null;
        private byte[] symlink = null;
        private byte[] path = EMPTY_NAME;
        private long fileId = -1L;
        private int childrenNum = 0;
        private FileEncryptionInfo feInfo = null;
        private byte storagePolicy = 0;
        private ErasureCodingPolicy ecPolicy = null;
        private LocatedBlocks locations = null;

        public Builder length(long length) {
            this.length = length;
            return this;
        }

        public Builder isdir(boolean isdir) {
            this.isdir = isdir;
            return this;
        }

        public Builder replication(int replication) {
            this.replication = replication;
            return this;
        }

        public Builder blocksize(long blocksize) {
            this.blocksize = blocksize;
            return this;
        }

        public Builder mtime(long mtime) {
            this.mtime = mtime;
            return this;
        }

        public Builder atime(long atime) {
            this.atime = atime;
            return this;
        }

        public Builder perm(FsPermission permission) {
            this.permission = permission;
            return this;
        }

        public Builder flags(EnumSet<Flags> flags) {
            this.flags = flags;
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder symlink(byte[] symlink) {
            this.symlink = null == symlink ? null : Arrays.copyOf(symlink, symlink.length);
            return this;
        }

        public Builder path(byte[] path) {
            this.path = null == path ? null : Arrays.copyOf(path, path.length);
            return this;
        }

        public Builder fileId(long fileId) {
            this.fileId = fileId;
            return this;
        }

        public Builder children(int childrenNum) {
            this.childrenNum = childrenNum;
            return this;
        }

        public Builder feInfo(FileEncryptionInfo feInfo) {
            this.feInfo = feInfo;
            return this;
        }

        public Builder storagePolicy(byte storagePolicy) {
            this.storagePolicy = storagePolicy;
            return this;
        }

        public Builder ecPolicy(ErasureCodingPolicy ecPolicy) {
            this.ecPolicy = ecPolicy;
            return this;
        }

        public Builder locations(LocatedBlocks locations) {
            this.locations = locations;
            return this;
        }

        public HdfsFileStatus build() {
            if (null == this.locations && !this.isdir && null == this.symlink) {
                return new HdfsNamedFileStatus(this.length, this.isdir, this.replication, this.blocksize, this.mtime, this.atime, this.permission, this.flags, this.owner, this.group, this.symlink, this.path, this.fileId, this.childrenNum, this.feInfo, this.storagePolicy, this.ecPolicy);
            }
            return new HdfsLocatedFileStatus(this.length, this.isdir, this.replication, this.blocksize, this.mtime, this.atime, this.permission, this.flags, this.owner, this.group, this.symlink, this.path, this.fileId, this.childrenNum, this.feInfo, this.storagePolicy, this.ecPolicy, this.locations);
        }
    }

    public static enum Flags {
        HAS_ACL,
        HAS_CRYPT,
        HAS_EC,
        SNAPSHOT_ENABLED;

    }
}

