/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.tools;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.ijException;

public class JDBCDisplayUtil {
    private static final int MINWIDTH = 4;
    private static int maxWidth = 128;
    private static boolean showSelectCount = false;
    private static final int MAX_RETRIES = 0;

    public static boolean getShowSelectCount() {
        return showSelectCount;
    }

    public static void setShowSelectCount(boolean bl) {
        showSelectCount = bl;
    }

    public static void ShowException(PrintWriter printWriter, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof SQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, (SQLException)throwable);
        } else {
            throwable.printStackTrace(printWriter);
        }
    }

    public static void ShowSQLException(PrintWriter printWriter, SQLException sQLException) {
        String string = JDBCDisplayUtil.getSystemBoolean("ij.showErrorCode") ? LocalizedResource.getMessage("UT_Error0", LocalizedResource.getNumber(sQLException.getErrorCode())) : "";
        while (sQLException != null) {
            String string2 = JDBCDisplayUtil.mapNull(sQLException.getSQLState(), LocalizedResource.getMessage("UT_NoSqlst", new Object[0]));
            String string3 = JDBCDisplayUtil.mapNull(sQLException.getMessage(), LocalizedResource.getMessage("UT_NoMessa", new Object[0]));
            printWriter.println(LocalizedResource.getMessage("UT_Error012", string2, string3, string));
            JDBCDisplayUtil.doTrace(printWriter, (Exception)sQLException);
            sQLException = sQLException.getNextException();
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, Connection connection) {
        try {
            Object var2_2 = null;
            if (connection != null) {
                JDBCDisplayUtil.ShowWarnings(printWriter, connection.getWarnings());
            }
            if (connection != null) {
                connection.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, SQLWarning sQLWarning) {
        while (sQLWarning != null) {
            String string = JDBCDisplayUtil.mapNull(sQLWarning.getSQLState(), LocalizedResource.getMessage("UT_NoSqlst_7", new Object[0]));
            String string2 = JDBCDisplayUtil.mapNull(sQLWarning.getMessage(), LocalizedResource.getMessage("UT_NoMessa_8", new Object[0]));
            printWriter.println(LocalizedResource.getMessage("UT_Warni01", string, string2));
            sQLWarning = sQLWarning.getNextWarning();
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, ResultSet resultSet) {
        try {
            Object var2_2 = null;
            if (resultSet != null) {
                JDBCDisplayUtil.ShowWarnings(printWriter, resultSet.getWarnings());
            }
            if (resultSet != null) {
                resultSet.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
        }
    }

    public static void ShowWarnings(PrintWriter printWriter, Statement statement) {
        try {
            Object var2_2 = null;
            if (statement != null) {
                JDBCDisplayUtil.ShowWarnings(printWriter, statement.getWarnings());
            }
            if (statement != null) {
                statement.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
        }
    }

    public static void DisplayResults(PrintWriter printWriter, Statement statement, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printWriter, statement, connection, 0, null, null);
    }

    private static void indent_DisplayResults(PrintWriter printWriter, Statement statement, Connection connection, int n2, int[] nArray, int[] nArray2) throws SQLException {
        JDBCDisplayUtil.checkNotNull(statement, "Statement");
        ResultSet resultSet = statement.getResultSet();
        if (resultSet != null) {
            JDBCDisplayUtil.indent_DisplayResults(printWriter, resultSet, connection, n2, nArray, nArray2);
            resultSet.close();
        } else {
            JDBCDisplayUtil.DisplayUpdateCount(printWriter, statement.getUpdateCount(), n2);
        }
        JDBCDisplayUtil.ShowWarnings(printWriter, statement);
    }

    static void DisplayUpdateCount(PrintWriter printWriter, int n2, int n3) {
        if (n2 == 1) {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n3, LocalizedResource.getMessage("UT_1RowInserUpdatDelet", new Object[0]));
        } else if (n2 >= 0) {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n3, LocalizedResource.getMessage("UT_0RowsInserUpdatDelet", LocalizedResource.getNumber(n2)));
        } else {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n3, LocalizedResource.getMessage("UT_StateExecu", new Object[0]));
        }
    }

    private static int[] getColumnDisplayWidths(ResultSetMetaData resultSetMetaData, int[] nArray, boolean bl) throws SQLException {
        int n2 = nArray == null ? resultSetMetaData.getColumnCount() : nArray.length;
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray == null ? i2 + 1 : nArray[i2];
            int n4 = bl ? LocalizedResource.getInstance().getColumnDisplaySize(resultSetMetaData, n3) : resultSetMetaData.getColumnDisplaySize(n3);
            nArray2[i2] = Math.min(maxWidth, Math.max(resultSetMetaData.isNullable(n3) == 0 ? 0 : 4, n4));
        }
        return nArray2;
    }

    public static void DisplayMultipleResults(PrintWriter printWriter, List<ResultSet> list, Connection connection, int[] nArray, int[] nArray2) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printWriter, list, connection, 0, nArray, nArray2);
    }

    public static void DisplayResults(PrintWriter printWriter, ResultSet resultSet, Connection connection, int[] nArray, int[] nArray2) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printWriter, resultSet, connection, 0, nArray, nArray2);
    }

    private static void indent_DisplayResults(PrintWriter printWriter, ResultSet resultSet, Connection connection, int n2, int[] nArray, int[] nArray2) throws SQLException {
        ArrayList<ResultSet> arrayList = new ArrayList<ResultSet>();
        arrayList.add(resultSet);
        JDBCDisplayUtil.indent_DisplayResults(printWriter, arrayList, connection, 0, nArray, nArray2);
    }

    private static void indent_DisplayResults(PrintWriter printWriter, List<ResultSet> list, Connection connection, int n2, int[] nArray, int[] nArray2) throws SQLException {
        ResultSetMetaData resultSetMetaData = null;
        if (list != null && list.size() > 0) {
            resultSetMetaData = list.get(0).getMetaData();
        }
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n3 = 0;
        Vector<ResultSet> vector = !connection.getAutoCommit() ? new Vector<ResultSet>() : null;
        if (nArray2 == null) {
            nArray2 = JDBCDisplayUtil.getColumnDisplayWidths(resultSetMetaData, nArray, true);
        }
        int n4 = JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, n2, nArray, nArray2);
        int n5 = 0;
        ResultSet resultSet = null;
        boolean bl = true;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            resultSet = list.get(i2);
            bl = true;
            while (bl) {
                try {
                    bl = resultSet.next();
                    if (!bl) continue;
                    JDBCDisplayUtil.DisplayRow(printWriter, resultSet, resultSetMetaData, n4, vector, connection, n2, nArray, nArray2);
                    JDBCDisplayUtil.ShowWarnings(printWriter, resultSet);
                    ++n3;
                }
                catch (SQLException sQLException) {
                    if (++n5 > 0) {
                        throw sQLException;
                    }
                    JDBCDisplayUtil.ShowSQLException(printWriter, sQLException);
                }
            }
        }
        if (showSelectCount) {
            if (n3 == 1) {
                printWriter.println();
                JDBCDisplayUtil.indentedPrintLine(printWriter, n2, LocalizedResource.getMessage("UT_1RowSelec", new Object[0]));
            } else if (n3 >= 0) {
                printWriter.println();
                JDBCDisplayUtil.indentedPrintLine(printWriter, n2, LocalizedResource.getMessage("UT_0RowsSelec", LocalizedResource.getNumber(n3)));
            }
        }
        JDBCDisplayUtil.DisplayNestedResults(printWriter, vector, connection, n2);
        vector = null;
    }

    private static void DisplayNestedResults(PrintWriter printWriter, Vector<ResultSet> vector, Connection connection, int n2) throws SQLException {
        if (vector == null) {
            return;
        }
        String string = LocalizedResource.getMessage("UT_JDBCDisplayUtil_16", new Object[0]);
        String string2 = "0";
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            LocalizedResource.OutputWriter().println();
            String string3 = Integer.toString(i2);
            if (string3.length() > string2.length()) {
                string2 = string3;
                string = string + LocalizedResource.getMessage("UT_JDBCDisplayUtil_17", new Object[0]);
            }
            LocalizedResource.OutputWriter().println(string);
            LocalizedResource.OutputWriter().println(LocalizedResource.getMessage("UT_Resul0", LocalizedResource.getNumber(i2)));
            LocalizedResource.OutputWriter().println(string);
            JDBCDisplayUtil.indent_DisplayResults(printWriter, vector.elementAt(i2), connection, n2, null, null);
        }
    }

    public static void DisplayNextRow(PrintWriter printWriter, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayNextRow(printWriter, resultSet, connection, 0, null, resultSet == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(resultSet.getMetaData(), null, true));
    }

    private static void indent_DisplayNextRow(PrintWriter printWriter, ResultSet resultSet, Connection connection, int n2, int[] nArray, int[] nArray2) throws SQLException {
        Vector<ResultSet> vector = !connection.getAutoCommit() ? new Vector<ResultSet>() : null;
        JDBCDisplayUtil.checkNotNull(resultSet, "ResultSet");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        if (resultSet.next()) {
            int n3 = JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, n2, nArray, nArray2);
            JDBCDisplayUtil.DisplayRow(printWriter, resultSet, resultSetMetaData, n3, vector, connection, n2, null, null);
        } else {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n2, LocalizedResource.getMessage("UT_NoCurreRow", new Object[0]));
        }
        JDBCDisplayUtil.ShowWarnings(printWriter, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printWriter, vector, connection, n2);
        vector = null;
    }

    public static void DisplayCurrentRow(PrintWriter printWriter, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayCurrentRow(printWriter, resultSet, connection, 0, null, resultSet == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(resultSet.getMetaData(), null, true));
    }

    private static void indent_DisplayCurrentRow(PrintWriter printWriter, ResultSet resultSet, Connection connection, int n2, int[] nArray, int[] nArray2) throws SQLException {
        if (resultSet == null) {
            JDBCDisplayUtil.indentedPrintLine(printWriter, n2, LocalizedResource.getMessage("UT_NoCurreRow_19", new Object[0]));
            return;
        }
        Vector<ResultSet> vector = !connection.getAutoCommit() ? new Vector<ResultSet>() : null;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n3 = JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, n2, nArray, nArray2);
        JDBCDisplayUtil.DisplayRow(printWriter, resultSet, resultSetMetaData, n3, vector, connection, n2, nArray, nArray2);
        JDBCDisplayUtil.ShowWarnings(printWriter, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printWriter, vector, connection, n2);
        vector = null;
    }

    public static int DisplayBanner(PrintWriter printWriter, ResultSetMetaData resultSetMetaData) throws SQLException {
        return JDBCDisplayUtil.indent_DisplayBanner(printWriter, resultSetMetaData, 0, null, JDBCDisplayUtil.getColumnDisplayWidths(resultSetMetaData, null, true));
    }

    private static int indent_DisplayBanner(PrintWriter printWriter, ResultSetMetaData resultSetMetaData, int n2, int[] nArray, int[] nArray2) throws SQLException {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = nArray2.length;
        int n5 = n4 - 1;
        for (n3 = 1; n3 <= n4; ++n3) {
            n5 += nArray2[n3 - 1];
        }
        stringBuffer.ensureCapacity(n5);
        for (n3 = 1; n3 <= n4; ++n3) {
            int n6;
            int n7 = n6 = nArray == null ? n3 : nArray[n3 - 1];
            if (n3 > 1) {
                stringBuffer.append('|');
            }
            String string = resultSetMetaData.getColumnLabel(n6);
            int n8 = nArray2[n3 - 1];
            if (string.length() < n8) {
                int n9;
                stringBuffer.append(string);
                for (n9 = n8 - string.length(); n9 >= 64; n9 -= 64) {
                    stringBuffer.append("                                                                ");
                }
                while (n9 >= 16) {
                    stringBuffer.append("                ");
                    n9 -= 16;
                }
                while (n9 >= 4) {
                    stringBuffer.append("    ");
                    n9 -= 4;
                }
                while (n9 > 0) {
                    stringBuffer.append(' ');
                    --n9;
                }
                continue;
            }
            if (string.length() > n8) {
                if (n8 > 1) {
                    stringBuffer.append(string.substring(0, n8 - 1));
                }
                if (n8 <= 0) continue;
                stringBuffer.append('&');
                continue;
            }
            stringBuffer.append(string);
        }
        stringBuffer.setLength(Math.min(n5, 1024));
        JDBCDisplayUtil.indentedPrintLine(printWriter, n2, stringBuffer);
        for (n3 = 0; n3 < Math.min(n5, 1024); ++n3) {
            stringBuffer.setCharAt(n3, '-');
        }
        JDBCDisplayUtil.indentedPrintLine(printWriter, n2, stringBuffer);
        stringBuffer = null;
        return n5;
    }

    private static void DisplayRow(PrintWriter printWriter, ResultSet resultSet, ResultSetMetaData resultSetMetaData, int n2, Vector<ResultSet> vector, Connection connection, int n3, int[] nArray, int[] nArray2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n2);
        int n4 = nArray2.length;
        for (int i2 = 1; i2 <= n4; ++i2) {
            String string;
            int n5;
            int n6 = n5 = nArray == null ? i2 : nArray[i2 - 1];
            if (i2 > 1) {
                stringBuffer.append('|');
            }
            switch (resultSetMetaData.getColumnType(n5)) {
                default: {
                    string = LocalizedResource.getInstance().getLocalizedString(resultSet, resultSetMetaData, n5);
                    break;
                }
                case 1111: 
                case 2000: {
                    Object object = resultSet.getObject(n5);
                    if (object == null) {
                        string = "NULL";
                        break;
                    }
                    if (object instanceof ResultSet && vector != null) {
                        string = LocalizedResource.getMessage("UT_Resul0_20", LocalizedResource.getNumber(vector.size()));
                        vector.addElement((ResultSet)object);
                        break;
                    }
                    try {
                        string = resultSet.getString(n5);
                        break;
                    }
                    catch (SQLException sQLException) {
                        string = object.toString();
                    }
                }
            }
            if (string == null) {
                string = "NULL";
            }
            int n7 = nArray2[i2 - 1];
            if (string.length() < n7) {
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.ensureCapacity(n7);
                for (int i3 = string.length(); i3 < n7; ++i3) {
                    stringBuffer2.append(' ');
                }
                string = stringBuffer2.toString();
            } else if (string.length() > n7) {
                string = string.substring(0, n7 - 1) + "&";
            }
            stringBuffer.append(string);
        }
        JDBCDisplayUtil.indentedPrintLine(printWriter, n3, stringBuffer);
    }

    public static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw ijException.objectWasNull(string);
        }
    }

    public static String mapNull(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return string;
    }

    public static void doTrace(PrintWriter printWriter, Exception exception) {
        if (JDBCDisplayUtil.getSystemBoolean("ij.exceptionTrace")) {
            exception.printStackTrace(printWriter);
            printWriter.flush();
        }
    }

    public static void setMaxDisplayWidth(int n2) {
        maxWidth = n2;
    }

    private static void indentedPrintLine(PrintWriter printWriter, int n2, String string) {
        JDBCDisplayUtil.indent(printWriter, n2);
        printWriter.println(string);
    }

    private static void indentedPrintLine(PrintWriter printWriter, int n2, StringBuffer stringBuffer) {
        JDBCDisplayUtil.indent(printWriter, n2);
        printWriter.println(stringBuffer);
    }

    private static void indent(PrintWriter printWriter, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            printWriter.print("  ");
        }
    }

    public static void ShowException(PrintStream printStream, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (throwable instanceof SQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, (SQLException)throwable);
        } else {
            throwable.printStackTrace(printStream);
        }
    }

    public static void ShowSQLException(PrintStream printStream, SQLException sQLException) {
        String string = JDBCDisplayUtil.getSystemBoolean("ij.showErrorCode") ? " (errorCode = " + sQLException.getErrorCode() + ")" : "";
        while (sQLException != null) {
            printStream.println("ERROR " + JDBCDisplayUtil.mapNull(sQLException.getSQLState(), "(no SQLState)") + ": " + JDBCDisplayUtil.mapNull(sQLException.getMessage(), "(no message)") + string);
            JDBCDisplayUtil.doTrace(printStream, (Exception)sQLException);
            sQLException = sQLException.getNextException();
        }
    }

    public static void ShowWarnings(PrintStream printStream, Connection connection) {
        try {
            Object var2_2 = null;
            if (connection != null) {
                JDBCDisplayUtil.ShowWarnings(printStream, connection.getWarnings());
            }
            if (connection != null) {
                connection.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
        }
    }

    public static void ShowWarnings(PrintStream printStream, SQLWarning sQLWarning) {
        while (sQLWarning != null) {
            printStream.println("WARNING " + JDBCDisplayUtil.mapNull(sQLWarning.getSQLState(), "(no SQLState)") + ": " + JDBCDisplayUtil.mapNull(sQLWarning.getMessage(), "(no message)"));
            sQLWarning = sQLWarning.getNextWarning();
        }
    }

    public static void ShowWarnings(PrintStream printStream, ResultSet resultSet) {
        try {
            Object var2_2 = null;
            if (resultSet != null) {
                JDBCDisplayUtil.ShowWarnings(printStream, resultSet.getWarnings());
            }
            if (resultSet != null) {
                resultSet.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
        }
    }

    public static void ShowWarnings(PrintStream printStream, Statement statement) {
        try {
            Object var2_2 = null;
            if (statement != null) {
                JDBCDisplayUtil.ShowWarnings(printStream, statement.getWarnings());
            }
            if (statement != null) {
                statement.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
        }
    }

    public static void DisplayResults(PrintStream printStream, Statement statement, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printStream, statement, connection, 0, null, null);
    }

    private static void indent_DisplayResults(PrintStream printStream, Statement statement, Connection connection, int n2, int[] nArray, int[] nArray2) throws SQLException {
        JDBCDisplayUtil.checkNotNull(statement, "Statement");
        ResultSet resultSet = statement.getResultSet();
        if (resultSet != null) {
            JDBCDisplayUtil.indent_DisplayResults(printStream, resultSet, connection, n2, nArray, nArray2);
            resultSet.close();
        } else {
            JDBCDisplayUtil.DisplayUpdateCount(printStream, statement.getUpdateCount(), n2);
        }
        JDBCDisplayUtil.ShowWarnings(printStream, statement);
    }

    static void DisplayUpdateCount(PrintStream printStream, int n2, int n3) {
        if (n2 == 1) {
            JDBCDisplayUtil.indentedPrintLine(printStream, n3, "1 row inserted/updated/deleted");
        } else if (n2 >= 0) {
            JDBCDisplayUtil.indentedPrintLine(printStream, n3, n2 + " rows inserted/updated/deleted");
        } else {
            JDBCDisplayUtil.indentedPrintLine(printStream, n3, "Statement executed.");
        }
    }

    public static void DisplayResults(PrintStream printStream, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayResults(printStream, resultSet, connection, 0, null, null);
    }

    private static void indent_DisplayResults(PrintStream printStream, ResultSet resultSet, Connection connection, int n2, int[] nArray, int[] nArray2) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n3 = 0;
        Vector<ResultSet> vector = !connection.getAutoCommit() ? new Vector<ResultSet>() : null;
        if (nArray2 == null) {
            nArray2 = JDBCDisplayUtil.getColumnDisplayWidths(resultSetMetaData, nArray, false);
        }
        int n4 = JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, n2, nArray, nArray2);
        boolean bl = true;
        int n5 = 0;
        while (bl) {
            try {
                bl = resultSet.next();
                if (!bl) continue;
                JDBCDisplayUtil.DisplayRow(printStream, resultSet, resultSetMetaData, n4, vector, connection, n2, nArray, nArray2);
                JDBCDisplayUtil.ShowWarnings(printStream, resultSet);
                ++n3;
            }
            catch (SQLException sQLException) {
                if (++n5 > 0) {
                    throw sQLException;
                }
                JDBCDisplayUtil.ShowSQLException(printStream, sQLException);
            }
        }
        if (showSelectCount) {
            if (n3 == 1) {
                printStream.println();
                JDBCDisplayUtil.indentedPrintLine(printStream, n2, "1 row selected");
            } else if (n3 >= 0) {
                printStream.println();
                JDBCDisplayUtil.indentedPrintLine(printStream, n2, n3 + " rows selected");
            }
        }
        JDBCDisplayUtil.DisplayNestedResults(printStream, vector, connection, n2);
        vector = null;
    }

    private static void DisplayNestedResults(PrintStream printStream, Vector<ResultSet> vector, Connection connection, int n2) throws SQLException {
        if (vector == null) {
            return;
        }
        String string = "+ ResultSet #";
        String string2 = "++++++++++++++++";
        String string3 = "0";
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            System.out.println();
            String string4 = Integer.toString(i2);
            if (string4.length() > string3.length()) {
                string3 = string4;
                string2 = string2 + "+";
            }
            System.out.println(string2);
            System.out.println(string + i2 + " +");
            System.out.println(string2);
            JDBCDisplayUtil.indent_DisplayResults(printStream, vector.elementAt(i2), connection, n2, null, null);
        }
    }

    public static void DisplayNextRow(PrintStream printStream, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayNextRow(printStream, resultSet, connection, 0, null, resultSet == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(resultSet.getMetaData(), null, false));
    }

    private static void indent_DisplayNextRow(PrintStream printStream, ResultSet resultSet, Connection connection, int n2, int[] nArray, int[] nArray2) throws SQLException {
        Vector<ResultSet> vector = !connection.getAutoCommit() ? new Vector<ResultSet>() : null;
        JDBCDisplayUtil.checkNotNull(resultSet, "ResultSet");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        if (resultSet.next()) {
            int n3 = JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, n2, null, null);
            JDBCDisplayUtil.DisplayRow(printStream, resultSet, resultSetMetaData, n3, vector, connection, n2, nArray, nArray2);
        } else {
            JDBCDisplayUtil.indentedPrintLine(printStream, n2, LocalizedResource.getMessage("UT_NoCurreRow", new Object[0]));
        }
        JDBCDisplayUtil.ShowWarnings(printStream, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printStream, vector, connection, n2);
        vector = null;
    }

    public static void DisplayCurrentRow(PrintStream printStream, ResultSet resultSet, Connection connection) throws SQLException {
        JDBCDisplayUtil.indent_DisplayCurrentRow(printStream, resultSet, connection, 0, null, resultSet == null ? null : JDBCDisplayUtil.getColumnDisplayWidths(resultSet.getMetaData(), null, false));
    }

    private static void indent_DisplayCurrentRow(PrintStream printStream, ResultSet resultSet, Connection connection, int n2, int[] nArray, int[] nArray2) throws SQLException {
        if (resultSet == null) {
            JDBCDisplayUtil.indentedPrintLine(printStream, n2, LocalizedResource.getMessage("UT_NoCurreRow_19", new Object[0]));
            return;
        }
        Vector<ResultSet> vector = !connection.getAutoCommit() ? new Vector<ResultSet>() : null;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDisplayUtil.checkNotNull(resultSetMetaData, "ResultSetMetaData");
        int n3 = JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, n2, nArray, nArray2);
        JDBCDisplayUtil.DisplayRow(printStream, resultSet, resultSetMetaData, n3, vector, connection, n2, nArray, nArray2);
        JDBCDisplayUtil.ShowWarnings(printStream, resultSet);
        JDBCDisplayUtil.DisplayNestedResults(printStream, vector, connection, n2);
        vector = null;
    }

    public static int DisplayBanner(PrintStream printStream, ResultSetMetaData resultSetMetaData) throws SQLException {
        return JDBCDisplayUtil.indent_DisplayBanner(printStream, resultSetMetaData, 0, null, JDBCDisplayUtil.getColumnDisplayWidths(resultSetMetaData, null, false));
    }

    private static int indent_DisplayBanner(PrintStream printStream, ResultSetMetaData resultSetMetaData, int n2, int[] nArray, int[] nArray2) throws SQLException {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = nArray2.length;
        int n5 = n4 - 1;
        for (n3 = 1; n3 <= n4; ++n3) {
            n5 += nArray2[n3 - 1];
        }
        stringBuffer.ensureCapacity(n5);
        for (n3 = 1; n3 <= n4; ++n3) {
            int n6;
            int n7 = n6 = nArray == null ? n3 : nArray[n3 - 1];
            if (n3 > 1) {
                stringBuffer.append('|');
            }
            String string = resultSetMetaData.getColumnLabel(n6);
            int n8 = nArray2[n3 - 1];
            if (string.length() < n8) {
                int n9;
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.ensureCapacity(n8);
                for (n9 = stringBuffer2.length() + 64; n9 <= n8; n9 += 64) {
                    stringBuffer2.append("                                                                ");
                }
                for (n9 = stringBuffer2.length() + 16; n9 <= n8; n9 += 16) {
                    stringBuffer2.append("                ");
                }
                for (n9 = stringBuffer2.length() + 4; n9 <= n8; n9 += 4) {
                    stringBuffer2.append("    ");
                }
                for (n9 = stringBuffer2.length(); n9 < n8; ++n9) {
                    stringBuffer2.append(' ');
                }
                stringBuffer.append(stringBuffer2);
                continue;
            }
            if (string.length() > n8) {
                if (n8 > 1) {
                    stringBuffer.append(string.substring(0, n8 - 1));
                }
                if (n8 <= 0) continue;
                stringBuffer.append('&');
                continue;
            }
            stringBuffer.append(string);
        }
        stringBuffer.setLength(Math.min(n5, 1024));
        JDBCDisplayUtil.indentedPrintLine(printStream, n2, stringBuffer);
        for (n3 = 0; n3 < Math.min(n5, 1024); ++n3) {
            stringBuffer.setCharAt(n3, '-');
        }
        JDBCDisplayUtil.indentedPrintLine(printStream, n2, stringBuffer);
        stringBuffer = null;
        return n5;
    }

    private static void DisplayRow(PrintStream printStream, ResultSet resultSet, ResultSetMetaData resultSetMetaData, int n2, Vector<ResultSet> vector, Connection connection, int n3, int[] nArray, int[] nArray2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.ensureCapacity(n2);
        int n4 = nArray2.length;
        for (int i2 = 1; i2 <= n4; ++i2) {
            String string;
            int n5;
            int n6 = n5 = nArray == null ? i2 : nArray[i2 - 1];
            if (i2 > 1) {
                stringBuffer.append('|');
            }
            switch (resultSetMetaData.getColumnType(n5)) {
                default: {
                    string = resultSet.getString(n5);
                    break;
                }
                case 1111: 
                case 2000: {
                    Object object = resultSet.getObject(n5);
                    if (object == null) {
                        string = "NULL";
                        break;
                    }
                    if (object instanceof ResultSet && vector != null) {
                        string = "ResultSet #" + vector.size();
                        vector.addElement((ResultSet)object);
                        break;
                    }
                    try {
                        string = resultSet.getString(n5);
                        break;
                    }
                    catch (SQLException sQLException) {
                        string = object.toString();
                    }
                }
            }
            if (string == null) {
                string = "NULL";
            }
            int n7 = nArray2[i2 - 1];
            if (string.length() < n7) {
                StringBuffer stringBuffer2 = new StringBuffer(string);
                stringBuffer2.ensureCapacity(n7);
                for (int i3 = string.length(); i3 < n7; ++i3) {
                    stringBuffer2.append(' ');
                }
                string = stringBuffer2.toString();
            } else if (string.length() > n7) {
                string = string.substring(0, n7 - 1) + "&";
            }
            stringBuffer.append(string);
        }
        JDBCDisplayUtil.indentedPrintLine(printStream, n3, stringBuffer);
    }

    public static void doTrace(PrintStream printStream, Exception exception) {
        if (JDBCDisplayUtil.getSystemBoolean("ij.exceptionTrace")) {
            exception.printStackTrace(printStream);
            printStream.flush();
        }
    }

    private static void indentedPrintLine(PrintStream printStream, int n2, String string) {
        JDBCDisplayUtil.indent(printStream, n2);
        printStream.println(string);
    }

    private static void indentedPrintLine(PrintStream printStream, int n2, StringBuffer stringBuffer) {
        JDBCDisplayUtil.indent(printStream, n2);
        printStream.println(stringBuffer);
    }

    private static void indent(PrintStream printStream, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            printStream.print("  ");
        }
    }

    private static boolean getSystemBoolean(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(string) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    static {
        LocalizedResource.getInstance();
    }
}

