/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Vector;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.Token;
import org.apache.derby.impl.tools.ij.ij;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.impl.tools.ij.ijResult;
import org.apache.derby.impl.tools.ij.ijVectorResult;
import org.apache.derby.impl.tools.ij.ijXid;
import org.apache.derby.impl.tools.ij.xaAbstractHelper;

class xaHelper
implements xaAbstractHelper {
    private XADataSource currentXADataSource;
    private XAConnection currentXAConnection;
    private String databaseName;
    private DataSource currentDataSource;
    private ConnectionPoolDataSource currentCPDataSource;
    private PooledConnection currentPooledConnection;
    private boolean isJCC;
    private boolean isNetClient;
    private String framework;
    private static final Class[] STRING_P = new Class[]{"".getClass()};
    private static final Class[] INT_P = new Class[]{Integer.TYPE};
    private static final Class[] BOOLEAN_P = new Class[]{Boolean.TYPE};

    @Override
    public void setFramework(String string) {
        if (string == null) {
            return;
        }
        this.framework = string.toUpperCase(Locale.ENGLISH);
        if (this.framework.endsWith("NET") || this.framework.equals("DB2JCC")) {
            this.isJCC = true;
        } else if (this.framework.equals("DERBYNETCLIENT")) {
            this.isNetClient = true;
        }
    }

    private Xid makeXid(int n2) {
        try {
            return new ijXid(n2, this.databaseName.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    @Override
    public void XADataSourceStatement(ij ij2, Token token, Token token2, String string) throws SQLException {
        try {
            Object object;
            this.currentXADataSource = this.getXADataSource();
            this.databaseName = ij2.stringValue(token.image);
            if (this.isJCC || this.isNetClient) {
                object = System.getProperty("hostName");
                if (object != null && !((String)object).equals("localhost")) {
                    xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "ServerName", (String)object);
                } else {
                    xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "ServerName", "localhost");
                }
                xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "portNumber", 1527);
                String string2 = "APP";
                String string3 = "APP";
                xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "user", string2);
                xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "password", string3);
            }
            if (this.isJCC) {
                xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "driverType", 4);
                xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "retrieveMessagesFromServerOnGetMessage", true);
            }
            xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "databaseName", this.databaseName);
            if (token2 != null && token2.toString().toLowerCase(Locale.ENGLISH).equals("shutdown")) {
                if (this.isJCC || this.isNetClient) {
                    xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "databaseName", this.databaseName + ";shutdown=true");
                } else {
                    xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "shutdownDatabase", "shutdown");
                }
                this.currentXADataSource.getXAConnection().getConnection();
                this.currentXADataSource = null;
                this.currentXAConnection = null;
            } else if (string != null && string.toLowerCase(Locale.ENGLISH).equals("create")) {
                if (this.isJCC || this.isNetClient) {
                    xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "databaseName", this.databaseName + ";create=true");
                } else {
                    xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "createDatabase", "create");
                }
                object = this.currentXADataSource.getXAConnection();
                object.close();
                xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "createDatabase", null);
            }
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
    }

    @Override
    public void XAConnectStatement(ij ij2, Token token, Token token2, String string) throws SQLException {
        try {
            if (this.currentXAConnection != null) {
                try {
                    this.currentXAConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.currentXAConnection = null;
            }
            String string2 = null;
            String string3 = "";
            if (token2 != null) {
                string3 = ij2.stringValue(token2.image);
            }
            if (token != null) {
                string2 = ij2.stringValue(token.image);
                this.currentXAConnection = this.currentXADataSource.getXAConnection(string2, string3);
            } else {
                this.currentXAConnection = this.currentXADataSource.getXAConnection();
            }
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
    }

    @Override
    public void XADisconnectStatement(ij ij2, String string) throws SQLException {
        if (this.currentXAConnection == null) {
            throw ijException.noSuchConnection("XAConnection");
        }
        this.currentXAConnection.close();
        this.currentXAConnection = null;
    }

    @Override
    public Connection XAGetConnectionStatement(ij ij2, String string) throws SQLException {
        try {
            return this.currentXAConnection.getConnection();
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
    }

    @Override
    public void CommitStatement(ij ij2, Token token, Token token2, int n2) throws SQLException {
        try {
            this.currentXAConnection.getXAResource().commit(this.makeXid(n2), token != null);
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
    }

    @Override
    public void EndStatement(ij ij2, int n2, int n3) throws SQLException {
        try {
            this.currentXAConnection.getXAResource().end(this.makeXid(n3), n2);
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
    }

    @Override
    public void ForgetStatement(ij ij2, int n2) throws SQLException {
        try {
            this.currentXAConnection.getXAResource().forget(this.makeXid(n2));
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
    }

    @Override
    public void PrepareStatement(ij ij2, int n2) throws SQLException {
        try {
            this.currentXAConnection.getXAResource().prepare(this.makeXid(n2));
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
    }

    @Override
    public ijResult RecoverStatement(ij ij2, int n2) throws SQLException {
        Xid[] xidArray = null;
        try {
            xidArray = this.currentXAConnection.getXAResource().recover(n2);
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement("");
        vector.addElement(LocalizedResource.getMessage("IJ_Reco0InDoubT", LocalizedResource.getNumber(xidArray.length)));
        vector.addElement("");
        for (int i2 = 0; i2 < xidArray.length; ++i2) {
            vector.addElement(LocalizedResource.getMessage("IJ_Tran01", LocalizedResource.getNumber(i2 + 1), xidArray[i2].toString()));
        }
        return new ijVectorResult(vector, null);
    }

    @Override
    public void RollbackStatement(ij ij2, int n2) throws SQLException {
        try {
            this.currentXAConnection.getXAResource().rollback(this.makeXid(n2));
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
    }

    @Override
    public void StartStatement(ij ij2, int n2, int n3) throws SQLException {
        try {
            this.currentXAConnection.getXAResource().start(this.makeXid(n3), n2);
        }
        catch (Throwable throwable) {
            throw this.handleException(throwable);
        }
    }

    private SQLException handleException(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return (SQLException)throwable;
        }
        if (throwable instanceof XAException) {
            int n2 = ((XAException)throwable).errorCode;
            String string = LocalizedResource.getMessage("IJ_IlleValu", new Object[0]);
            switch (n2) {
                case 7: {
                    string = "XA_HEURCOM ";
                    break;
                }
                case 8: {
                    string = "XA_HEURHAZ";
                    break;
                }
                case 5: {
                    string = "XA_HEURMIX";
                    break;
                }
                case 6: {
                    string = "XA_HEURRB ";
                    break;
                }
                case 9: {
                    string = "XA_NOMIGRATE ";
                    break;
                }
                case 101: {
                    string = "XA_RBCOMMFAIL ";
                    break;
                }
                case 102: {
                    string = "XA_RBDEADLOCK ";
                    break;
                }
                case 103: {
                    string = "XA_RBINTEGRITY ";
                    break;
                }
                case 104: {
                    string = "XA_RBOTHER ";
                    break;
                }
                case 105: {
                    string = "XA_RBPROTO ";
                    break;
                }
                case 100: {
                    string = "XA_RBROLLBACK ";
                    break;
                }
                case 106: {
                    string = "XA_RBTIMEOUT ";
                    break;
                }
                case 107: {
                    string = "XA_RBTRANSIENT ";
                    break;
                }
                case 3: {
                    string = "XA_RDONLY ";
                    break;
                }
                case 4: {
                    string = "XA_RETRY ";
                    break;
                }
                case -2: {
                    string = "XAER_ASYNC ";
                    break;
                }
                case -8: {
                    string = "XAER_DUPID ";
                    break;
                }
                case -5: {
                    string = "XAER_INVAL ";
                    break;
                }
                case -4: {
                    string = "XAER_NOTA ";
                    break;
                }
                case -9: {
                    string = "XAER_OUTSIDE ";
                    break;
                }
                case -6: {
                    string = "XAER_PROTO ";
                    break;
                }
                case -3: {
                    string = "XAER_RMERR ";
                    break;
                }
                case -7: {
                    string = "XAER_RMFAIL ";
                }
            }
            throw new ijException(string);
        }
        String string = LocalizedResource.getMessage("IJ_01SeeLog", throwable.toString(), throwable.getMessage());
        throw new ijException(string);
    }

    @Override
    public Connection DataSourceStatement(ij ij2, Token token, Token token2, Token token3, Token token4, String string) throws SQLException {
        Object object;
        try {
            object = Class.forName("org.apache.derby.jdbc.EmbeddedDataSource");
            this.currentDataSource = (DataSource)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        this.databaseName = ij2.stringValue(token.image);
        xaHelper.setDataSourceProperty((Object)this.currentDataSource, "databaseName", this.databaseName);
        xaHelper.setDataSourceProperty((Object)this.currentXADataSource, "dataSourceName", this.databaseName);
        object = null;
        String string2 = null;
        String string3 = "";
        if (token4 != null) {
            string3 = ij2.stringValue(token4.image);
        }
        if (token3 != null) {
            string2 = ij2.stringValue(token3.image);
            object = this.currentDataSource.getConnection(string2, string3);
        } else {
            object = this.currentDataSource.getConnection();
        }
        return object;
    }

    @Override
    public void CPDataSourceStatement(ij ij2, Token token, Token token2) throws SQLException {
        try {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource");
            this.currentCPDataSource = (ConnectionPoolDataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
        this.databaseName = ij2.stringValue(token.image);
        xaHelper.setDataSourceProperty((Object)this.currentCPDataSource, "databaseName", this.databaseName);
    }

    @Override
    public void CPConnectStatement(ij ij2, Token token, Token token2, String string) throws SQLException {
        String string2 = null;
        String string3 = "";
        if (token2 != null) {
            string3 = ij2.stringValue(token2.image);
        }
        if (token != null) {
            string2 = ij2.stringValue(token.image);
            this.currentPooledConnection = this.currentCPDataSource.getPooledConnection(string2, string3);
        } else {
            this.currentPooledConnection = this.currentCPDataSource.getPooledConnection();
        }
    }

    @Override
    public Connection CPGetConnectionStatement(ij ij2, String string) throws SQLException {
        return this.currentPooledConnection.getConnection();
    }

    @Override
    public void CPDisconnectStatement(ij ij2, String string) throws SQLException {
        if (this.currentPooledConnection == null) {
            throw ijException.noSuchConnection(LocalizedResource.getMessage("PooledConnection", new Object[0]));
        }
        this.currentPooledConnection.close();
        this.currentPooledConnection = null;
    }

    private XADataSource getXADataSource() throws Exception {
        try {
            if (this.isJCC) {
                Class<?> clazz = Class.forName("com.ibm.db2.jcc.DB2XADataSource");
                return (XADataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (this.isNetClient) {
                if (ij.JNDI()) {
                    try {
                        Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientXADataSource40");
                        return (XADataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                        // empty catch block
                    }
                    Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientXADataSource");
                    return (XADataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientXADataSource40");
                return (XADataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (ij.JNDI()) {
                try {
                    Class<?> clazz = Class.forName("org.apache.derby.jdbc.EmbeddedXADataSource40");
                    return (XADataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                    // empty catch block
                }
                Class<?> clazz = Class.forName("org.apache.derby.jdbc.EmbeddedXADataSource");
                return (XADataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicEmbeddedXADataSource40");
            return (XADataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ijException(LocalizedResource.getMessage("IJ_XAClass", new Object[0]));
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        throw new ijException(LocalizedResource.getMessage("IJ_XANoI", new Object[0]));
    }

    private static void setDataSourceProperty(Object object, String string, int n2) throws SQLException {
        String string2 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        try {
            Method method = object.getClass().getMethod(string2, INT_P);
            method.invoke(object, n2);
        }
        catch (Exception exception) {
            throw new SQLException(string + " ???" + exception.getMessage());
        }
    }

    private static void setDataSourceProperty(Object object, String string, String string2) throws SQLException {
        String string3 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        try {
            Method method = object.getClass().getMethod(string3, STRING_P);
            method.invoke(object, string2);
            return;
        }
        catch (Exception exception) {
            throw new SQLException(string + " ???");
        }
    }

    private static void setDataSourceProperty(Object object, String string, boolean bl) throws SQLException {
        String string2 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        try {
            Method method = object.getClass().getMethod(string2, BOOLEAN_P);
            method.invoke(object, bl);
            return;
        }
        catch (Exception exception) {
            throw new SQLException(string + " ???");
        }
    }
}

