/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.master;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.replication.ReplicationLogger;
import org.apache.derby.impl.store.replication.buffer.ReplicationLogBuffer;
import org.apache.derby.impl.store.replication.master.LogShipper;
import org.apache.derby.impl.store.replication.master.MasterController;
import org.apache.derby.impl.store.replication.net.ReplicationMessage;
import org.apache.derby.impl.store.replication.net.ReplicationMessageTransmit;

public class AsynchronousLogShipper
extends Thread
implements LogShipper {
    private final ReplicationLogBuffer logBuffer;
    private ReplicationMessageTransmit transmitter;
    private long shippingInterval;
    private long minShippingInterval;
    private long maxShippingInterval;
    private long lastShippingTime;
    private volatile boolean stopShipping = false;
    private MasterController masterController = null;
    private Object objLSTSync = new Object();
    private Object forceFlushSemaphore = new Object();
    public static final int DEFAULT_FORCEFLUSH_TIMEOUT = 5000;
    private ReplicationMessage failedChunk = null;
    private long failedChunkHighestInstant = -1L;
    private long highestShippedInstant = -1L;
    private static final int FI_LOW = 10;
    private static final int FI_HIGH = 80;
    private static final long MIN = 100L;
    private static final long MAX = 5000L;
    private final ReplicationLogger repLogger;

    public AsynchronousLogShipper(ReplicationLogBuffer replicationLogBuffer, ReplicationMessageTransmit replicationMessageTransmit, MasterController masterController, ReplicationLogger replicationLogger) {
        super("derby.master.logger-" + masterController.getDbName());
        this.logBuffer = replicationLogBuffer;
        this.transmitter = replicationMessageTransmit;
        this.masterController = masterController;
        this.stopShipping = false;
        this.repLogger = replicationLogger;
        this.getLogShipperProperties();
        this.shippingInterval = this.minShippingInterval;
        this.lastShippingTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopShipping) {
            try {
                Object object = this.forceFlushSemaphore;
                synchronized (object) {
                    this.shipALogChunk();
                    this.forceFlushSemaphore.notify();
                }
                this.shippingInterval = this.calculateSIfromFI();
                if (this.shippingInterval == -1L) continue;
                object = this.objLSTSync;
                synchronized (object) {
                    this.objLSTSync.wait(this.shippingInterval);
                }
            }
            catch (InterruptedException interruptedException) {
                InterruptStatus.setInterrupted();
            }
            catch (IOException iOException) {
                this.transmitter = this.masterController.handleExceptions(iOException);
                if (this.transmitter == null) continue;
            }
            catch (StandardException standardException) {
                this.masterController.handleExceptions(standardException);
            }
        }
    }

    private synchronized boolean shipALogChunk() throws IOException, StandardException {
        byte[] byArray = null;
        ReplicationMessage replicationMessage = null;
        try {
            if (this.failedChunk != null) {
                this.transmitter.sendMessage(this.failedChunk);
                this.highestShippedInstant = this.failedChunkHighestInstant;
                this.failedChunk = null;
            }
            if (this.logBuffer.next()) {
                byArray = this.logBuffer.getData();
                replicationMessage = new ReplicationMessage(10, byArray);
                this.transmitter.sendMessage(replicationMessage);
                this.highestShippedInstant = this.logBuffer.getLastInstant();
                this.lastShippingTime = System.currentTimeMillis();
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            this.masterController.handleExceptions(StandardException.newException("XRE03", noSuchElementException, new Object[0]));
        }
        catch (IOException iOException) {
            if (replicationMessage != null) {
                this.failedChunk = replicationMessage;
                this.failedChunkHighestInstant = this.logBuffer.getLastInstant();
            }
            throw iOException;
        }
        return false;
    }

    @Override
    public void flushBuffer() throws IOException, StandardException {
        while (this.shipALogChunk()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceFlush() throws IOException, StandardException {
        if (this.stopShipping) {
            return;
        }
        Object object = this.forceFlushSemaphore;
        synchronized (object) {
            Object object2 = this.objLSTSync;
            synchronized (object2) {
                this.objLSTSync.notify();
            }
            try {
                this.forceFlushSemaphore.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                InterruptStatus.setInterrupted();
            }
        }
    }

    public long getHighestShippedInstant() {
        return this.highestShippedInstant;
    }

    @Override
    public void flushedInstance(long l2) {
    }

    public void stopLogShipment() {
        this.stopShipping = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workToDo() {
        int n2 = this.logBuffer.getFillInformation();
        if (n2 >= 80 || System.currentTimeMillis() - this.lastShippingTime > this.minShippingInterval) {
            Object object = this.objLSTSync;
            synchronized (object) {
                this.objLSTSync.notify();
            }
        }
    }

    private long calculateSIfromFI() {
        int n2 = this.logBuffer.getFillInformation();
        long l2 = n2 >= 80 ? -1L : (n2 > 10 && n2 < 80 ? this.minShippingInterval : this.maxShippingInterval);
        return l2;
    }

    private void getLogShipperProperties() {
        this.minShippingInterval = PropertyUtil.getSystemInt("derby.replication.minLogShippingInterval", 100);
        this.maxShippingInterval = PropertyUtil.getSystemInt("derby.replication.maxLogShippingInterval", 5000);
        int n2 = 10;
        if (this.minShippingInterval > this.maxShippingInterval / (long)n2) {
            this.minShippingInterval = this.maxShippingInterval / (long)n2;
        }
    }
}

