/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.impl.store.raw.xact.Xact;
import org.apache.derby.impl.store.raw.xact.XactContext;

public class TransactionTableEntry
implements Formatable,
TransactionInfo,
Cloneable {
    private TransactionId xid;
    private GlobalTransactionId gid;
    private LogInstant firstLog;
    private LogInstant lastLog;
    private int transactionStatus;
    private transient Xact myxact;
    private transient boolean update;
    private transient boolean recovery;
    private transient boolean needExclusion;
    private boolean isClone;
    private transient LanguageConnectionContext lcc;
    static final int UPDATE = 1;
    static final int RECOVERY = 2;
    static final int EXCLUDE = 4;

    TransactionTableEntry(Xact xact, TransactionId transactionId, int n2, int n3) {
        this.myxact = xact;
        this.xid = transactionId;
        this.transactionStatus = n2;
        this.update = (n3 & 1) != 0;
        this.needExclusion = (n3 & 4) != 0;
        boolean bl = this.recovery = (n3 & 2) != 0;
        if (this.recovery) {
            this.gid = xact.getGlobalId();
            this.firstLog = xact.getFirstLogInstant();
            this.lastLog = xact.getLastLogInstant();
        }
    }

    public TransactionTableEntry() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.xid);
        objectOutput.writeObject(this.myxact.getGlobalId());
        objectOutput.writeObject(this.myxact.getFirstLogInstant());
        objectOutput.writeObject(this.myxact.getLastLogInstant());
        objectOutput.writeInt(this.transactionStatus);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this.xid = (TransactionId)objectInput.readObject();
        this.gid = (GlobalTransactionId)objectInput.readObject();
        this.firstLog = (LogInstant)objectInput.readObject();
        this.lastLog = (LogInstant)objectInput.readObject();
        this.transactionStatus = objectInput.readInt();
        this.update = true;
        this.recovery = true;
        this.needExclusion = true;
    }

    void setXact(Xact xact) {
        this.myxact = xact;
    }

    @Override
    public int getTypeFormatId() {
        return 261;
    }

    public String toString() {
        return null;
    }

    void updateTransactionStatus(Xact xact, int n2, int n3) {
        this.update = (n3 & 1) != 0;
    }

    void removeUpdateTransaction() {
        this.update = false;
        this.transactionStatus = 0;
    }

    void unsetRecoveryStatus() {
        this.firstLog = null;
        this.recovery = false;
    }

    void prepareTransaction() {
        this.transactionStatus |= 2;
    }

    TransactionId getXid() {
        return this.xid;
    }

    public final GlobalTransactionId getGid() {
        if (this.gid != null) {
            return this.gid;
        }
        if (this.myxact != null) {
            return this.myxact.getGlobalId();
        }
        return null;
    }

    LogInstant getFirstLog() {
        if (this.firstLog != null) {
            return this.firstLog;
        }
        if (this.myxact != null) {
            return this.myxact.getFirstLogInstant();
        }
        return null;
    }

    LogInstant getLastLog() {
        if (this.lastLog != null) {
            return this.lastLog;
        }
        if (this.myxact != null) {
            return this.myxact.getLastLogInstant();
        }
        return null;
    }

    public final Xact getXact() {
        return this.myxact;
    }

    int getTransactionStatus() {
        return this.transactionStatus;
    }

    boolean isUpdate() {
        return this.update;
    }

    boolean isRecovery() {
        return this.recovery;
    }

    boolean isPrepared() {
        return (this.transactionStatus & 2) != 0;
    }

    public boolean needExclusion() {
        return this.needExclusion;
    }

    @Override
    public String getTransactionIdString() {
        TransactionId transactionId = this.myxact.getIdNoCheck();
        return transactionId == null ? "CLOSED" : transactionId.toString();
    }

    @Override
    public String getGlobalTransactionIdString() {
        GlobalTransactionId globalTransactionId = this.myxact.getGlobalId();
        return globalTransactionId == null ? null : globalTransactionId.toString();
    }

    @Override
    public String getUsernameString() {
        this.getlcc();
        return this.lcc == null ? null : this.lcc.getSessionUserId();
    }

    @Override
    public String getTransactionTypeString() {
        if (this.myxact == null) {
            return null;
        }
        if (this.myxact.getTransName() != null) {
            return this.myxact.getTransName();
        }
        return this.myxact.getContextId();
    }

    @Override
    public String getTransactionStatusString() {
        return this.myxact == null ? null : this.myxact.getState();
    }

    @Override
    public String getStatementTextString() {
        StatementContext statementContext;
        this.getlcc();
        if (this.lcc != null && (statementContext = this.lcc.getStatementContext()) != null) {
            return statementContext.getStatementText();
        }
        return null;
    }

    @Override
    public String getFirstLogInstantString() {
        LogInstant logInstant = this.myxact == null ? null : this.myxact.getFirstLogInstant();
        return logInstant == null ? null : logInstant.toString();
    }

    private void getlcc() {
        if (this.lcc == null && this.myxact != null && this.myxact.xc != null) {
            XactContext xactContext = this.myxact.xc;
            this.lcc = (LanguageConnectionContext)xactContext.getContextManager().getContext("LanguageConnectionContext");
        }
    }

    protected Object clone() {
        try {
            Object object = super.clone();
            ((TransactionTableEntry)object).isClone = true;
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

