/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.impl.store.raw.log.ChecksumOperation;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogRecord;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.impl.store.raw.log.StreamLogScan;
import org.apache.derby.io.StorageRandomAccessFile;

public class Scan
implements StreamLogScan {
    public static final byte FORWARD = 1;
    public static final byte BACKWARD = 2;
    public static final byte BACKWARD_FROM_LOG_END = 4;
    private StorageRandomAccessFile scan;
    private LogToFile logFactory;
    private long currentLogFileNumber;
    private long currentLogFileLength;
    private long knownGoodLogEnd;
    private long currentInstant;
    private long stopAt;
    private byte scanDirection;
    private boolean fuzzyLogEnd = false;

    public Scan(LogToFile logToFile, long l2, LogInstant logInstant, byte by) throws IOException, StandardException {
        this.logFactory = logToFile;
        this.currentLogFileNumber = LogCounter.getLogFileNumber(l2);
        this.currentLogFileLength = -1L;
        this.knownGoodLogEnd = 0L;
        this.currentInstant = 0L;
        this.stopAt = logInstant != null ? ((LogCounter)logInstant).getValueAsLong() : 0L;
        switch (by) {
            case 1: {
                this.scan = logToFile.getLogFileAtPosition(l2);
                this.scanDirection = 1;
                this.currentLogFileLength = this.scan.length();
                break;
            }
            case 2: {
                this.scan = logToFile.getLogFileAtPosition(l2);
                int n2 = this.scan.readInt();
                this.scan.seek(this.scan.getFilePointer() + (long)n2 + 16L - 4L);
                this.scanDirection = (byte)2;
                break;
            }
            case 4: {
                this.scan = logToFile.getLogFileAtPosition(l2);
                this.scanDirection = (byte)2;
            }
        }
    }

    @Override
    public LogRecord getNextRecord(ArrayInputStream arrayInputStream, TransactionId transactionId, int n2) throws StandardException {
        if (this.scan == null) {
            return null;
        }
        LogRecord logRecord = null;
        try {
            if (this.scanDirection == 2) {
                logRecord = this.getNextRecordBackward(arrayInputStream, transactionId, n2);
            } else if (this.scanDirection == 1) {
                logRecord = this.getNextRecordForward(arrayInputStream, transactionId, n2);
            }
            LogRecord logRecord2 = logRecord;
            return logRecord2;
        }
        catch (IOException iOException) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", iOException, new Object[0]));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.logFactory.markCorrupt(StandardException.newException("XSLA3.D", classNotFoundException, new Object[0]));
        }
        finally {
            if (logRecord == null) {
                this.close();
            }
        }
    }

    private LogRecord getNextRecordBackward(ArrayInputStream arrayInputStream, TransactionId transactionId, int n2) throws StandardException, IOException, ClassNotFoundException {
        LogRecord logRecord;
        boolean bl;
        int n3 = LogRecord.formatOverhead() + LogRecord.maxGroupStoredSize();
        if (transactionId != null) {
            n3 += LogRecord.maxTransactionIdStoredSize(transactionId);
        }
        long l2 = this.scan.getFilePointer();
        do {
            int n4;
            bl = true;
            logRecord = null;
            int n5 = -1;
            if (l2 == 24L) {
                if (this.stopAt != 0L && LogCounter.getLogFileNumber(this.stopAt) == this.currentLogFileNumber) {
                    return null;
                }
                this.scan.seek(16L);
                long l3 = this.scan.readLong();
                this.scan.close();
                this.currentLogFileNumber = LogCounter.getLogFileNumber(l3);
                this.scan = this.logFactory.getLogFileAtPosition(l3);
                l2 = this.scan.getFilePointer();
                if (l2 == 24L) continue;
            }
            this.scan.seek(l2 - 4L);
            int n6 = this.scan.readInt();
            long l4 = l2 - (long)n6 - 16L;
            this.scan.seek(l4 + 4L);
            this.currentInstant = this.scan.readLong();
            if (this.currentInstant < this.stopAt && this.stopAt != 0L) {
                this.currentInstant = 0L;
                return null;
            }
            byte[] byArray = arrayInputStream.getData();
            if (byArray.length < n6) {
                byArray = new byte[n6];
                arrayInputStream.setData(byArray);
            }
            if (this.logFactory.databaseEncrypted()) {
                this.scan.readFully(byArray, 0, n6);
                n4 = this.logFactory.decrypt(byArray, 0, n6, byArray, 0);
                arrayInputStream.setLimit(0, n6);
            } else if (n2 == 0 && transactionId == null) {
                this.scan.readFully(byArray, 0, n6);
                arrayInputStream.setLimit(0, n6);
            } else {
                n5 = n6 > n3 ? n3 : n6;
                this.scan.readFully(byArray, 0, n5);
                arrayInputStream.setLimit(0, n5);
            }
            logRecord = (LogRecord)arrayInputStream.readObject();
            if (logRecord.isChecksum()) {
                bl = false;
            } else if (n2 != 0 || transactionId != null) {
                TransactionId transactionId2;
                if (logRecord.isChecksum()) {
                    bl = false;
                }
                if (bl && n2 != 0 && (n2 & logRecord.group()) == 0) {
                    bl = false;
                }
                if (bl && transactionId != null && !(transactionId2 = logRecord.getTransactionId()).equals(transactionId)) {
                    bl = false;
                }
                if (bl && !this.logFactory.databaseEncrypted() && n5 < n6) {
                    n4 = arrayInputStream.getPosition();
                    this.scan.readFully(byArray, n5, n6 - n5);
                    arrayInputStream.setLimit(0, n6);
                    arrayInputStream.setPosition(n4);
                }
            }
            l2 = l4;
            this.scan.seek(l2);
        } while (!bl);
        return logRecord;
    }

    private LogRecord getNextRecordForward(ArrayInputStream arrayInputStream, TransactionId transactionId, int n2) throws StandardException, IOException, ClassNotFoundException {
        LogRecord logRecord;
        boolean bl;
        long l2 = this.scan.getFilePointer();
        int n3 = LogRecord.formatOverhead() + LogRecord.maxGroupStoredSize();
        if (transactionId != null) {
            n3 += LogRecord.maxTransactionIdStoredSize(transactionId);
        }
        do {
            int n4;
            bl = true;
            logRecord = null;
            int n5 = -1;
            if (l2 + 4L > this.currentLogFileLength) {
                if (l2 != this.currentLogFileLength) {
                    this.fuzzyLogEnd = true;
                }
                return null;
            }
            int n6 = this.scan.readInt();
            while (n6 == 0 || l2 + (long)n6 + 16L > this.currentLogFileLength) {
                if (n6 != 0) {
                    this.fuzzyLogEnd = true;
                    this.scan.close();
                    this.scan = null;
                    return null;
                }
                if (this.stopAt != 0L && LogCounter.getLogFileNumber(this.stopAt) == this.currentLogFileNumber) {
                    return null;
                }
                this.scan.close();
                this.scan = this.logFactory.getLogFileAtBeginning(++this.currentLogFileNumber);
                if (this.scan == null) {
                    return null;
                }
                l2 = this.scan.getFilePointer();
                this.scan.seek(16L);
                long l3 = this.scan.readLong();
                if (l3 != this.knownGoodLogEnd) {
                    return null;
                }
                this.scan.seek(l2);
                this.knownGoodLogEnd = LogCounter.makeLogInstantAsLong(this.currentLogFileNumber, l2);
                this.currentLogFileLength = this.scan.length();
                if (l2 + 4L >= this.currentLogFileLength) {
                    return null;
                }
                n6 = this.scan.readInt();
            }
            this.currentInstant = this.scan.readLong();
            if (this.currentInstant < this.knownGoodLogEnd) {
                this.fuzzyLogEnd = true;
                return null;
            }
            if (this.stopAt != 0L && this.currentInstant > this.stopAt) {
                this.currentInstant = 0L;
                return null;
            }
            byte[] byArray = arrayInputStream.getData();
            if (byArray.length < n6) {
                byArray = new byte[n6];
                arrayInputStream.setData(byArray);
            }
            if (this.logFactory.databaseEncrypted()) {
                this.scan.readFully(byArray, 0, n6);
                n4 = this.logFactory.decrypt(byArray, 0, n6, byArray, 0);
                arrayInputStream.setLimit(0, n4);
            } else if (n2 == 0 && transactionId == null) {
                this.scan.readFully(byArray, 0, n6);
                arrayInputStream.setLimit(0, n6);
            } else {
                n5 = n6 > n3 ? n3 : n6;
                this.scan.readFully(byArray, 0, n5);
                arrayInputStream.setLimit(0, n5);
            }
            logRecord = (LogRecord)arrayInputStream.readObject();
            if (n2 != 0 || transactionId != null) {
                TransactionId transactionId2;
                if (n2 != 0 && (n2 & logRecord.group()) == 0) {
                    bl = false;
                }
                if (bl && transactionId != null && !(transactionId2 = logRecord.getTransactionId()).equals(transactionId)) {
                    bl = false;
                }
                if (bl && !this.logFactory.databaseEncrypted() && n5 < n6) {
                    n4 = arrayInputStream.getPosition();
                    this.scan.readFully(byArray, n5, n6 - n5);
                    arrayInputStream.setLimit(0, n6);
                    arrayInputStream.setPosition(n4);
                }
            }
            if (!bl) {
                this.scan.seek(l2 - 4L);
            }
            if ((n4 = this.scan.readInt()) != n6 && n4 < n6 && n4 < n6) {
                this.fuzzyLogEnd = true;
                return null;
            }
            this.knownGoodLogEnd = LogCounter.makeLogInstantAsLong(this.currentLogFileNumber, l2 += (long)(n6 + 16));
            this.scan.seek(l2);
            if (!logRecord.isChecksum()) continue;
            bl = false;
            Loggable loggable = logRecord.getLoggable();
            ChecksumOperation checksumOperation = (ChecksumOperation)loggable;
            int n7 = checksumOperation.getDataLength();
            if (byArray.length < n7) {
                byArray = new byte[n7];
                arrayInputStream.setData(byArray);
                arrayInputStream.setLimit(0, n7);
            }
            boolean bl2 = false;
            if (l2 + (long)n7 <= this.currentLogFileLength) {
                this.scan.readFully(byArray, 0, n7);
                if (checksumOperation.isChecksumValid(byArray, 0, n7)) {
                    bl2 = true;
                }
            }
            if (!bl2) {
                this.fuzzyLogEnd = true;
                this.scan.close();
                this.scan = null;
                return null;
            }
            this.scan.seek(l2);
        } while (!bl);
        return logRecord;
    }

    @Override
    public void resetPosition(LogInstant logInstant) throws IOException, StandardException {
        long l2 = ((LogCounter)logInstant).getValueAsLong();
        if (l2 == 0L || this.stopAt != 0L && this.scanDirection == 1 && l2 > this.stopAt || this.scanDirection == 1 && l2 < this.stopAt) {
            this.close();
            throw StandardException.newException("XSLB8.S", logInstant, new LogCounter(this.stopAt));
        }
        long l3 = ((LogCounter)logInstant).getLogFileNumber();
        if (l3 != this.currentLogFileNumber) {
            this.scan.close();
            this.scan = this.logFactory.getLogFileAtPosition(l2);
            this.currentLogFileNumber = l3;
            if (this.scanDirection == 1) {
                this.currentLogFileLength = this.scan.length();
            }
        } else {
            long l4 = ((LogCounter)logInstant).getLogFilePosition();
            this.scan.seek(l4);
            this.currentLogFileLength = this.scan.length();
        }
        this.knownGoodLogEnd = this.currentInstant = l2;
    }

    @Override
    public long getInstant() {
        return this.currentInstant;
    }

    @Override
    public long getLogRecordEnd() {
        return this.knownGoodLogEnd;
    }

    @Override
    public boolean isLogEndFuzzy() {
        return this.fuzzyLogEnd;
    }

    @Override
    public LogInstant getLogInstant() {
        if (this.currentInstant == 0L) {
            return null;
        }
        return new LogCounter(this.currentInstant);
    }

    @Override
    public void close() {
        if (this.scan != null) {
            try {
                this.scan.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.scan = null;
        }
        this.logFactory = null;
        this.currentLogFileNumber = -1L;
        this.currentLogFileLength = -1L;
        this.currentInstant = 0L;
        this.stopAt = 0L;
        this.scanDirection = 0;
    }
}

