/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.RAFContainer;
import org.apache.derby.io.StorageFile;

class TempRAFContainer
extends RAFContainer {
    protected int inUseCount;

    TempRAFContainer(BaseDataFileFactory baseDataFileFactory) {
        super(baseDataFileFactory);
    }

    @Override
    public Cacheable setIdentity(Object object) throws StandardException {
        ContainerKey containerKey = (ContainerKey)object;
        if (containerKey.getSegmentId() != -1L) {
            FileContainer fileContainer = (FileContainer)this.dataFactory.newContainerObject();
            return fileContainer.setIdent(containerKey);
        }
        return super.setIdentity(containerKey);
    }

    @Override
    public Cacheable createIdentity(Object object, Object object2) throws StandardException {
        ContainerKey containerKey = (ContainerKey)object;
        if (containerKey.getSegmentId() != -1L) {
            Cacheable cacheable = this.dataFactory.newContainerObject();
            return cacheable.createIdentity(containerKey, object2);
        }
        return this.createIdent(containerKey, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContainer(LogInstant logInstant, boolean bl) throws StandardException {
        this.pageCache.discard(this.identity);
        TempRAFContainer tempRAFContainer = this;
        synchronized (tempRAFContainer) {
            this.setDroppedState(true);
            this.setCommittedDropState(true);
            this.setDirty(false);
            this.needsSync = false;
        }
        this.removeFile(this.getFileName(this.identity, false, false, false));
    }

    @Override
    protected int preAllocate(long l2, int n2) {
        return 0;
    }

    @Override
    protected void writePage(long l2, byte[] byArray, boolean bl) throws IOException, StandardException {
        if (!this.getDroppedState()) {
            super.writePage(l2, byArray, false);
        }
        this.needsSync = false;
    }

    @Override
    StorageFile getFileName(ContainerKey containerKey, boolean bl, boolean bl2, boolean bl3) {
        return this.privGetFileName(containerKey, bl, bl2, bl3);
    }

    @Override
    protected StorageFile privGetFileName(ContainerKey containerKey, boolean bl, boolean bl2, boolean bl3) {
        return this.dataFactory.storageFactory.newStorageFile(this.dataFactory.storageFactory.getTempDir(), "T" + containerKey.getContainerId() + ".tmp");
    }

    @Override
    public Page addPage(BaseContainerHandle baseContainerHandle, boolean bl) throws StandardException {
        BasePage basePage = this.newPage(baseContainerHandle, null, baseContainerHandle, bl);
        return basePage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(BaseContainerHandle baseContainerHandle) throws StandardException {
        TempRAFContainer tempRAFContainer = this;
        synchronized (tempRAFContainer) {
            this.setDroppedState(true);
            this.setCommittedDropState(true);
            this.setDirty(false);
            this.needsSync = false;
        }
        while (!this.pageCache.discard(this.identity)) {
        }
        this.removeFile(this.getFileName(this.identity, false, true, false));
        this.createIdent(this.identity, this);
        this.addPage(baseContainerHandle, false).unlatch();
    }

    @Override
    protected boolean use(BaseContainerHandle baseContainerHandle, boolean bl, boolean bl2) throws StandardException {
        if (super.use(baseContainerHandle, bl, bl2)) {
            ++this.inUseCount;
            return true;
        }
        return false;
    }

    @Override
    protected void letGo(BaseContainerHandle baseContainerHandle) {
        --this.inUseCount;
        super.letGo(baseContainerHandle);
    }

    public boolean isSingleUser() {
        return this.inUseCount == 1;
    }
}

