/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BranchControlRow;
import org.apache.derby.impl.store.access.btree.BranchRow;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;

public class LeafControlRow
extends ControlRow {
    public LeafControlRow() {
    }

    LeafControlRow(OpenBTree openBTree, Page page, ControlRow controlRow, boolean bl) throws StandardException {
        super(openBTree, page, 0, controlRow, bl);
    }

    private static LeafControlRow allocate(OpenBTree openBTree, ControlRow controlRow) throws StandardException {
        Page page = openBTree.container.addPage();
        LeafControlRow leafControlRow = new LeafControlRow(openBTree, page, controlRow, false);
        byte by = 0;
        by = (byte)(by | 1);
        RecordHandle recordHandle = page.insertAtSlot(0, leafControlRow.getRow(), null, null, by, 50);
        return leafControlRow;
    }

    private float get_left_nondeleted_rowcnt(int n2) throws StandardException {
        int n3 = 0;
        for (int i2 = 1; i2 <= n2; ++i2) {
            if (this.page.isDeletedAtSlot(i2)) continue;
            ++n3;
        }
        return n3;
    }

    @Override
    protected final void controlRowInit() {
    }

    public static void initEmptyBtree(OpenBTree openBTree) throws StandardException {
        Page page = openBTree.container.getPage(1L);
        LeafControlRow leafControlRow = new LeafControlRow(openBTree, page, null, true);
        byte by = 0;
        by = (byte)(by | 1);
        RecordHandle recordHandle = page.insertAtSlot(0, leafControlRow.getRow(), null, null, by, 50);
        page.unlatch();
    }

    @Override
    protected final int getNumberOfControlRowColumns() {
        return 7;
    }

    @Override
    public boolean isLeftmostLeaf() throws StandardException {
        return this.getleftSiblingPageNumber() == -1L;
    }

    @Override
    public boolean isRightmostLeaf() throws StandardException {
        return this.getrightSiblingPageNumber() == -1L;
    }

    @Override
    public ControlRow search(SearchParameters searchParameters) throws StandardException {
        this.searchForEntry(searchParameters);
        if (searchParameters.searchForOptimizer) {
            int n2 = searchParameters.resultSlot;
            if (searchParameters.resultExact && searchParameters.partial_key_match_op == 1) {
                --n2;
            }
            float f2 = this.get_left_nondeleted_rowcnt(n2);
            int n3 = this.page.nonDeletedRecordCount();
            if (this.getIsRoot()) {
                searchParameters.current_fraction = 1.0f;
                searchParameters.left_fraction = 0.0f;
            }
            if (n3 > 1) {
                searchParameters.left_fraction += searchParameters.current_fraction * (f2 / (float)(n3 - 1));
            }
            if (n3 > 1) {
                searchParameters.current_fraction *= 1.0f / (float)(n3 - 1);
            }
        }
        return this;
    }

    @Override
    protected ControlRow searchLeft(OpenBTree openBTree) throws StandardException {
        return this;
    }

    @Override
    protected ControlRow searchRight(OpenBTree openBTree) throws StandardException {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean shrinkFor(OpenBTree openBTree, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        boolean bl = false;
        try {
            if (this.page.recordCount() == 1 && !this.getIsRoot()) {
                bl = this.unlink(openBTree);
            }
        }
        finally {
            if (!bl) {
                this.release();
            }
        }
        return bl;
    }

    @Override
    protected long splitFor(OpenBTree openBTree, DataValueDescriptor[] dataValueDescriptorArray, BranchControlRow branchControlRow, DataValueDescriptor[] dataValueDescriptorArray2, int n2) throws StandardException {
        long l2 = this.page.getPageNumber();
        if (this.page.recordCount() - 1 < BTree.maxRowsPerPage && this.page.spaceForInsert(dataValueDescriptorArray2, null, 50)) {
            openBTree.getXactMgr().commit();
            if (branchControlRow != null) {
                branchControlRow.release();
            }
            this.release();
            return l2;
        }
        if (this.getIsRoot()) {
            LeafControlRow.growRoot(openBTree, dataValueDescriptorArray, this);
            ControlRow controlRow = ControlRow.get(openBTree, 1L);
            return controlRow.splitFor(openBTree, dataValueDescriptorArray, null, dataValueDescriptorArray2, n2);
        }
        int n3 = (this.page.recordCount() - 1) / 2 + 1;
        if ((n2 & 4) != 0) {
            n3 = 1;
        } else if ((n2 & 1) != 0) {
            n3 = this.page.recordCount() - 1;
        }
        Object[] objectArray = openBTree.getConglomerate().createTemplate(openBTree.getRawTran());
        this.page.fetchFromSlot(null, n3, objectArray, null, true);
        BranchRow branchRow = BranchRow.createBranchRowFromOldLeafRow((DataValueDescriptor[])objectArray, -1L);
        if (!branchControlRow.page.spaceForInsert(branchRow.getRow(), null, 50)) {
            return BranchControlRow.restartSplitFor(openBTree, dataValueDescriptorArray, branchControlRow, this, branchRow.getRow(), dataValueDescriptorArray2, n2);
        }
        LeafControlRow leafControlRow = LeafControlRow.allocate(openBTree, branchControlRow);
        branchRow.setPageNumber(leafControlRow.page.getPageNumber());
        leafControlRow.linkRight(openBTree, this);
        int n4 = this.page.recordCount() - n3;
        if (n4 != 0) {
            this.page.copyAndPurge(leafControlRow.page, n3, n4, 1);
        }
        BranchRow branchRow2 = BranchRow.createEmptyTemplate(openBTree.getRawTran(), openBTree.getConglomerate());
        SearchParameters searchParameters = new SearchParameters(branchRow.getRow(), 1, branchRow2.getRow(), openBTree, false);
        branchControlRow.searchForEntry(searchParameters);
        byte by = 0;
        by = (byte)(by | 1);
        by = (byte)(by | 2);
        if (branchControlRow.page.insertAtSlot(searchParameters.resultSlot + 1, branchRow.getRow(), null, null, by, 50) == null) {
            throw StandardException.newException("XSCB6.S", new Object[0]);
        }
        branchRow = null;
        this.page.setRepositionNeeded();
        openBTree.getXactMgr().commit();
        branchControlRow.release();
        this.release();
        long l3 = leafControlRow.page.getPageNumber();
        leafControlRow.release();
        return l3;
    }

    private static void growRoot(OpenBTree openBTree, DataValueDescriptor[] dataValueDescriptorArray, LeafControlRow leafControlRow) throws StandardException {
        BranchControlRow branchControlRow = null;
        LeafControlRow leafControlRow2 = null;
        leafControlRow2 = LeafControlRow.allocate(openBTree, leafControlRow);
        leafControlRow.page.copyAndPurge(leafControlRow2.page, 1, leafControlRow.page.recordCount() - 1, 1);
        branchControlRow = new BranchControlRow(openBTree, leafControlRow.page, 1, null, true, leafControlRow2.page.getPageNumber());
        leafControlRow = null;
        branchControlRow.page.updateAtSlot(0, branchControlRow.getRow(), null);
        branchControlRow.page.setRepositionNeeded();
        openBTree.getXactMgr().commit();
        if (branchControlRow != null) {
            branchControlRow.release();
        }
        if (leafControlRow != null) {
            leafControlRow.release();
        }
        if (leafControlRow2 != null) {
            leafControlRow2.release();
        }
    }

    @Override
    protected ControlRow getLeftChild(OpenBTree openBTree) throws StandardException {
        return null;
    }

    @Override
    protected ControlRow getRightChild(OpenBTree openBTree) throws StandardException {
        return null;
    }

    @Override
    public int checkConsistency(OpenBTree openBTree, ControlRow controlRow, boolean bl) throws StandardException {
        this.checkGeneric(openBTree, controlRow, bl);
        return 1;
    }

    @Override
    public void printTree(OpenBTree openBTree) throws StandardException {
    }

    @Override
    public int getTypeFormatId() {
        return 133;
    }
}

