/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.btree.BTreeScan;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;

public class BTreeRowPosition
extends RowPosition {
    public DataValueDescriptor[] current_positionKey;
    public LeafControlRow current_leaf;
    protected LeafControlRow next_leaf;
    public DataValueDescriptor[] current_lock_template;
    public RowLocation current_lock_row_loc;
    private final BTreeScan parent;
    long versionWhenSaved;
    private DataValueDescriptor[] positionKey_template;
    private FetchDescriptor savedFetchDescriptor;

    public BTreeRowPosition(BTreeScan bTreeScan) {
        this.parent = bTreeScan;
    }

    @Override
    public void init() {
        super.init();
        this.current_leaf = null;
        this.current_positionKey = null;
    }

    @Override
    public final void unlatch() {
        if (this.current_leaf != null) {
            this.current_leaf.release();
            this.current_leaf = null;
        }
        this.current_slot = -1;
    }

    public void saveMeAndReleasePage() throws StandardException {
        this.parent.savePositionAndReleasePage();
    }

    DataValueDescriptor[] getKeyTemplate() throws StandardException {
        if (this.positionKey_template == null) {
            this.positionKey_template = this.parent.getRuntimeMem().get_row_for_export(this.parent.getRawTran());
        }
        return this.positionKey_template;
    }

    FetchDescriptor getFetchDescriptorForSaveKey(int[] nArray, int n2) {
        if (this.savedFetchDescriptor == null) {
            int n3;
            FormatableBitSet formatableBitSet = new FormatableBitSet(n2);
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] != 0) continue;
                formatableBitSet.set(n3);
            }
            for (n3 = nArray.length; n3 < n2; ++n3) {
                formatableBitSet.set(n3);
            }
            this.savedFetchDescriptor = new FetchDescriptor(n2, formatableBitSet, null);
        }
        return this.savedFetchDescriptor;
    }

    @Override
    public final String toString() {
        String string = null;
        return string;
    }
}

