/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;

public class RealTableScanStatistics
extends RealNoPutResultSetStatistics {
    public boolean isConstraint;
    public boolean coarserLock;
    public int fetchSize;
    public String isolationLevel;
    public String tableName;
    public String userSuppliedOptimizerOverrides;
    public String indexName;
    public String lockString;
    public String qualifiers;
    public String startPosition;
    public String stopPosition;
    public FormatableProperties scanProperties;

    public RealTableScanStatistics(int n2, int n3, int n4, long l2, long l3, long l4, long l5, int n5, String string, String string2, String string3, boolean bl, String string4, Properties properties, String string5, String string6, String string7, String string8, int n6, boolean bl2, double d2, double d3) {
        super(n2, n3, n4, l2, l3, l4, l5, n5, d2, d3);
        this.tableName = string;
        this.userSuppliedOptimizerOverrides = string2;
        this.indexName = string3;
        this.isConstraint = bl;
        this.qualifiers = string4;
        this.scanProperties = new FormatableProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string9 = (String)enumeration.nextElement();
            this.scanProperties.put(string9, properties.get(string9));
        }
        this.startPosition = string5;
        this.stopPosition = string6;
        this.isolationLevel = string7;
        this.lockString = string8;
        this.fetchSize = n6;
        this.coarserLock = bl2;
    }

    @Override
    public String getStatementExecutionPlanText(int n2) {
        String string = "";
        Object var3_3 = null;
        this.initFormatInfo(n2);
        if (this.userSuppliedOptimizerOverrides != null) {
            string = this.indent + MessageService.getTextMessage("43Y56.U", this.tableName, this.userSuppliedOptimizerOverrides);
            string = string + "\n";
        }
        string = this.indexName != null ? string + this.indent + MessageService.getTextMessage("43Y09.U", this.tableName, this.isConstraint ? "constraint" : "index", this.indexName) : string + this.indent + MessageService.getTextMessage("43Y10.U", this.tableName);
        string = string + " " + MessageService.getTextMessage("43X72.U", this.isolationLevel, this.lockString);
        if (this.coarserLock) {
            string = string + " (" + MessageService.getTextMessage("43Y11.U", new Object[0]) + ")";
        }
        string = string + "\n";
        String string2 = this.indent + MessageService.getTextMessage("43X28.U", new Object[0]) + ":\n" + PropertyUtil.sortProperties(this.scanProperties, this.subIndent);
        return string + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X04.U", new Object[0]) + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U", new Object[0]) + " = " + this.rowsFiltered + "\n" + this.indent + MessageService.getTextMessage("43Y12.U", new Object[0]) + " = " + this.fetchSize + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + (this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U", new Object[0]) + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + string2 + this.subIndent + MessageService.getTextMessage("43X34.U", new Object[0]) + ":\n" + StringUtil.ensureIndent(this.startPosition, n2 + 2) + "\n" + this.subIndent + MessageService.getTextMessage("43X35.U", new Object[0]) + ":\n" + StringUtil.ensureIndent(this.stopPosition, n2 + 2) + "\n" + this.subIndent + MessageService.getTextMessage("43Y13.U", new Object[0]) + ":\n" + StringUtil.ensureIndent(this.qualifiers, n2 + 2) + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    @Override
    public String getScanStatisticsText(String string, int n2) {
        if (string == null || string.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(n2);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage(this.indexName == null ? "43X73.U" : "43X74.U", new Object[0]);
    }

    @Override
    public String getNodeOn() {
        if (this.indexName == null) {
            return MessageService.getTextMessage("43X75.U", this.tableName);
        }
        return MessageService.getTextMessage("43X38.U", this.tableName, this.indexName);
    }

    @Override
    public void accept(XPLAINVisitor xPLAINVisitor) {
        xPLAINVisitor.setNumberOfChildren(0);
        xPLAINVisitor.visit(this);
    }

    @Override
    public String getRSXplainType() {
        if (this.indexName != null) {
            return this.isConstraint ? "CONSTRAINTSCAN" : "INDEXSCAN";
        }
        return "TABLESCAN";
    }

    @Override
    public String getRSXplainDetails() {
        if (this.indexName != null) {
            return (this.isConstraint ? "C: " : "I: ") + this.indexName;
        }
        return "T: " + this.tableName;
    }

    @Override
    public Object getScanPropsDescriptor(Object object) {
        String string;
        String string2;
        if (this.indexName != null) {
            if (this.isConstraint) {
                string2 = "C";
                string = this.indexName;
            } else {
                string2 = "I";
                string = this.indexName;
            }
        } else {
            string2 = "T";
            string = this.tableName;
        }
        String string3 = XPLAINUtil.getIsolationLevelCode(this.isolationLevel);
        XPLAINScanPropsDescriptor xPLAINScanPropsDescriptor = new XPLAINScanPropsDescriptor((UUID)object, string, string2, null, string3, null, null, null, null, null, null, null, this.fetchSize, this.startPosition, this.stopPosition, this.qualifiers, null, null, null);
        FormatableProperties formatableProperties = this.scanProperties;
        return XPLAINUtil.extractScanProps(xPLAINScanPropsDescriptor, formatableProperties);
    }

    @Override
    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = XPLAINUtil.getLockModeCode(this.lockString);
        String string2 = XPLAINUtil.getLockGranularityCode(this.lockString);
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), this.numOpens, null, string, string2, (UUID)object2, this.optimizerEstimatedRowCount, this.optimizerEstimatedCost, null, null, null, this.rowsSeen, null, this.rowsFiltered, this.rowsSeen - this.rowsFiltered, null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }
}

