/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.transaction.TransactionControl;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.types.VariableSizeDataValue;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.UpdatableVTIConstantAction;
import org.apache.derby.vti.AwareVTI;
import org.apache.derby.vti.DeferModification;
import org.apache.derby.vti.IFastPath;
import org.apache.derby.vti.IQualifyable;
import org.apache.derby.vti.Pushable;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;
import org.apache.derby.vti.VTIContext;
import org.apache.derby.vti.VTIEnvironment;
import org.w3c.dom.Element;

class VTIResultSet
extends NoPutResultSetImpl
implements CursorResultSet,
VTIEnvironment {
    public int rowsReturned;
    public String javaClassName;
    private GeneratedMethod constructor;
    private PreparedStatement userPS;
    private ResultSet userVTI;
    private final ExecRow allocatedRow;
    private FormatableBitSet referencedColumns;
    private boolean version2;
    private boolean reuseablePs;
    private boolean isTarget;
    private final FormatableHashtable compileTimeConstants;
    private boolean pushedProjection;
    private IFastPath fastPath;
    private Qualifier[][] pushedQualifiers;
    private boolean[] runtimeNullableColumn;
    private boolean isDerbyStyleTableFunction;
    private final TypeDescriptor returnType;
    private DataTypeDescriptor[] returnColumnTypes;
    private String[] vtiProjection;
    private Restriction vtiRestriction;
    private String vtiSchema;
    private String vtiName;
    private int scanIsolationLevel = 0;

    VTIResultSet(Activation activation, int n2, int n3, GeneratedMethod generatedMethod, String string, Qualifier[][] qualifierArray, int n4, boolean bl, boolean bl2, int n5, boolean bl3, int n6, double d2, double d3, boolean bl4, int n7, int n8, int n9, String string2, String string3) throws StandardException {
        super(activation, n3, d2, d3);
        this.constructor = generatedMethod;
        this.javaClassName = string;
        this.version2 = bl;
        this.reuseablePs = bl2;
        this.isTarget = bl3;
        this.pushedQualifiers = qualifierArray;
        this.scanIsolationLevel = n6;
        this.isDerbyStyleTableFunction = bl4;
        this.vtiSchema = string2;
        this.vtiName = string3;
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        this.allocatedRow = ((ExecRowBuilder)execPreparedStatement.getSavedObject(n2)).build(activation.getExecutionFactory());
        this.returnType = n7 == -1 ? null : (TypeDescriptor)activation.getPreparedStatement().getSavedObject(n7);
        this.vtiProjection = n8 == -1 ? null : (String[])activation.getPreparedStatement().getSavedObject(n8);
        Restriction restriction = this.vtiRestriction = n9 == -1 ? null : (Restriction)activation.getPreparedStatement().getSavedObject(n9);
        if (n4 != -1) {
            this.referencedColumns = (FormatableBitSet)activation.getPreparedStatement().getSavedObject(n4);
        }
        this.compileTimeConstants = (FormatableHashtable)activation.getPreparedStatement().getSavedObject(n5);
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.isOpen = true;
        ++this.numOpens;
        try {
            if (this.version2) {
                Object object;
                this.userPS = (PreparedStatement)this.constructor.invoke(this.activation);
                if (this.userPS instanceof Pushable) {
                    object = (Pushable)((Object)this.userPS);
                    if (this.referencedColumns != null) {
                        this.pushedProjection = object.pushProjection(this, this.getProjectedColList());
                    }
                }
                if (this.userPS instanceof IQualifyable) {
                    object = (IQualifyable)((Object)this.userPS);
                    object.setQualifiers(this, this.pushedQualifiers);
                }
                IFastPath iFastPath = this.fastPath = this.userPS instanceof IFastPath ? (IFastPath)((Object)this.userPS) : null;
                if (this.isTarget && this.userPS instanceof DeferModification && this.activation.getConstantAction() instanceof UpdatableVTIConstantAction) {
                    object = (UpdatableVTIConstantAction)this.activation.getConstantAction();
                    ((DeferModification)((Object)this.userPS)).modificationNotify(((UpdatableVTIConstantAction)object).statementType, ((UpdatableVTIConstantAction)object).deferred);
                }
                if (this.fastPath == null || !this.fastPath.executeAsFastPath()) {
                    this.userVTI = this.userPS.executeQuery();
                }
                if (this.isTarget) {
                    this.activation.setTargetVTI(this.userVTI);
                }
            } else {
                Object object;
                this.userVTI = (ResultSet)this.constructor.invoke(this.activation);
                if (this.userVTI instanceof RestrictedVTI) {
                    object = (RestrictedVTI)((Object)this.userVTI);
                    object.initScan(this.vtiProjection, this.cloneRestriction(this.activation));
                }
                if (this.userVTI instanceof AwareVTI) {
                    object = (AwareVTI)((Object)this.userVTI);
                    object.setContext(new VTIContext(this.vtiSchema, this.vtiName, this.activation.getLanguageConnectionContext().getStatementContext().getStatementText()));
                }
            }
            this.setNullableColumnList();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private Restriction cloneRestriction(Activation activation) throws StandardException {
        if (this.vtiRestriction == null) {
            return null;
        }
        return this.cloneRestriction(activation, this.vtiRestriction);
    }

    private Restriction cloneRestriction(Activation activation, Restriction restriction) throws StandardException {
        if (restriction instanceof Restriction.AND) {
            Restriction.AND aND = (Restriction.AND)restriction;
            return new Restriction.AND(this.cloneRestriction(activation, aND.getLeftChild()), this.cloneRestriction(activation, aND.getRightChild()));
        }
        if (restriction instanceof Restriction.OR) {
            Restriction.OR oR = (Restriction.OR)restriction;
            return new Restriction.OR(this.cloneRestriction(activation, oR.getLeftChild()), this.cloneRestriction(activation, oR.getRightChild()));
        }
        if (restriction instanceof Restriction.ColumnQualifier) {
            Object object;
            Restriction.ColumnQualifier columnQualifier = (Restriction.ColumnQualifier)restriction;
            Object object2 = columnQualifier.getConstantOperand();
            if (object2 == null) {
                object = null;
            } else if (object2 instanceof int[]) {
                int n2 = ((int[])object2)[0];
                ParameterValueSet parameterValueSet = activation.getParameterValueSet();
                object = parameterValueSet.getParameter(n2).getObject();
            } else {
                object = object2;
            }
            return new Restriction.ColumnQualifier(columnQualifier.getColumnName(), columnQualifier.getComparisonOperator(), object);
        }
        throw StandardException.newException("0A000.S", restriction.getClass().getName());
    }

    private boolean[] setNullableColumnList() throws SQLException, StandardException {
        if (this.runtimeNullableColumn != null) {
            return this.runtimeNullableColumn;
        }
        if (this.isDerbyStyleTableFunction) {
            int n2 = this.getAllocatedRow().nColumns() + 1;
            this.runtimeNullableColumn = new boolean[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.runtimeNullableColumn[i2] = true;
            }
            return this.runtimeNullableColumn;
        }
        if (this.userVTI == null) {
            return null;
        }
        ResultSetMetaData resultSetMetaData = this.userVTI.getMetaData();
        boolean[] blArray = new boolean[resultSetMetaData.getColumnCount() + 1];
        for (int i3 = 1; i3 < blArray.length; ++i3) {
            blArray[i3] = resultSetMetaData.isNullable(i3) != 0;
        }
        this.runtimeNullableColumn = blArray;
        return blArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void reopenCore() throws StandardException {
        if (this.reuseablePs) {
            if (this.userVTI == null) return;
            try {
                this.userVTI.close();
                this.userVTI = this.userPS.executeQuery();
                if (!this.isTarget) return;
                this.activation.setTargetVTI(this.userVTI);
                return;
            }
            catch (SQLException sQLException) {
                throw StandardException.unexpectedUserException(sQLException);
            }
        } else {
            this.close();
            this.openCore();
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            try {
                int n2;
                if (this.userVTI == null && this.fastPath != null && (n2 = this.fastPath.nextRow((execRow = this.getAllocatedRow()).getRowArray())) != 0) {
                    if (n2 == -1) {
                        execRow = null;
                    } else if (n2 == 1) {
                        this.userVTI = this.userPS.executeQuery();
                    }
                }
                if (this.userVTI != null) {
                    if (!this.userVTI.next()) {
                        if (null != this.fastPath) {
                            this.fastPath.rowsDone();
                        }
                        execRow = null;
                    } else {
                        SQLWarning sQLWarning;
                        execRow = this.getAllocatedRow();
                        this.populateFromResultSet(execRow);
                        if (this.fastPath != null) {
                            this.fastPath.currentRow(this.userVTI, execRow.getRowArray());
                        }
                        if ((sQLWarning = this.userVTI.getWarnings()) != null) {
                            this.addWarning(sQLWarning);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        this.setCurrentRow(execRow);
        if (execRow != null) {
            ++this.rowsReturned;
            ++this.rowsSeen;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.userVTI != null) {
                try {
                    this.userVTI.close();
                }
                catch (SQLException sQLException) {
                    throw StandardException.unexpectedUserException(sQLException);
                }
                finally {
                    this.userVTI = null;
                }
            }
            if (this.userPS != null && !this.reuseablePs) {
                try {
                    this.userPS.close();
                }
                catch (SQLException sQLException) {
                    throw StandardException.unexpectedUserException(sQLException);
                }
                finally {
                    this.userPS = null;
                }
            }
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void finish() throws StandardException {
        if (this.userPS != null && !this.reuseablePs) {
            try {
                this.userPS.close();
                this.userPS = null;
            }
            catch (SQLException sQLException) {
                throw StandardException.unexpectedUserException(sQLException);
            }
        }
        this.finishAndRTS();
    }

    @Override
    public long getTimeSpent(int n2) {
        long l2 = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        return l2;
    }

    @Override
    public RowLocation getRowLocation() {
        return null;
    }

    @Override
    public ExecRow getCurrentRow() {
        return null;
    }

    GeneratedMethod getVTIConstructor() {
        return this.constructor;
    }

    boolean isReuseablePs() {
        return this.reuseablePs;
    }

    private ExecRow getAllocatedRow() throws StandardException {
        return this.allocatedRow;
    }

    private int[] getProjectedColList() {
        FormatableBitSet formatableBitSet = this.referencedColumns;
        int n2 = formatableBitSet.size();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!formatableBitSet.isSet(i2)) continue;
            ++n3;
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            if (!formatableBitSet.isSet(i3)) continue;
            nArray[n4++] = i3 + 1;
        }
        return nArray;
    }

    public void populateFromResultSet(ExecRow execRow) throws StandardException {
        try {
            DataTypeDescriptor[] dataTypeDescriptorArray = null;
            if (this.isDerbyStyleTableFunction) {
                dataTypeDescriptorArray = this.getReturnColumnTypes();
            }
            boolean[] blArray = this.setNullableColumnList();
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            int n2 = 1;
            for (int i2 = 0; i2 < dataValueDescriptorArray.length; ++i2) {
                if (this.referencedColumns != null && !this.referencedColumns.get(i2)) {
                    if (this.pushedProjection) continue;
                    ++n2;
                    continue;
                }
                dataValueDescriptorArray[i2].setValueFromResultSet(this.userVTI, n2, blArray[n2]);
                ++n2;
                if (!this.isDerbyStyleTableFunction) continue;
                DataTypeDescriptor dataTypeDescriptor = dataTypeDescriptorArray[i2];
                DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[i2];
                this.cast(dataTypeDescriptor, dataValueDescriptor);
            }
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    @Override
    public final int getScanIsolationLevel() {
        return this.scanIsolationLevel;
    }

    @Override
    public final boolean isCompileTime() {
        return false;
    }

    @Override
    public final String getOriginalSQL() {
        return this.activation.getPreparedStatement().getSource();
    }

    @Override
    public final int getStatementIsolationLevel() {
        return TransactionControl.jdbcIsolationLevel(this.getScanIsolationLevel());
    }

    @Override
    public final void setSharedState(String string, Serializable serializable) {
        if (string == null) {
            return;
        }
        if (serializable == null) {
            this.compileTimeConstants.remove(string);
        } else {
            this.compileTimeConstants.put(string, serializable);
        }
    }

    @Override
    public Object getSharedState(String string) {
        if (string == null || this.compileTimeConstants == null) {
            return null;
        }
        return this.compileTimeConstants.get(string);
    }

    private DataTypeDescriptor[] getReturnColumnTypes() throws StandardException {
        if (this.returnColumnTypes == null) {
            TypeDescriptor[] typeDescriptorArray = this.returnType.getRowTypes();
            int n2 = typeDescriptorArray.length;
            this.returnColumnTypes = new DataTypeDescriptor[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.returnColumnTypes[i2] = DataTypeDescriptor.getType(typeDescriptorArray[i2]);
            }
        }
        return this.returnColumnTypes;
    }

    private void cast(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        TypeId typeId = dataTypeDescriptor.getTypeId();
        if (!typeId.isBlobTypeId() && !typeId.isClobTypeId()) {
            if (typeId.isLongVarcharTypeId()) {
                this.castLongvarchar(dataTypeDescriptor, dataValueDescriptor);
            } else if (typeId.isLongVarbinaryTypeId()) {
                this.castLongvarbinary(dataTypeDescriptor, dataValueDescriptor);
            } else if (typeId.isDecimalTypeId()) {
                this.castDecimal(dataTypeDescriptor, dataValueDescriptor);
            } else {
                Object object = dataValueDescriptor.getObject();
                dataValueDescriptor.setObjectForCast(object, true, typeId.getCorrespondingJavaTypeName());
                if (typeId.variableLength()) {
                    VariableSizeDataValue variableSizeDataValue = (VariableSizeDataValue)((Object)dataValueDescriptor);
                    int n2 = typeId.isNumericTypeId() ? dataTypeDescriptor.getPrecision() : dataTypeDescriptor.getMaximumWidth();
                    variableSizeDataValue.setWidth(n2, dataTypeDescriptor.getScale(), false);
                }
            }
        }
    }

    private void castLongvarchar(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor.getLength() > 32700) {
            dataValueDescriptor.setValue(dataValueDescriptor.getString().substring(0, 32700));
        }
    }

    private void castLongvarbinary(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor.getLength() > 32700) {
            byte[] byArray = dataValueDescriptor.getBytes();
            byte[] byArray2 = new byte[32700];
            System.arraycopy(byArray, 0, byArray2, 0, 32700);
            dataValueDescriptor.setValue(byArray2);
        }
    }

    private void castDecimal(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        VariableSizeDataValue variableSizeDataValue = (VariableSizeDataValue)((Object)dataValueDescriptor);
        variableSizeDataValue.setWidth(dataTypeDescriptor.getPrecision(), dataTypeDescriptor.getScale(), false);
    }

    @Override
    public Element toXML(Element element, String string) throws Exception {
        Element element2 = super.toXML(element, string);
        element2.setAttribute("javaClassName", this.javaClassName);
        return element2;
    }
}

