/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class GenericQualifier
implements Qualifier {
    private int columnId;
    private int operator;
    private GeneratedMethod orderableGetter;
    private Activation activation;
    private boolean orderedNulls;
    private boolean unknownRV;
    private boolean negateCompareResult;
    protected int variantType;
    private DataValueDescriptor orderableCache = null;

    public GenericQualifier(int n2, int n3, GeneratedMethod generatedMethod, Activation activation, boolean bl, boolean bl2, boolean bl3, int n4) {
        this.columnId = n2;
        this.operator = n3;
        this.orderableGetter = generatedMethod;
        this.activation = activation;
        this.orderedNulls = bl;
        this.unknownRV = bl2;
        this.negateCompareResult = bl3;
        this.variantType = n4;
    }

    @Override
    public int getColumnId() {
        return this.columnId;
    }

    @Override
    public DataValueDescriptor getOrderable() throws StandardException {
        if (this.variantType != 0) {
            if (this.orderableCache == null) {
                this.orderableCache = (DataValueDescriptor)this.orderableGetter.invoke(this.activation);
            }
            return this.orderableCache;
        }
        return (DataValueDescriptor)this.orderableGetter.invoke(this.activation);
    }

    @Override
    public int getOperator() {
        return this.operator;
    }

    @Override
    public boolean negateCompareResult() {
        return this.negateCompareResult;
    }

    @Override
    public boolean getOrderedNulls() {
        return this.orderedNulls;
    }

    @Override
    public boolean getUnknownRV() {
        return this.unknownRV;
    }

    @Override
    public void clearOrderableCache() {
        if (this.variantType == 1 || this.variantType == 0) {
            this.orderableCache = null;
        }
    }

    @Override
    public void reinitialize() {
        if (this.variantType != 3) {
            this.orderableCache = null;
        }
    }

    public String toString() {
        return "";
    }
}

