/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.SubqueryNode;

class SubqueryList
extends QueryTreeNodeVector<SubqueryNode> {
    SubqueryList(ContextManager contextManager) {
        super(SubqueryNode.class, contextManager);
    }

    void addSubqueryNode(SubqueryNode subqueryNode) throws StandardException {
        this.addElement(subqueryNode);
    }

    void optimize(DataDictionary dataDictionary, double d2) throws StandardException {
        for (SubqueryNode subqueryNode : this) {
            subqueryNode.optimize(dataDictionary, d2);
        }
    }

    void modifyAccessPaths() throws StandardException {
        for (SubqueryNode subqueryNode : this) {
            subqueryNode.modifyAccessPaths();
        }
    }

    boolean referencesTarget(String string, boolean bl) throws StandardException {
        for (SubqueryNode subqueryNode : this) {
            if (subqueryNode.isMaterializable() || !subqueryNode.getResultSet().referencesTarget(string, bl)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        for (SubqueryNode subqueryNode : this) {
            if (!subqueryNode.referencesSessionSchema()) continue;
            return true;
        }
        return false;
    }

    void setPointOfAttachment(int n2) throws StandardException {
        for (SubqueryNode subqueryNode : this) {
            subqueryNode.setPointOfAttachment(n2);
        }
    }

    void decrementLevel(int n2) {
        for (SubqueryNode subqueryNode : this) {
            subqueryNode.getResultSet().decrementLevel(n2);
        }
    }

    void markHavingSubqueries() {
        for (SubqueryNode subqueryNode : this) {
            subqueryNode.setHavingSubquery(true);
        }
    }

    void markWhereSubqueries() {
        for (SubqueryNode subqueryNode : this) {
            subqueryNode.setWhereSubquery(true);
        }
    }
}

