/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.SQLToJavaValueNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UserAggregateDefinition;
import org.apache.derby.impl.sql.compile.ValueNode;

class StaticMethodCallNode
extends MethodCallNode {
    private TableName procedureName;
    private LocalField[] outParamArrays;
    private int[] applicationParameterNumbers;
    private boolean isSystemCode;
    private boolean isInsideBind;
    private LocalField returnsNullOnNullState;
    private String routineDefiner = null;
    AliasDescriptor ad;
    private AggregateNode resolvedAggregate;
    private boolean appearsInGroupBy = false;

    StaticMethodCallNode(String string, String string2, ContextManager contextManager) {
        super(string, contextManager);
        this.javaClassName = string2;
    }

    StaticMethodCallNode(TableName tableName, String string, ContextManager contextManager) {
        super(tableName.getTableName(), contextManager);
        this.procedureName = tableName;
        this.javaClassName = string;
    }

    public AggregateNode getResolvedAggregate() {
        return this.resolvedAggregate;
    }

    public void setAppearsInGroupBy() {
        this.appearsInGroupBy = true;
    }

    @Override
    TableName getFullName() {
        return this.procedureName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    JavaValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        if (this.isInsideBind) {
            return this;
        }
        this.isInsideBind = true;
        try {
            JavaValueNode javaValueNode = this.bindExpressionMinion(fromList, subqueryList, list);
            return javaValueNode;
        }
        finally {
            this.isInsideBind = false;
        }
    }

    private JavaValueNode bindExpressionMinion(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.bindParameters(fromList, subqueryList, list);
        if (this.javaClassName == null) {
            object4 = this.getCompilerContext();
            object3 = this.procedureName.getSchemaName();
            boolean bl = object3 == null;
            object2 = this.getSchemaDescriptor((String)object3, object3 != null);
            this.resolveRoutine(fromList, subqueryList, list, (SchemaDescriptor)object2, bl);
            if (this.ad != null && this.ad.getAliasType() == 'G') {
                this.resolvedAggregate = new AggregateNode(((SQLToJavaValueNode)this.methodParms[0]).getSQLValueNode(), new UserAggregateDefinition(this.ad), this.procedureName, false, this.ad.getJavaClassName(), this.getContextManager());
                this.resolvedAggregate.copyTagsFrom(this);
                if (this.appearsInGroupBy) {
                    throw StandardException.newException("42Y26.S.0", new Object[0]);
                }
                return this;
            }
            object = object2;
            if (this.ad == null && bl && !this.forCallStatement) {
                object2 = this.getSchemaDescriptor("SYSFUN", true);
                this.resolveRoutine(fromList, subqueryList, list, (SchemaDescriptor)object2, bl);
            }
            if (this.ad == null) {
                object2 = object;
                if (!this.forCallStatement) {
                    this.forCallStatement = true;
                    this.resolveRoutine(fromList, subqueryList, list, (SchemaDescriptor)object2, bl);
                    this.forCallStatement = false;
                    if (this.ad != null) {
                        throw StandardException.newException("42Y03.S.3", this.procedureName);
                    }
                } else {
                    this.forCallStatement = false;
                    this.resolveRoutine(fromList, subqueryList, list, (SchemaDescriptor)object2, bl);
                    this.forCallStatement = true;
                    if (this.ad != null) {
                        throw StandardException.newException("42Y03.S.4", this.procedureName);
                    }
                }
            }
            if (this.ad == null) {
                throw StandardException.newException("42Y03.S.0", this.procedureName);
            }
            if (bl) {
                this.procedureName.setSchemaName(((SchemaDescriptor)object2).getSchemaName());
            }
            if (!this.routineInfo.isDeterministic()) {
                this.checkReliability(this.getMethodName(), 4096);
            }
            if (this.permitsSQL(this.routineInfo)) {
                this.checkReliability(this.getMethodName(), 8192);
            }
            object4.createDependency(this.ad);
            this.methodName = this.ad.getAliasInfo().getMethodName();
            this.javaClassName = this.ad.getJavaClassName();
            if (!(!this.javaClassName.startsWith("org.apache.derby.") || this.javaClassName.startsWith("org.apache.derby.impl.tools.optional.") || this.javaClassName.startsWith("org.apache.derby.optional.lucene.") || this.javaClassName.startsWith("org.apache.derby.optional.json.") || this.javaClassName.startsWith("org.apache.derby.optional.api.") || this.javaClassName.startsWith("org.apache.derby.optional.dump.") || this.javaClassName.startsWith("org.apache.derby.vti.") || ((SchemaDescriptor)object2).isSystemSchema())) {
                throw StandardException.newException("42X51", null, this.javaClassName);
            }
        }
        this.verifyClassExist(this.javaClassName);
        this.resolveMethodCall(this.javaClassName, true);
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredRoutinePriv(this.ad);
        }
        if (this.routineInfo != null) {
            if (this.methodParms != null) {
                this.optimizeDomainValueConversion();
            }
            if ((object4 = this.routineInfo.getReturnType()) != null) {
                this.createTypeDependency(DataTypeDescriptor.getType((TypeDescriptor)object4));
            }
            if (object4 != null && !object4.isRowMultiSet() && !object4.isUserDefinedType() && ((TypeId)(object3 = TypeId.getBuiltInTypeId(object4.getJDBCTypeId()))).variableLength()) {
                DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor((TypeId)object3, object4.getPrecision(), object4.getScale(), object4.isNullable(), object4.getMaximumWidth());
                object2 = new JavaToSQLValueNode(this, this.getContextManager());
                object = new CastNode((ValueNode)object2, dataTypeDescriptor, this.getContextManager());
                ((ValueNode)object).setCollationInfo(object4.getCollationType(), 1);
                SQLToJavaValueNode sQLToJavaValueNode = new SQLToJavaValueNode((ValueNode)object, this.getContextManager());
                sQLToJavaValueNode.setCollationType(object4.getCollationType());
                return ((JavaValueNode)sQLToJavaValueNode).bindExpression(fromList, subqueryList, list);
            }
        }
        return this;
    }

    private boolean permitsSQL(RoutineAliasInfo routineAliasInfo) {
        short s2 = routineAliasInfo.getSQLAllowed();
        switch (s2) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private void optimizeDomainValueConversion() throws StandardException {
        if (!this.routineInfo.calledOnNullInput()) {
            return;
        }
        int n2 = this.methodParms.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JavaValueNode javaValueNode;
            if (this.methodParms != null && this.methodParms[i2].mustCastToPrimitive() || !(this.methodParms[i2] instanceof SQLToJavaValueNode) || !(((SQLToJavaValueNode)this.methodParms[i2]).getSQLValueNode() instanceof JavaToSQLValueNode) || !((javaValueNode = ((JavaToSQLValueNode)((SQLToJavaValueNode)this.methodParms[i2]).getSQLValueNode()).getJavaValueNode()) instanceof StaticMethodCallNode)) continue;
            StaticMethodCallNode staticMethodCallNode = (StaticMethodCallNode)javaValueNode;
            if (staticMethodCallNode.routineInfo == null || !staticMethodCallNode.routineInfo.calledOnNullInput()) continue;
            this.methodParms[i2] = ((JavaToSQLValueNode)((SQLToJavaValueNode)this.methodParms[i2]).getSQLValueNode()).getJavaValueNode();
        }
    }

    private void resolveRoutine(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list, SchemaDescriptor schemaDescriptor, boolean bl) throws StandardException {
        if (schemaDescriptor.getUUID() != null) {
            List<AliasDescriptor> list2 = this.getDataDictionary().getRoutineList(schemaDescriptor.getUUID().toString(), this.methodName, this.forCallStatement ? (char)'P' : 'F');
            for (int i2 = list2.size() - 1; i2 >= 0; --i2) {
                AliasDescriptor aliasDescriptor = list2.get(i2);
                RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)aliasDescriptor.getAliasInfo();
                int n2 = routineAliasInfo.getParameterCount();
                boolean bl2 = routineAliasInfo.hasVarargs();
                if (bl2 ? this.methodParms.length < n2 - 1 : n2 != this.methodParms.length) continue;
                TypeDescriptor[] typeDescriptorArray = routineAliasInfo.getParameterTypes();
                int n3 = n2;
                if (routineAliasInfo.getMaxDynamicResultSets() > 0) {
                    ++n3;
                }
                this.signature = new JSQLType[n3];
                for (int i3 = 0; i3 < n2; ++i3) {
                    Object object;
                    TypeId typeId;
                    TypeDescriptor typeDescriptor = typeDescriptorArray[i3];
                    TypeId typeId2 = typeId = TypeId.getTypeId(typeDescriptor);
                    int n4 = routineAliasInfo.getParameterModes()[this.getRoutineArgIdx(routineAliasInfo, i3)];
                    if (n4 != 1) {
                        switch (typeId.getJDBCTypeId()) {
                            case -5: 
                            case 4: 
                            case 5: 
                            case 7: 
                            case 8: 
                            case 16: {
                                object = this.getTypeCompiler(typeId).getCorrespondingPrimitiveTypeName().concat("[]");
                                break;
                            }
                            default: {
                                object = typeId.getCorrespondingJavaTypeName().concat("[]");
                            }
                        }
                        typeId = TypeId.getUserDefinedTypeId((String)object);
                    }
                    object = new DataTypeDescriptor(typeId, typeDescriptor.getPrecision(), typeDescriptor.getScale(), typeDescriptor.isNullable(), typeDescriptor.getMaximumWidth());
                    this.signature[i3] = new JSQLType((DataTypeDescriptor)object);
                    DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor(typeId2, typeDescriptor.getPrecision(), typeDescriptor.getScale(), typeDescriptor.isNullable(), typeDescriptor.getMaximumWidth());
                    if (bl2 && i3 == n2 - 1) {
                        for (int i4 = i3; i4 < this.methodParms.length; ++i4) {
                            this.coerceMethodParameter(fromList, subqueryList, list, routineAliasInfo, this.methodParms.length, dataTypeDescriptor, typeId2, n4, i4);
                        }
                        continue;
                    }
                    this.coerceMethodParameter(fromList, subqueryList, list, routineAliasInfo, this.methodParms.length, dataTypeDescriptor, typeId2, n4, i3);
                }
                if (n3 != n2) {
                    DataTypeDescriptor dataTypeDescriptor = new DataTypeDescriptor(TypeId.getUserDefinedTypeId("java.sql.ResultSet[]"), 0, 0, false, -1);
                    this.signature[n2] = new JSQLType(dataTypeDescriptor);
                }
                this.routineInfo = routineAliasInfo;
                this.ad = aliasDescriptor;
                if (schemaDescriptor.isSystemSchema() && this.routineInfo.getReturnType() == null && this.routineInfo.getSQLAllowed() != 3) {
                    this.isSystemCode = true;
                }
                this.routineDefiner = schemaDescriptor.getAuthorizationId();
                break;
            }
        }
        if (this.ad == null && this.methodParms.length == 1) {
            this.ad = AggregateNode.resolveAggregate(this.getDataDictionary(), schemaDescriptor, this.methodName, bl);
        }
    }

    private void coerceMethodParameter(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list, RoutineAliasInfo routineAliasInfo, int n2, DataTypeDescriptor dataTypeDescriptor, TypeId typeId, int n3, int n4) throws StandardException {
        Object object;
        ValueNode valueNode = null;
        if (this.methodParms[n4] instanceof SQLToJavaValueNode) {
            SQLToJavaValueNode sQLToJavaValueNode = (SQLToJavaValueNode)this.methodParms[n4];
            valueNode = sQLToJavaValueNode.getSQLValueNode();
        }
        boolean bl = true;
        if (valueNode == null || !valueNode.requiresTypeFromContext()) {
            if (n3 != 1) {
                throw StandardException.newException("42886", RoutineAliasInfo.parameterMode(n3), routineAliasInfo.getParameterNames()[n4]);
            }
            bl = false;
        } else {
            if (this.applicationParameterNumbers == null) {
                this.applicationParameterNumbers = new int[n2];
            }
            if (valueNode instanceof UnaryOperatorNode) {
                ParameterNode parameterNode = ((UnaryOperatorNode)valueNode).getParameterOperand();
                this.applicationParameterNumbers[n4] = parameterNode.getParameterNumber();
            } else {
                this.applicationParameterNumbers[n4] = ((ParameterNode)valueNode).getParameterNumber();
            }
        }
        boolean bl2 = false;
        if (!bl) {
            if (valueNode instanceof UntypedNullConstantNode) {
                valueNode.setType(dataTypeDescriptor);
            } else {
                TypeId typeId2;
                if (valueNode != null) {
                    typeId2 = valueNode.getTypeId();
                    object = valueNode.getTypeServices();
                } else {
                    object = DataTypeDescriptor.getSQLDataTypeDescriptor(this.methodParms[n4].getJavaTypeName());
                    if (object == null) {
                        throw StandardException.newException("X0X57.S", this.methodParms[n4].getJavaTypeName());
                    }
                    typeId2 = ((DataTypeDescriptor)object).getTypeId();
                }
                if (!this.getTypeCompiler(typeId).storable(typeId2, this.getClassFactory())) {
                    throw StandardException.newException("42821", typeId.getSQLTypeName(), typeId2.getSQLTypeName());
                }
                if (!dataTypeDescriptor.isExactTypeAndLengthMatch((DataTypeDescriptor)object)) {
                    bl2 = true;
                }
            }
        } else if (typeId.variableLength() && n3 != 4) {
            bl2 = true;
        }
        if (bl2) {
            if (valueNode == null) {
                valueNode = new JavaToSQLValueNode(this.methodParms[n4], this.getContextManager());
            }
            object = StaticMethodCallNode.makeCast(valueNode, dataTypeDescriptor, this.getContextManager());
            this.methodParms[n4] = new SQLToJavaValueNode((ValueNode)object, this.getContextManager());
            this.methodParms[n4] = this.methodParms[n4].bindExpression(fromList, subqueryList, list);
        }
        if (bl) {
            valueNode.setType(dataTypeDescriptor);
        }
    }

    public static ValueNode makeCast(ValueNode valueNode, DataTypeDescriptor dataTypeDescriptor, ContextManager contextManager) throws StandardException {
        CastNode castNode = new CastNode(valueNode, dataTypeDescriptor, contextManager);
        castNode.setAssignmentSemantics();
        return castNode;
    }

    private void generatePushNestedSessionContext(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, boolean bl, String string) throws StandardException {
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(bl);
        methodBuilder.push(string);
        methodBuilder.callMethod((short)185, null, "pushNestedSessionContext", "void", 3);
    }

    @Override
    void generateOneParameter(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, int n2) throws StandardException {
        Object object;
        Object object2;
        int n3;
        SQLToJavaValueNode sQLToJavaValueNode = null;
        if (this.methodParms[n2] instanceof SQLToJavaValueNode) {
            sQLToJavaValueNode = (SQLToJavaValueNode)this.methodParms[n2];
        }
        if (this.routineInfo != null) {
            n3 = this.routineInfo.getParameterModes()[this.getRoutineArgIdx(n2)];
        } else {
            n3 = 1;
            if (sQLToJavaValueNode != null && sQLToJavaValueNode.getSQLValueNode().requiresTypeFromContext()) {
                object2 = sQLToJavaValueNode.getSQLValueNode() instanceof UnaryOperatorNode ? ((UnaryOperatorNode)sQLToJavaValueNode.getSQLValueNode()).getParameterOperand() : (ParameterNode)sQLToJavaValueNode.getSQLValueNode();
                int n4 = ((ParameterNode)object2).getParameterNumber();
                object = this.methodParameterTypes[this.getRoutineArgIdx(n2)];
                if (((String)object).endsWith("[]")) {
                    MethodBuilder methodBuilder2 = expressionClassBuilder.getConstructor();
                    expressionClassBuilder.pushThisAsActivation(methodBuilder2);
                    methodBuilder2.callMethod((short)185, null, "getParameterValueSet", "org.apache.derby.iapi.sql.ParameterValueSet", 0);
                    methodBuilder2.push(n4);
                    methodBuilder2.push(0);
                    methodBuilder2.callMethod((short)185, null, "setParameterMode", "void", 2);
                    methodBuilder2.endStatement();
                }
            }
        }
        switch (n3) {
            case 0: 
            case 1: 
            case 2: {
                if (sQLToJavaValueNode != null) {
                    sQLToJavaValueNode.returnsNullOnNullState = this.returnsNullOnNullState;
                }
                super.generateOneParameter(expressionClassBuilder, methodBuilder, n2);
                break;
            }
        }
        switch (n3) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                object2 = this.methodParameterTypes[this.getRoutineArgIdx(n2)];
                String string = ((String)object2).substring(0, ((String)object2).length() - 2);
                if (this.isVararg(n2)) {
                    object2 = this.stripOneArrayLevel((String)object2);
                    string = this.stripOneArrayLevel(string);
                }
                object = expressionClassBuilder.newFieldDeclaration(2, (String)object2);
                if (this.outParamArrays == null) {
                    this.outParamArrays = new LocalField[this.methodParms.length];
                }
                this.outParamArrays[n2] = object;
                methodBuilder.pushNewArray(string, 1);
                methodBuilder.putField((LocalField)object);
                if (n3 == 4) break;
                methodBuilder.swap();
                methodBuilder.setArrayElement(0);
                methodBuilder.getField((LocalField)object);
                break;
            }
        }
    }

    @Override
    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        if (bl) {
            return false;
        }
        boolean bl2 = true;
        bl2 = bl2 && super.categorize(jBitSet, bl);
        return bl2;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n2;
        Object object;
        int n3;
        int n4;
        if (this.routineInfo != null && !this.routineInfo.calledOnNullInput() && this.routineInfo.getParameterCount() != 0) {
            this.returnsNullOnNullState = expressionClassBuilder.newFieldDeclaration(2, "boolean");
        }
        if (this.returnsNullOnNullState != null) {
            methodBuilder.push(false);
            methodBuilder.setField(this.returnsNullOnNullState);
            methodBuilder.pushThis();
        }
        int n5 = this.generateParameters(expressionClassBuilder, methodBuilder);
        LocalField localField = null;
        if (this.routineInfo != null) {
            boolean bl;
            n4 = this.routineInfo.getSQLAllowed();
            if (n4 != 3) {
                n3 = n4 == 1 ? 1 : (n4 == 0 ? 0 : 2);
                this.generateAuthorizeCheck((ActivationClassBuilder)expressionClassBuilder, methodBuilder, n3);
            }
            n3 = this.isSystemCode ? 2 : 1;
            boolean bl2 = bl = this.routineInfo.getReturnType() != null;
            if (bl) {
                ++n3;
            }
            if (n3 != 0) {
                expressionClassBuilder.pushThisAsActivation(methodBuilder);
                methodBuilder.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
                methodBuilder.callMethod((short)185, null, "getStatementContext", "org.apache.derby.iapi.sql.conn.StatementContext", 0);
                for (int i2 = 1; i2 < n3; ++i2) {
                    methodBuilder.dup();
                }
            }
            if (this.isSystemCode) {
                methodBuilder.callMethod((short)185, null, "setSystemCode", "void", 0);
            }
            if (n4 != 3) {
                this.generatePushNestedSessionContext((ActivationClassBuilder)expressionClassBuilder, methodBuilder, this.routineInfo.hasDefinersRights(), this.routineDefiner);
            }
            if (bl) {
                localField = expressionClassBuilder.newFieldDeclaration(2, "short");
                methodBuilder.callMethod((short)185, null, "getSQLAllowed", "short", 0);
                methodBuilder.setField(localField);
            }
            methodBuilder.push((short)n4);
            methodBuilder.push(false);
            methodBuilder.callMethod((short)185, null, "setSQLAllowed", "void", 2);
        }
        if (this.routineInfo != null && !this.hasVarargs() && (n4 = this.methodParameterTypes.length - this.methodParms.length) != 0) {
            n3 = this.routineInfo.getMaxDynamicResultSets();
            if (n3 > 0) {
                MethodBuilder methodBuilder2 = expressionClassBuilder.getClassBuilder().newMethodBuilder(1, "int", "getMaxDynamicResults");
                methodBuilder2.push(n3);
                methodBuilder2.methodReturn();
                methodBuilder2.complete();
            }
            MethodBuilder methodBuilder3 = expressionClassBuilder.getClassBuilder().newMethodBuilder(1, "java.sql.ResultSet[][]", "getDynamicResults");
            MethodBuilder methodBuilder4 = expressionClassBuilder.getConstructor();
            object = expressionClassBuilder.newFieldDeclaration(2, "java.sql.ResultSet[][]");
            methodBuilder3.getField((LocalField)object);
            methodBuilder4.pushNewArray("java.sql.ResultSet[]", n4);
            methodBuilder4.setField((LocalField)object);
            for (n2 = 0; n2 < n4; ++n2) {
                methodBuilder.pushNewArray("java.sql.ResultSet", 1);
                methodBuilder.dup();
                methodBuilder.getField((LocalField)object);
                methodBuilder.swap();
                methodBuilder.setArrayElement(n2);
            }
            methodBuilder3.methodReturn();
            methodBuilder3.complete();
            n5 += n4;
        }
        String string = this.getJavaTypeName();
        MethodBuilder methodBuilder5 = null;
        MethodBuilder methodBuilder6 = methodBuilder;
        if (this.returnsNullOnNullState != null) {
            int n6;
            methodBuilder5 = expressionClassBuilder.newGeneratedFun(string, 2, this.methodParameterTypes);
            Class<?>[] classArray = ((Method)this.method).getExceptionTypes();
            for (n6 = 0; n6 < classArray.length; ++n6) {
                methodBuilder5.addThrownException(classArray[n6].getName());
            }
            methodBuilder5.getField(this.returnsNullOnNullState);
            methodBuilder5.conditionalIf();
            methodBuilder5.pushNull(string);
            methodBuilder5.startElseCode();
            if (!this.actualMethodReturnType.equals(string)) {
                methodBuilder5.pushNewStart(string);
            }
            for (n6 = 0; n6 < n5; ++n6) {
                methodBuilder5.getParameter(n6);
            }
            methodBuilder6 = methodBuilder5;
        }
        methodBuilder6.callMethod((short)184, this.method.getDeclaringClass().getName(), this.methodName, this.actualMethodReturnType, n5);
        if (this.returnsNullOnNullState != null) {
            if (!this.actualMethodReturnType.equals(string)) {
                if (this.actualMethodReturnType.equals("short") && string.equals("java.lang.Integer")) {
                    methodBuilder5.upCast("int");
                }
                methodBuilder5.pushNewComplete(1);
            }
            methodBuilder5.completeConditional();
            methodBuilder5.methodReturn();
            methodBuilder5.complete();
            methodBuilder.callMethod((short)182, expressionClassBuilder.getClassBuilder().getFullName(), methodBuilder5.getName(), string, n5);
            methodBuilder5 = null;
        }
        if (this.routineInfo != null) {
            if (localField != null) {
                expressionClassBuilder.pushThisAsActivation(methodBuilder);
                methodBuilder.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
                methodBuilder.callMethod((short)185, null, "getStatementContext", "org.apache.derby.iapi.sql.conn.StatementContext", 0);
                methodBuilder.getField(localField);
                methodBuilder.push(true);
                methodBuilder.callMethod((short)185, null, "setSQLAllowed", "void", 2);
            }
            if (this.outParamArrays != null) {
                MethodBuilder methodBuilder7 = expressionClassBuilder.getConstructor();
                expressionClassBuilder.pushThisAsActivation(methodBuilder7);
                methodBuilder7.callMethod((short)185, null, "getParameterValueSet", "org.apache.derby.iapi.sql.ParameterValueSet", 0);
                expressionClassBuilder.pushThisAsActivation(methodBuilder);
                methodBuilder.callMethod((short)185, null, "getParameterValueSet", "org.apache.derby.iapi.sql.ParameterValueSet", 0);
                object = this.routineInfo.getParameterModes();
                for (n2 = 0; n2 < this.outParamArrays.length; ++n2) {
                    Object object2 = object[this.getRoutineArgIdx(n2)];
                    if (object2 == true) continue;
                    ValueNode valueNode = ((SQLToJavaValueNode)this.methodParms[n2]).getSQLValueNode();
                    int n7 = this.applicationParameterNumbers[n2];
                    methodBuilder7.dup();
                    methodBuilder7.push(n7);
                    methodBuilder7.push((int)object2);
                    methodBuilder7.callMethod((short)185, null, "setParameterMode", "void", 2);
                    LocalField localField2 = this.outParamArrays[n2];
                    methodBuilder.dup();
                    methodBuilder.push(n7);
                    methodBuilder.callMethod((short)185, null, "getParameter", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
                    DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices();
                    boolean bl = dataTypeDescriptor.getTypeId().isNumericTypeId();
                    boolean bl3 = dataTypeDescriptor.getTypeId().getBaseTypeId().isAnsiUDT();
                    Class<?> clazz = ((Method)this.method).getParameterTypes()[this.getRoutineArgIdx(n2)].getComponentType();
                    if (this.isVararg(n2)) {
                        clazz = clazz.getComponentType();
                    }
                    boolean bl4 = clazz.isPrimitive();
                    if (bl) {
                        if (!bl4) {
                            methodBuilder.cast("org.apache.derby.iapi.types.NumberDataValue");
                        }
                    } else if (dataTypeDescriptor.getTypeId().isBooleanTypeId() && !bl4) {
                        methodBuilder.cast("org.apache.derby.iapi.types.BooleanDataValue");
                    }
                    if (dataTypeDescriptor.getTypeId().variableLength()) {
                        methodBuilder.dup();
                    }
                    methodBuilder.getField(localField2);
                    methodBuilder.getArrayElement(0);
                    if (bl && !bl4) {
                        methodBuilder.upCast("java.lang.Number");
                    }
                    if (bl3) {
                        methodBuilder.upCast("java.lang.Object");
                    }
                    methodBuilder.callMethod((short)185, null, "setValue", "void", 1);
                    if (!dataTypeDescriptor.getTypeId().variableLength()) continue;
                    methodBuilder.push(bl ? dataTypeDescriptor.getPrecision() : dataTypeDescriptor.getMaximumWidth());
                    methodBuilder.push(dataTypeDescriptor.getScale());
                    methodBuilder.push(bl);
                    methodBuilder.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
                }
                methodBuilder7.endStatement();
                methodBuilder.endStatement();
            }
        }
    }

    int getPrivType() {
        return 6;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.procedureName != null) {
            this.procedureName = (TableName)this.procedureName.accept(visitor);
        }
    }
}

