/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.transaction.TransactionControl;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.NewInvocationNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.vti.DeferModification;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;

class FromVTI
extends FromTable
implements VTIEnvironment {
    JBitSet correlationMap;
    JBitSet dependencyMap;
    MethodCallNode methodCall;
    TableName exposedName;
    SubqueryList subqueryList;
    boolean implementsVTICosting;
    boolean optimized;
    boolean materializable;
    boolean isTarget;
    boolean isDerbyStyleTableFunction;
    boolean isRestrictedTableFunction;
    ResultSet rs;
    private final FormatableHashtable compileTimeConstants = new FormatableHashtable();
    protected int numVTICols;
    private PredicateList restrictionList;
    double estimatedCost = 100000.0;
    double estimatedRowCount = 10000.0;
    boolean supportsMultipleInstantiations = true;
    boolean vtiCosted;
    protected boolean version2;
    private boolean implementsPushable;
    private PreparedStatement ps;
    private JavaValueNode[] methodParms;
    private boolean controlsDeferral;
    private int resultSetType = 1003;
    private String[] projectedColumnNames;
    private Restriction vtiRestriction;
    private ArrayList<FromList> outerFromLists = new ArrayList();
    private HashMap<Integer, FromTable> argSources = new HashMap();

    FromVTI(MethodCallNode methodCallNode, String string, ResultColumnList resultColumnList, Properties properties, ContextManager contextManager) throws StandardException {
        super(string, properties, contextManager);
        this.constructorMinion(methodCallNode, resultColumnList, this.makeTableName(null, string));
    }

    FromVTI(MethodCallNode methodCallNode, String string, ResultColumnList resultColumnList, Properties properties, TableName tableName, ContextManager contextManager) {
        super(string, properties, contextManager);
        this.constructorMinion(methodCallNode, resultColumnList, tableName);
    }

    private void constructorMinion(MethodCallNode methodCallNode, ResultColumnList resultColumnList, TableName tableName) {
        this.methodCall = methodCallNode;
        this.setResultColumns(resultColumnList);
        this.subqueryList = new SubqueryList(this.getContextManager());
        this.exposedName = tableName;
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        this.setCostEstimate(this.getCostEstimate(optimizer));
        if (this.implementsVTICosting && !this.vtiCosted) {
            try {
                VTICosting vTICosting = this.getVTICosting();
                this.estimatedCost = vTICosting.getEstimatedCostPerInstantiation(this);
                this.estimatedRowCount = vTICosting.getEstimatedRowCount(this);
                this.supportsMultipleInstantiations = vTICosting.supportsMultipleInstantiations(this);
                if (this.ps != null) {
                    this.ps.close();
                    this.ps = null;
                }
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
            }
            catch (SQLException sQLException) {
                throw StandardException.unexpectedUserException(sQLException);
            }
            this.vtiCosted = true;
        }
        this.getCostEstimate().setCost(this.estimatedCost, this.estimatedRowCount, this.estimatedRowCount);
        if (this.getCurrentAccessPath().getJoinStrategy().multiplyBaseCostByOuterRows()) {
            this.getCostEstimate().multiply(costEstimate.rowCount(), this.getCostEstimate());
        }
        if (!this.optimized) {
            this.subqueryList.optimize(optimizer.getDataDictionary(), this.getCostEstimate().rowCount());
            this.subqueryList.modifyAccessPaths();
        }
        this.optimized = true;
        return this.getCostEstimate();
    }

    @Override
    public boolean legalJoinOrder(JBitSet jBitSet) {
        JBitSet jBitSet2 = jBitSet;
        jBitSet2.or(this.correlationMap);
        return jBitSet2.contains(this.dependencyMap);
    }

    @Override
    public boolean isMaterializable() {
        return this.materializable;
    }

    @Override
    public boolean supportsMultipleInstantiations() {
        return this.supportsMultipleInstantiations;
    }

    public boolean isDerbyStyleTableFunction() {
        return this.isDerbyStyleTableFunction;
    }

    @Override
    void adjustForSortElimination() {
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        if (this.rs != null) {
            try {
                this.rs.close();
                this.rs = null;
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        return super.modifyAccessPath(jBitSet);
    }

    public void addOuterFromList(FromList fromList) {
        this.outerFromLists.add(fromList);
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        if (!this.implementsPushable) {
            return false;
        }
        if (!optimizablePredicate.getReferencedMap().hasSingleBitSet()) {
            return false;
        }
        if (this.restrictionList == null) {
            this.restrictionList = new PredicateList(this.getContextManager());
        }
        this.restrictionList.addPredicate((Predicate)optimizablePredicate);
        return true;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n2) {
    }

    boolean isConstructor() {
        return this.methodCall instanceof NewInvocationNode;
    }

    final MethodCallNode getMethodCall() {
        return this.methodCall;
    }

    @Override
    String getExposedName() {
        return this.correlationName;
    }

    public TableName getExposedTableName() {
        return this.exposedName;
    }

    void setTarget() {
        this.isTarget = true;
        this.version2 = true;
    }

    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    String getVTIName() {
        return this.methodCall.getJavaClassName();
    }

    @Override
    ResultSetNode bindVTITables(FromList fromList) throws StandardException {
        Object object;
        ResultColumnList resultColumnList = this.getResultColumns();
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext();
        ArrayList<AggregateNode> arrayList = new ArrayList<AggregateNode>();
        this.methodCall.bindExpression(fromList, this.subqueryList, arrayList);
        this.methodParms = this.methodCall.getMethodParms();
        RoutineAliasInfo routineAliasInfo = this.methodCall.getRoutineInfo();
        if (routineAliasInfo != null && routineAliasInfo.getReturnType().isRowMultiSet() && routineAliasInfo.getParameterStyle() == 1) {
            this.isDerbyStyleTableFunction = true;
        }
        if (this.isDerbyStyleTableFunction) {
            object = (Method)this.methodCall.getResolvedMethod();
            this.isRestrictedTableFunction = RestrictedVTI.class.isAssignableFrom(((Method)object).getReturnType());
        }
        if (this.isConstructor()) {
            object = (NewInvocationNode)this.methodCall;
            if (!((NewInvocationNode)object).assignableTo("java.sql.PreparedStatement")) {
                if (this.version2) {
                    throw StandardException.newException("42X08", this.getVTIName(), "java.sql.PreparedStatement");
                }
                if (!((NewInvocationNode)object).assignableTo("java.sql.ResultSet")) {
                    throw StandardException.newException("42X08", this.getVTIName(), "java.sql.ResultSet");
                }
            } else {
                this.version2 = true;
            }
            if (this.version2) {
                this.implementsPushable = ((NewInvocationNode)object).assignableTo("org.apache.derby.vti.IQualifyable");
            }
            this.implementsVTICosting = ((NewInvocationNode)object).assignableTo("org.apache.derby.vti.VTICosting");
        }
        if (this.isDerbyStyleTableFunction) {
            this.implementsVTICosting = this.implementsDerbyStyleVTICosting(this.methodCall.getJavaClassName());
        }
        if (this.isConstructor() && (object = this.getSpecialTriggerVTITableName(languageConnectionContext, this.methodCall.getJavaClassName())) != null) {
            TableDescriptor tableDescriptor = this.getDataDictionary().getTableDescriptor((UUID)object);
            this.setResultColumns(this.genResultColList(tableDescriptor));
            this.vtiCosted = true;
            this.estimatedCost = 50.0;
            this.estimatedRowCount = 5.0;
            this.supportsMultipleInstantiations = true;
        } else {
            this.setResultColumns(new ResultColumnList(this.getContextManager()));
            if (this.isDerbyStyleTableFunction) {
                this.createResultColumnsForTableFunction(routineAliasInfo.getReturnType());
            } else {
                ResultSetMetaData resultSetMetaData = this.getResultSetMetaData();
                if (resultSetMetaData == null) {
                    throw StandardException.newException("42X43", this.getVTIName());
                }
                try {
                    this.numVTICols = resultSetMetaData.getColumnCount();
                }
                catch (SQLException sQLException) {
                    this.numVTICols = 0;
                }
                this.getResultColumns().createListFromResultSetMetaData(resultSetMetaData, this.exposedName, this.getVTIName());
            }
        }
        this.numVTICols = this.getResultColumns().size();
        if (resultColumnList != null) {
            this.getResultColumns().propagateDCLInfo(resultColumnList, this.correlationName);
        }
        return this;
    }

    ResultSetMetaData getResultSetMetaData() throws StandardException {
        ResultSetMetaData resultSetMetaData;
        block10: {
            resultSetMetaData = null;
            try {
                if (this.version2) {
                    this.ps = (PreparedStatement)this.getNewInstance();
                    if (this.ps.getResultSetConcurrency() != 1008) {
                        throw StandardException.newException("42Z90", this.getVTIName());
                    }
                    resultSetMetaData = this.ps.getMetaData();
                    this.controlsDeferral = this.ps instanceof DeferModification;
                    try {
                        this.resultSetType = this.ps.getResultSetType();
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (AbstractMethodError abstractMethodError) {
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    if (!this.implementsVTICosting) {
                        this.ps.close();
                        this.ps = null;
                    }
                    break block10;
                }
                this.rs = (ResultSet)this.getNewInstance();
                resultSetMetaData = this.rs.getMetaData();
                if (!this.implementsVTICosting) {
                    this.rs.close();
                    this.rs = null;
                }
            }
            catch (Throwable throwable) {
                throw StandardException.unexpectedUserException(throwable);
            }
        }
        return resultSetMetaData;
    }

    private Object getNewInstance() throws StandardException {
        Object object;
        Object[] objectArray;
        NewInvocationNode newInvocationNode = (NewInvocationNode)this.methodCall;
        Class<?>[] classArray = newInvocationNode.getMethodParameterClasses();
        if (classArray != null) {
            objectArray = new Object[classArray.length];
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                object = classArray[i2];
                objectArray[i2] = this.methodParms[i2].getConstantValueAsObject();
                if (objectArray[i2] != null && ((Class)object).isPrimitive()) {
                    if (object.equals(Short.TYPE)) {
                        objectArray[i2] = ((Integer)objectArray[i2]).shortValue();
                    } else if (object.equals(Byte.TYPE)) {
                        objectArray[i2] = ((Integer)objectArray[i2]).byteValue();
                    }
                }
                if (objectArray[i2] != null || !((Class)object).isPrimitive()) continue;
                if (object.equals(Integer.TYPE)) {
                    objectArray[i2] = 0;
                    continue;
                }
                if (object.equals(Short.TYPE)) {
                    objectArray[i2] = (short)0;
                    continue;
                }
                if (object.equals(Byte.TYPE)) {
                    objectArray[i2] = (byte)0;
                    continue;
                }
                if (object.equals(Long.TYPE)) {
                    objectArray[i2] = 0L;
                    continue;
                }
                if (object.equals(Float.TYPE)) {
                    objectArray[i2] = Float.valueOf(0.0f);
                    continue;
                }
                if (object.equals(Double.TYPE)) {
                    objectArray[i2] = 0.0;
                    continue;
                }
                if (object.equals(Boolean.TYPE)) {
                    objectArray[i2] = Boolean.FALSE;
                    continue;
                }
                if (!object.equals(Character.TYPE)) continue;
                objectArray[i2] = Character.valueOf('\u0000');
            }
        } else {
            classArray = new Class[]{};
            objectArray = new Object[]{};
        }
        try {
            ClassInspector classInspector = this.getClassFactory().getClassInspector();
            object = this.methodCall.getJavaClassName();
            Constructor<?> constructor = classInspector.getClass((String)object).getConstructor(classArray);
            return constructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    public DeferModification getDeferralControl() throws StandardException {
        if (!this.controlsDeferral) {
            return null;
        }
        try {
            return (DeferModification)this.getNewInstance();
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    @Override
    void bindExpressions(FromList fromList) throws StandardException {
        this.materializable = this.methodCall.areParametersQueryInvariant();
        ArrayList arrayList = null;
        for (ColumnReference columnReference : this.getNodesFromParameters(ColumnReference.class)) {
            boolean bl;
            boolean bl2 = bl = !columnReference.getCorrelated();
            if (columnReference.getCorrelated()) {
                for (int i2 = 0; i2 < this.outerFromLists.size(); ++i2) {
                    FromTable fromTable = this.columnInFromList(this.outerFromLists.get(i2), columnReference);
                    if (fromTable == null) continue;
                    bl = true;
                    break;
                }
            } else {
                FromTable fromTable = this.columnInFromList(fromList, columnReference);
                if (fromTable != null && !this.isDerbyStyleTableFunction && !(fromTable instanceof FromVTI)) break;
            }
            if (bl) {
                throw StandardException.newException("42ZB7", columnReference.getSQLColumnName());
            }
            if (columnReference.getTableNumber() != -1) continue;
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            columnReference.bindExpression(fromList, this.subqueryList, (List)arrayList);
        }
    }

    private FromTable columnInFromList(FromList fromList, ColumnReference columnReference) throws StandardException {
        int n2 = columnReference.getTableNumber();
        for (int i2 = 0; i2 < fromList.size(); ++i2) {
            FromTable fromTable = (FromTable)fromList.elementAt(i2);
            if (n2 != fromTable.getTableNumber()) continue;
            this.argSources.put(fromTable.getTableNumber(), fromTable);
            return fromTable;
        }
        return null;
    }

    <T extends Visitable> List<T> getNodesFromParameters(Class<T> clazz) throws StandardException {
        CollectNodesVisitor<T> collectNodesVisitor = new CollectNodesVisitor<T>(clazz);
        this.methodCall.accept(collectNodesVisitor);
        return collectNodesVisitor.getList();
    }

    @Override
    ResultColumnList getAllResultColumns(TableName tableName) throws StandardException {
        TableName tableName2 = tableName != null ? this.makeTableName(tableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName);
        if (tableName != null && !tableName.equals(tableName2)) {
            return null;
        }
        ContextManager contextManager = this.getContextManager();
        ResultColumnList resultColumnList = new ResultColumnList(contextManager);
        for (ResultColumn resultColumn : this.getResultColumns()) {
            if (resultColumn.isGenerated()) continue;
            ResultColumn resultColumn2 = new ResultColumn(resultColumn.getName(), (ValueNode)new ColumnReference(resultColumn.getName(), this.exposedName, contextManager), contextManager);
            resultColumnList.addResultColumn(resultColumn2);
        }
        return resultColumnList;
    }

    @Override
    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        if (this.getResultColumns() == null) {
            return null;
        }
        ResultColumn resultColumn = null;
        TableName tableName = columnReference.getQualifiedTableName();
        if ((tableName == null || tableName.equals(this.exposedName)) && (resultColumn = this.getResultColumns().getResultColumn(columnReference.getColumnName())) != null) {
            columnReference.setTableNumber(this.tableNumber);
            columnReference.setColumnNumber(resultColumn.getColumnPosition());
        }
        return resultColumn;
    }

    @Override
    ResultSetNode preprocess(int n2, GroupByList groupByList, FromList fromList) throws StandardException {
        this.methodCall.preprocess(n2, new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()), new SubqueryList(this.getContextManager()), new PredicateList(this.getContextManager()));
        this.setReferencedTableMap(new JBitSet(n2));
        this.getReferencedTableMap().set(this.tableNumber);
        this.dependencyMap = new JBitSet(n2);
        this.methodCall.categorize(this.dependencyMap, false);
        this.dependencyMap.clear(this.tableNumber);
        this.correlationMap = new JBitSet(n2);
        this.methodCall.getCorrelationTables(this.correlationMap);
        return this.genProjectRestrict(n2);
    }

    @Override
    protected ResultSetNode genProjectRestrict(int n2) throws StandardException {
        ResultColumnList resultColumnList = this.getResultColumns();
        this.setResultColumns(this.getResultColumns().copyListAndObjects());
        resultColumnList.genVirtualColumnNodes(this, this.getResultColumns(), false);
        resultColumnList.doProjection();
        return new ProjectRestrictNode(this, resultColumnList, null, null, null, null, this.tableProperties, this.getContextManager());
    }

    @Override
    boolean performMaterialization(JBitSet jBitSet) throws StandardException {
        return jBitSet.getFirstSetBit() != -1 && !jBitSet.hasSingleBitSet() && !this.getTrulyTheBestAccessPath().getJoinStrategy().doesMaterialization() && this.isMaterializable() && !this.supportsMultipleInstantiations;
    }

    void computeProjectionAndRestriction(PredicateList predicateList) throws StandardException {
        if (!this.isRestrictedTableFunction) {
            return;
        }
        this.computeRestriction(predicateList, this.computeProjection());
    }

    private HashMap<String, String> computeProjection() throws StandardException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ResultColumnList resultColumnList = this.getResultColumns();
        int n2 = resultColumnList.size();
        this.projectedColumnNames = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            ResultColumn resultColumn = resultColumnList.getResultColumn(i2 + 1);
            String string2 = resultColumn.getName();
            if (!resultColumn.isReferenced()) continue;
            this.projectedColumnNames[i2] = string = resultColumn.getBaseColumnNode().getColumnName();
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    private void computeRestriction(PredicateList predicateList, HashMap<String, String> hashMap) throws StandardException {
        if (predicateList == null) {
            return;
        }
        for (Predicate predicate : predicateList) {
            if (!this.canBePushedDown(predicate)) continue;
            Restriction restriction = this.makeRestriction(predicate.getAndNode(), hashMap);
            if (restriction == null) {
                this.vtiRestriction = null;
                return;
            }
            if (this.vtiRestriction == null) {
                this.vtiRestriction = restriction;
                continue;
            }
            this.vtiRestriction = new Restriction.AND(this.vtiRestriction, restriction);
        }
    }

    private boolean canBePushedDown(Predicate predicate) throws StandardException {
        JBitSet jBitSet = predicate.getReferencedSet();
        return predicate.isQualifier() && jBitSet != null && jBitSet.hasSingleBitSet() && jBitSet.get(this.getTableNumber());
    }

    private Restriction makeRestriction(ValueNode valueNode, HashMap<String, String> hashMap) throws StandardException {
        if (valueNode instanceof AndNode) {
            AndNode andNode = (AndNode)valueNode;
            if (andNode.getRightOperand().isBooleanTrue()) {
                return this.makeRestriction(andNode.getLeftOperand(), hashMap);
            }
            Restriction restriction = this.makeRestriction(andNode.getLeftOperand(), hashMap);
            Restriction restriction2 = this.makeRestriction(andNode.getRightOperand(), hashMap);
            if (restriction == null || restriction2 == null) {
                return null;
            }
            return new Restriction.AND(restriction, restriction2);
        }
        if (valueNode instanceof OrNode) {
            OrNode orNode = (OrNode)valueNode;
            if (orNode.getRightOperand().isBooleanFalse()) {
                return this.makeRestriction(orNode.getLeftOperand(), hashMap);
            }
            Restriction restriction = this.makeRestriction(orNode.getLeftOperand(), hashMap);
            Restriction restriction3 = this.makeRestriction(orNode.getRightOperand(), hashMap);
            if (restriction == null || restriction3 == null) {
                return null;
            }
            return new Restriction.OR(restriction, restriction3);
        }
        if (valueNode instanceof BinaryRelationalOperatorNode) {
            return this.makeLeafRestriction((BinaryRelationalOperatorNode)valueNode, hashMap);
        }
        if (valueNode instanceof IsNullNode) {
            return this.makeIsNullRestriction((IsNullNode)valueNode, hashMap);
        }
        return this.iAmConfused(valueNode);
    }

    private Restriction makeLeafRestriction(BinaryRelationalOperatorNode binaryRelationalOperatorNode, HashMap<String, String> hashMap) throws StandardException {
        ValueNode valueNode;
        ColumnReference columnReference;
        int n2 = binaryRelationalOperatorNode.getOperator();
        if (binaryRelationalOperatorNode.getLeftOperand() instanceof ColumnReference) {
            columnReference = (ColumnReference)binaryRelationalOperatorNode.getLeftOperand();
            valueNode = binaryRelationalOperatorNode.getRightOperand();
        } else if (binaryRelationalOperatorNode.getRightOperand() instanceof ColumnReference) {
            columnReference = (ColumnReference)binaryRelationalOperatorNode.getRightOperand();
            valueNode = binaryRelationalOperatorNode.getLeftOperand();
            n2 = this.flipOperator(n2);
        } else {
            return this.iAmConfused(binaryRelationalOperatorNode);
        }
        int n3 = this.mapOperator(n2);
        if (n3 < 0) {
            return this.iAmConfused(binaryRelationalOperatorNode);
        }
        String string = hashMap.get(columnReference.getColumnName());
        Object object = this.squeezeConstantValue(valueNode);
        if (string == null || object == null) {
            return this.iAmConfused(binaryRelationalOperatorNode);
        }
        return new Restriction.ColumnQualifier(string, n3, object);
    }

    private Restriction makeIsNullRestriction(IsNullNode isNullNode, HashMap<String, String> hashMap) throws StandardException {
        ColumnReference columnReference = (ColumnReference)isNullNode.getOperand();
        int n2 = this.mapOperator(isNullNode.getOperator());
        if (n2 < 0) {
            return this.iAmConfused(isNullNode);
        }
        if (n2 != 5 && n2 != 6) {
            return this.iAmConfused(isNullNode);
        }
        String string = hashMap.get(columnReference.getColumnName());
        if (string == null) {
            return this.iAmConfused(isNullNode);
        }
        return new Restriction.ColumnQualifier(string, n2, null);
    }

    private Restriction iAmConfused(ValueNode valueNode) throws StandardException {
        return null;
    }

    private int flipOperator(int n2) throws StandardException {
        switch (n2) {
            case 1: {
                return 1;
            }
            case 4: {
                return 6;
            }
            case 3: {
                return 5;
            }
            case 6: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case 2: {
                return 2;
            }
        }
        return -1;
    }

    private int mapOperator(int n2) throws StandardException {
        switch (n2) {
            case 1: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 6: {
                return 2;
            }
            case 5: {
                return 0;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 2: {
                return 7;
            }
        }
        return -1;
    }

    private Object squeezeConstantValue(ValueNode valueNode) throws StandardException {
        if (valueNode instanceof ParameterNode) {
            return new int[]{((ParameterNode)valueNode).getParameterNumber()};
        }
        if (valueNode instanceof ConstantNode) {
            return ((ConstantNode)valueNode).getValue().getObject();
        }
        return this.iAmConfused(valueNode);
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        if (this.isRestrictedTableFunction && this.projectedColumnNames == null) {
            this.computeProjection();
        }
        RemapCRsVisitor remapCRsVisitor = new RemapCRsVisitor(true);
        this.methodCall.accept(remapCRsVisitor);
        this.remapBaseTableColumns();
        this.assignResultSetNumber();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        int n2 = this.getScanArguments(activationClassBuilder, methodBuilder);
        methodBuilder.callMethod((short)185, null, "getVTIResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", n2);
    }

    private void remapBaseTableColumns() throws StandardException {
        for (ColumnReference columnReference : this.getNodesFromParameters(ColumnReference.class)) {
            ResultColumn resultColumn;
            ResultColumnList resultColumnList;
            FromTable fromTable = this.argSources.get(columnReference.getTableNumber());
            if (fromTable == null || (resultColumnList = fromTable.getResultColumns()) == null || (resultColumn = resultColumnList.getResultColumn(columnReference.getColumnName())) == null) continue;
            columnReference.setSource(resultColumn);
        }
    }

    private int getScanArguments(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        int n2;
        int n3 = this.getResultColumns().size();
        FormatableBitSet formatableBitSet = new FormatableBitSet(n3);
        int n4 = -1;
        int n5 = 0;
        this.setCostEstimate(this.getFinalCostEstimate());
        for (n2 = 0; n2 < n3; ++n2) {
            ResultColumn resultColumn = (ResultColumn)this.getResultColumns().elementAt(n2);
            if (!resultColumn.isReferenced()) continue;
            formatableBitSet.set(n2);
            ++n5;
        }
        if (n5 != this.numVTICols) {
            n4 = activationClassBuilder.addItem(formatableBitSet);
        }
        n2 = activationClassBuilder.addItem(this.compileTimeConstants);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(activationClassBuilder.addItem(this.getResultColumns().buildRowTemplate()));
        boolean bl = this.version2 && this.getNodesFromParameters(ParameterNode.class).isEmpty() && this.getNodesFromParameters(ColumnReference.class).isEmpty();
        methodBuilder.push(this.getResultSetNumber());
        this.generateConstructor(activationClassBuilder, methodBuilder, bl);
        methodBuilder.push(this.methodCall.getJavaClassName());
        if (this.restrictionList != null) {
            this.restrictionList.generateQualifiers(activationClassBuilder, methodBuilder, this, true);
        } else {
            methodBuilder.pushNull("org.apache.derby.iapi.store.access.Qualifier[][]");
        }
        methodBuilder.push(n4);
        methodBuilder.push(this.version2);
        methodBuilder.push(bl);
        methodBuilder.push(n2);
        methodBuilder.push(this.isTarget);
        methodBuilder.push(this.getCompilerContext().getScanIsolationLevel());
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.push(this.isDerbyStyleTableFunction);
        int n6 = -1;
        if (this.isDerbyStyleTableFunction) {
            n6 = activationClassBuilder.addItem(this.methodCall.getRoutineInfo().getReturnType());
        }
        methodBuilder.push(n6);
        methodBuilder.push(this.storeObjectInPS(activationClassBuilder, this.projectedColumnNames));
        methodBuilder.push(this.storeObjectInPS(activationClassBuilder, this.vtiRestriction));
        TableName tableName = this.methodCall.getFullName();
        methodBuilder.push(tableName == null ? "" : tableName.getSchemaName());
        methodBuilder.push(tableName == null ? "" : tableName.getTableName());
        return 20;
    }

    private int storeObjectInPS(ActivationClassBuilder activationClassBuilder, Object object) throws StandardException {
        if (object == null) {
            return -1;
        }
        return activationClassBuilder.addItem(object);
    }

    private void generateConstructor(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder, boolean bl) throws StandardException {
        LocalField localField;
        String string = this.version2 ? "java.sql.PreparedStatement" : "java.sql.ResultSet";
        MethodBuilder methodBuilder2 = activationClassBuilder.newGeneratedFun(string, 1);
        methodBuilder2.addThrownException("java.lang.Exception");
        LocalField localField2 = localField = bl ? activationClassBuilder.newFieldDeclaration(2, "java.sql.PreparedStatement") : null;
        if (bl) {
            methodBuilder2.getField(localField);
            methodBuilder2.conditionalIfNull();
        }
        this.methodCall.generateExpression(activationClassBuilder, methodBuilder2);
        methodBuilder2.upCast(string);
        if (bl) {
            methodBuilder2.putField(localField);
            methodBuilder2.startElseCode();
            methodBuilder2.getField(localField);
            methodBuilder2.completeConditional();
        }
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        activationClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
        if (bl) {
            MethodBuilder methodBuilder3 = activationClassBuilder.getCloseActivationMethod();
            methodBuilder3.getField(localField);
            methodBuilder3.conditionalIfNull();
            methodBuilder3.push(0);
            methodBuilder3.startElseCode();
            methodBuilder3.getField(localField);
            methodBuilder3.callMethod((short)185, "java.sql.Statement", "close", "void", 0);
            methodBuilder3.push(0);
            methodBuilder3.completeConditional();
            methodBuilder3.endStatement();
        }
    }

    @Override
    boolean referencesTarget(String string, boolean bl) throws StandardException {
        return !bl && string.equals(this.methodCall.getJavaClassName());
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.methodCall != null) {
            this.methodCall = (MethodCallNode)this.methodCall.accept(visitor);
        }
        if (this.exposedName != null) {
            this.exposedName = (TableName)this.exposedName.accept(visitor);
        }
    }

    private UUID getSpecialTriggerVTITableName(LanguageConnectionContext languageConnectionContext, String string) throws StandardException {
        if (string.equals("org.apache.derby.catalog.TriggerNewTransitionRows") || string.equals("org.apache.derby.catalog.TriggerOldTransitionRows")) {
            if (languageConnectionContext.getTriggerTable() != null) {
                return languageConnectionContext.getTriggerTable().getUUID();
            }
            if (languageConnectionContext.getTriggerExecutionContext() != null) {
                return languageConnectionContext.getTriggerExecutionContext().getTargetTableId();
            }
            throw StandardException.newException("42Y45", string);
        }
        return null;
    }

    private ResultColumnList genResultColList(TableDescriptor tableDescriptor) throws StandardException {
        ResultColumnList resultColumnList = new ResultColumnList(this.getContextManager());
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        int n2 = columnDescriptorList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i2);
            BaseColumnNode baseColumnNode = new BaseColumnNode(columnDescriptor.getColumnName(), this.exposedName, columnDescriptor.getType(), this.getContextManager());
            ResultColumn resultColumn = new ResultColumn(columnDescriptor, (ValueNode)baseColumnNode, this.getContextManager());
            resultColumnList.addResultColumn(resultColumn);
        }
        return resultColumnList;
    }

    @Override
    boolean needsSpecialRCLBinding() {
        return true;
    }

    boolean isUpdatableCursor() throws StandardException {
        return true;
    }

    @Override
    public final boolean isCompileTime() {
        return true;
    }

    @Override
    public String getOriginalSQL() {
        return this.getCompilerContext().getParser().getSQLtext();
    }

    @Override
    public final int getStatementIsolationLevel() {
        return TransactionControl.jdbcIsolationLevel(this.getCompilerContext().getScanIsolationLevel());
    }

    @Override
    public void setSharedState(String string, Serializable serializable) {
        if (string == null) {
            return;
        }
        this.compileTimeConstants.put(string, serializable);
    }

    @Override
    public Object getSharedState(String string) {
        if (string == null) {
            return null;
        }
        return this.compileTimeConstants.get(string);
    }

    private void createResultColumnsForTableFunction(TypeDescriptor typeDescriptor) throws StandardException {
        String[] stringArray = typeDescriptor.getRowColumnNames();
        TypeDescriptor[] typeDescriptorArray = typeDescriptor.getRowTypes();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getType(typeDescriptorArray[i2]);
            ResultColumn resultColumn = this.getResultColumns().addColumn(this.exposedName, string, dataTypeDescriptor);
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(string, i2 + 1, dataTypeDescriptor, (DataValueDescriptor)null, (DefaultInfo)null, (UUID)null, (UUID)null, 0L, 0L, 0L, false);
            resultColumn.setColumnDescriptor(null, columnDescriptor);
        }
    }

    private boolean implementsDerbyStyleVTICosting(String string) throws StandardException {
        Constructor<?> constructor = null;
        Class<?> clazz = this.lookupClass(string);
        Class<?> clazz2 = this.lookupClass(VTICosting.class.getName());
        try {
            if (!clazz2.isAssignableFrom(clazz)) {
                return false;
            }
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (Throwable throwable) {
            throw StandardException.newException("42ZB5", throwable, string);
        }
        if (Modifier.isPublic(constructor.getModifiers())) {
            return true;
        }
        throw StandardException.newException("42ZB5", string);
    }

    private VTICosting getVTICosting() throws StandardException {
        if (!this.isDerbyStyleTableFunction) {
            return this.version2 ? (VTICosting)((Object)this.ps) : (VTICosting)((Object)this.rs);
        }
        String string = this.methodCall.getJavaClassName();
        Class<?> clazz = this.lookupClass(string);
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            VTICosting vTICosting = (VTICosting)constructor.newInstance(null);
            return vTICosting;
        }
        catch (Throwable throwable) {
            throw StandardException.unexpectedUserException(throwable);
        }
    }

    private Class<?> lookupClass(String string) throws StandardException {
        try {
            return this.getClassFactory().getClassInspector().getClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw StandardException.unexpectedUserException(classNotFoundException);
        }
    }
}

