/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

class ActivationClassBuilder
extends ExpressionClassBuilder {
    private LocalField targetResultSetField;
    private LocalField cursorResultSetField;
    private MethodBuilder closeActivationMethod;

    ActivationClassBuilder(String string, CompilerContext compilerContext) throws StandardException {
        super(string, null, compilerContext);
    }

    @Override
    public String getPackageName() {
        return "org.apache.derby.exe.";
    }

    @Override
    String getBaseClassName() {
        return "org.apache.derby.impl.sql.execute.BaseActivation";
    }

    @Override
    public int getRowCount() throws StandardException {
        return this.myCompCtx.getNumResultSets();
    }

    @Override
    public void setNumSubqueries() {
        int n2 = this.myCompCtx.getNumSubquerys();
        if (n2 == 0) {
            return;
        }
        this.constructor.pushThis();
        this.constructor.push(n2);
        this.constructor.putField("org.apache.derby.impl.sql.execute.BaseActivation", "numSubqueries", "int");
        this.constructor.endStatement();
    }

    MethodBuilder startResetMethod() {
        MethodBuilder methodBuilder = this.cb.newMethodBuilder(1, "void", "reset");
        methodBuilder.addThrownException("org.apache.derby.iapi.error.StandardException");
        methodBuilder.pushThis();
        methodBuilder.callMethod((short)183, "org.apache.derby.impl.sql.execute.BaseActivation", "reset", "void", 0);
        return methodBuilder;
    }

    void finishExecuteMethod() {
        if (this.executeMethod != null) {
            this.executeMethod.methodReturn();
            this.executeMethod.complete();
        }
        if (this.closeActivationMethod != null) {
            this.closeActivationMethod.methodReturn();
            this.closeActivationMethod.complete();
        }
    }

    void addCursorPositionCode() {
        MethodBuilder methodBuilder = this.cb.newMethodBuilder(1, "org.apache.derby.iapi.sql.execute.CursorResultSet", "getTargetResultSet");
        methodBuilder.getField(this.targetResultSetField);
        methodBuilder.methodReturn();
        methodBuilder.complete();
        methodBuilder = this.cb.newMethodBuilder(1, "org.apache.derby.iapi.sql.execute.CursorResultSet", "getCursorResultSet");
        methodBuilder.getField(this.cursorResultSetField);
        methodBuilder.methodReturn();
        methodBuilder.complete();
    }

    void rememberCursorTarget(MethodBuilder methodBuilder) {
        this.targetResultSetField = this.cb.addField("org.apache.derby.iapi.sql.execute.CursorResultSet", "targetResultSet", 2);
        methodBuilder.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
        methodBuilder.putField(this.targetResultSetField);
        methodBuilder.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
    }

    void rememberCursor(MethodBuilder methodBuilder) {
        this.cursorResultSetField = this.cb.addField("org.apache.derby.iapi.sql.execute.CursorResultSet", "cursorResultSet", 2);
        methodBuilder.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
        methodBuilder.putField(this.cursorResultSetField);
        methodBuilder.cast("org.apache.derby.iapi.sql.ResultSet");
    }

    @Override
    protected LocalField getCurrentSetup() {
        if (this.cdtField != null) {
            return this.cdtField;
        }
        LocalField localField = super.getCurrentSetup();
        MethodBuilder methodBuilder = this.getExecuteMethod();
        methodBuilder.getField(localField);
        methodBuilder.callMethod((short)182, null, "forget", "void", 0);
        return localField;
    }

    MethodBuilder getCloseActivationMethod() {
        if (this.closeActivationMethod == null) {
            this.closeActivationMethod = this.cb.newMethodBuilder(1, "void", "closeActivationAction");
            this.closeActivationMethod.addThrownException("java.lang.Exception");
        }
        return this.closeActivationMethod;
    }
}

