/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;

class IndexInfoImpl {
    private IndexRowGenerator irg;
    private long conglomerateNumber;
    private final CatalogRowFactory crf;
    private final int indexNumber;

    IndexInfoImpl(int n2, CatalogRowFactory catalogRowFactory) {
        this.crf = catalogRowFactory;
        this.indexNumber = n2;
        this.conglomerateNumber = -1L;
    }

    long getConglomerateNumber() {
        return this.conglomerateNumber;
    }

    void setConglomerateNumber(long l2) {
        this.conglomerateNumber = l2;
    }

    String getIndexName() {
        return this.crf.getIndexName(this.indexNumber);
    }

    int getColumnCount() {
        return this.crf.getIndexColumnCount(this.indexNumber);
    }

    IndexRowGenerator getIndexRowGenerator() {
        return this.irg;
    }

    void setIndexRowGenerator(IndexRowGenerator indexRowGenerator) {
        this.irg = indexRowGenerator;
    }

    int getBaseColumnPosition(int n2) {
        return this.crf.getIndexColumnPositions(this.indexNumber)[n2];
    }

    boolean isIndexUnique() {
        return this.crf.isIndexUnique(this.indexNumber);
    }
}

