/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.impl.services.locks.AbstractPool;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockControl;
import org.apache.derby.impl.services.locks.LockSpace;
import org.apache.derby.impl.services.locks.LockTable;
import org.apache.derby.impl.services.locks.TableNameInfo;

class Deadlock {
    private Deadlock() {
    }

    static Object[] look(AbstractPool abstractPool, LockTable lockTable, LockControl lockControl, ActiveLock activeLock, byte by) {
        Hashtable hashtable = Deadlock.getWaiters(lockTable);
        Stack<Object> stack = new Stack<Object>();
        stack.push(activeLock.getCompatabilitySpace());
        stack.push(lockControl.getGrants());
        block0: while (!stack.isEmpty()) {
            int n2;
            List list = (List)stack.peek();
            if (list.isEmpty()) {
                Deadlock.rollback(stack);
                continue;
            }
            int n3 = list.size() - 1;
            CompatibilitySpace compatibilitySpace = ((Lock)list.get(n3)).getCompatabilitySpace();
            for (n2 = 0; n2 < n3; ++n2) {
                if (!compatibilitySpace.equals(((Lock)list.get(n2)).getCompatabilitySpace())) continue;
                stack.push(compatibilitySpace);
                Deadlock.rollback(stack);
                continue block0;
            }
            block2: while (true) {
                Lock lock;
                if ((n2 = stack.indexOf(compatibilitySpace)) != -1) {
                    if (n2 == stack.size() - 1 || n2 == stack.size() - 2 && n2 == stack.indexOf(list) - 1) {
                        lock = (ActiveLock)((Dictionary)hashtable).get(compatibilitySpace);
                        if (((ActiveLock)lock).canSkip) {
                            stack.push(compatibilitySpace);
                            Deadlock.rollback(stack);
                            continue block0;
                        }
                    }
                    return Deadlock.handle(abstractPool, stack, n2, hashtable, by);
                }
                stack.push(compatibilitySpace);
                while (true) {
                    Control control;
                    if ((lock = (Lock)((Dictionary)hashtable).get(compatibilitySpace)) == null) {
                        Deadlock.rollback(stack);
                        continue block0;
                    }
                    Object v2 = ((Dictionary)hashtable).get(lock);
                    if (v2 instanceof LockControl) {
                        control = (LockControl)v2;
                        if (((LockControl)control).isUnlocked()) {
                            Deadlock.rollback(stack);
                            continue block0;
                        }
                        stack.push(((LockControl)control).getGrants());
                        continue block0;
                    }
                    control = (ActiveLock)v2;
                    compatibilitySpace = ((Lock)control).getCompatabilitySpace();
                    if (!lock.getLockable().requestCompatible(lock.getQualifier(), ((Lock)control).getQualifier())) continue block2;
                }
                break;
            }
        }
        return null;
    }

    private static void rollback(Stack stack) {
        do {
            stack.pop();
            if (!stack.isEmpty()) continue;
            return;
        } while (!(stack.peek() instanceof List));
        List list = (List)stack.peek();
        list.remove(list.size() - 1);
    }

    private static Hashtable getWaiters(LockTable lockTable) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        lockTable.addWaiters(hashtable);
        return hashtable;
    }

    private static Object[] handle(AbstractPool abstractPool, Stack stack, int n2, Dictionary dictionary, byte by) {
        Object e2 = stack.elementAt(0);
        int n3 = Integer.MAX_VALUE;
        Object var7_7 = null;
        for (int i2 = n2; i2 < stack.size(); ++i2) {
            Object e3 = stack.elementAt(i2);
            if (e3 instanceof List) continue;
            if (e2.equals(e3) && by == 2) {
                var7_7 = e2;
                break;
            }
            LockSpace lockSpace = (LockSpace)e3;
            int n4 = lockSpace.deadlockCount(n3);
            if (n4 > n3) continue;
            var7_7 = e3;
            n3 = n4;
        }
        if (e2.equals(var7_7)) {
            Object[] objectArray = new Object[]{stack, dictionary};
            return objectArray;
        }
        ActiveLock activeLock = (ActiveLock)dictionary.get(var7_7);
        activeLock.wakeUp((byte)2);
        return null;
    }

    static StandardException buildException(AbstractPool abstractPool, Object[] objectArray) {
        Stack stack = (Stack)objectArray[0];
        Dictionary dictionary = (Dictionary)objectArray[1];
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)Deadlock.getContext("LanguageConnectionContext");
        TableNameInfo tableNameInfo = null;
        TransactionInfo[] transactionInfoArray = null;
        TransactionController transactionController = null;
        if (languageConnectionContext != null) {
            try {
                transactionController = languageConnectionContext.getTransactionExecute();
                tableNameInfo = new TableNameInfo(languageConnectionContext, false);
                transactionInfoArray = transactionController.getAccessManager().getTransactionInfo();
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(17);
        String string = null;
        for (int i2 = 0; i2 < stack.size(); ++i2) {
            Object object;
            Object e2 = stack.elementAt(i2);
            if (e2 instanceof List) {
                object = (List)e2;
                if (object.size() == 0) continue;
                stringBuffer.append("  Granted XID : ");
                for (int i3 = 0; i3 < object.size(); ++i3) {
                    if (i3 != 0) {
                        stringBuffer.append(", ");
                    }
                    Lock lock = (Lock)object.get(i3);
                    stringBuffer.append("{");
                    stringBuffer.append(lock.getCompatabilitySpace().getOwner());
                    stringBuffer.append(", ");
                    stringBuffer.append(lock.getQualifier());
                    stringBuffer.append("} ");
                }
                stringBuffer.append('\n');
                continue;
            }
            object = (Lock)dictionary.get(e2);
            ((Lock)object).getLockable().lockAttributes(-1, hashtable);
            Deadlock.addInfo(stringBuffer, "Lock : ", hashtable.get("TYPE"));
            if (tableNameInfo != null) {
                Long l2 = (Long)hashtable.get("CONGLOMID");
                if (l2 == null) {
                    Long l3 = (Long)hashtable.get("CONTAINERID");
                    try {
                        l2 = transactionController.findConglomid(l3);
                    }
                    catch (StandardException standardException) {
                        // empty catch block
                    }
                }
                Deadlock.addInfo(stringBuffer, ", ", tableNameInfo.getTableName(l2));
            }
            Deadlock.addInfo(stringBuffer, ", ", hashtable.get("LOCKNAME"));
            stringBuffer.append('\n');
            String string2 = String.valueOf(((Lock)object).getCompatabilitySpace().getOwner());
            if (i2 == 0) {
                string = string2;
            }
            Deadlock.addInfo(stringBuffer, "  Waiting XID : {", string2);
            Deadlock.addInfo(stringBuffer, ", ", ((Lock)object).getQualifier());
            stringBuffer.append("} ");
            if (transactionInfoArray != null) {
                for (int i4 = transactionInfoArray.length - 1; i4 >= 0; --i4) {
                    String string3;
                    TransactionInfo transactionInfo = transactionInfoArray[i4];
                    if (transactionInfo == null || (string3 = transactionInfo.getTransactionIdString()) == null || !string3.equals(string2)) continue;
                    Deadlock.addInfo(stringBuffer, ", ", transactionInfo.getUsernameString());
                    Deadlock.addInfo(stringBuffer, ", ", transactionInfo.getStatementTextString());
                    break;
                }
            }
            stringBuffer.append('\n');
            hashtable.clear();
        }
        StandardException standardException = StandardException.newException("40001", stringBuffer.toString(), string);
        standardException.setReport(abstractPool.deadlockMonitor);
        return standardException;
    }

    private static void addInfo(StringBuffer stringBuffer, String string, Object object) {
        stringBuffer.append(string);
        if (object == null) {
            object = "?";
        }
        stringBuffer.append(object);
    }

    static Context getContext(final String string) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContext(string);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContext(string);
            }
        });
    }
}

