/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.impl.services.cache.CacheEntry;
import org.apache.derby.impl.services.cache.ConcurrentCache;

final class BackgroundCleaner
implements Serviceable {
    private final DaemonService daemonService;
    private final int clientNumber;
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private final ArrayBlockingQueue<CacheEntry> queue;
    private volatile boolean shrink;
    private final ConcurrentCache cacheManager;

    BackgroundCleaner(ConcurrentCache concurrentCache, DaemonService daemonService, int n2) {
        this.queue = new ArrayBlockingQueue(n2);
        this.daemonService = daemonService;
        this.cacheManager = concurrentCache;
        this.clientNumber = daemonService.subscribe(this, true);
    }

    boolean scheduleClean(CacheEntry cacheEntry) {
        boolean bl = this.queue.offer(cacheEntry);
        if (bl) {
            this.requestService();
        }
        return bl;
    }

    void scheduleShrink() {
        this.shrink = true;
        this.requestService();
    }

    private void requestService() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.daemonService.serviceNow(this.clientNumber);
        }
    }

    void unsubscribe() {
        this.daemonService.unsubscribe(this.clientNumber);
    }

    @Override
    public int performWork(ContextManager contextManager) throws StandardException {
        CacheEntry cacheEntry;
        this.scheduled.set(false);
        if (this.shrink) {
            this.shrink = false;
            this.cacheManager.getReplacementPolicy().doShrink();
        }
        if ((cacheEntry = this.queue.poll()) != null) {
            try {
                this.cacheManager.cleanEntry(cacheEntry);
            }
            finally {
                if (!this.queue.isEmpty() || this.shrink) {
                    this.requestService();
                }
            }
        }
        return 1;
    }

    @Override
    public boolean serviceASAP() {
        return true;
    }

    @Override
    public boolean serviceImmediately() {
        return false;
    }
}

