/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.impl.load.ImportLobFile;
import org.apache.derby.impl.load.LoadError;

class ImportBlob
implements Blob {
    private ImportLobFile lobFile;
    private long blobPosition;
    private long blobLength;
    private byte[] blobData = null;

    public ImportBlob(ImportLobFile importLobFile, long l2, long l3) {
        this.lobFile = importLobFile;
        this.blobPosition = l2;
        this.blobLength = l3;
    }

    public ImportBlob(byte[] byArray) {
        this.blobData = byArray;
        this.blobLength = byArray.length;
    }

    @Override
    public long length() throws SQLException {
        return this.blobLength;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            if (this.blobData != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.blobData);
                LimitInputStream limitInputStream = new LimitInputStream(byteArrayInputStream);
                limitInputStream.setLimit((int)this.blobLength);
                return limitInputStream;
            }
            return this.lobFile.getBinaryStream(this.blobPosition, this.blobLength);
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
    }

    @Override
    public byte[] getBytes(long l2, int n2) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public long position(byte[] byArray, long l2) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public long position(Blob blob, long l2) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public int setBytes(long l2, byte[] byArray) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public OutputStream setBinaryStream(long l2) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public void truncate(long l2) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        throw this.methodNotImplemented();
    }

    @Override
    public void free() throws SQLException {
        throw this.methodNotImplemented();
    }

    private SQLException methodNotImplemented() {
        return LoadError.unexpectedError(new Exception("Method not implemented"));
    }
}

