/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.derby.impl.jdbc.UTF8Reader;

public final class ReaderToAscii
extends InputStream {
    private final Reader data;
    private char[] conv;
    private boolean closed;

    public ReaderToAscii(Reader reader) {
        this.data = reader;
        if (!(reader instanceof UTF8Reader)) {
            this.conv = new char[256];
        }
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        int n2 = this.data.read();
        if (n2 == -1) {
            return -1;
        }
        if (n2 <= 255) {
            return n2 & 0xFF;
        }
        return 63;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (this.data instanceof UTF8Reader) {
            return ((UTF8Reader)this.data).readAsciiInto(byArray, n2, n3);
        }
        if (n3 > this.conv.length) {
            n3 = this.conv.length;
        }
        if ((n3 = this.data.read(this.conv, 0, n3)) == -1) {
            return -1;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = this.conv[i2];
            int n4 = c2 <= '\u00ff' ? (int)((byte)c2) : 63;
            byArray[n2++] = n4;
        }
        return n3;
    }

    @Override
    public long skip(long l2) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        return this.data.skip(l2);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.data.close();
        }
    }
}

