/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.jdbc.EngineCallableStatement;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;

public class EmbedCallableStatement
extends EmbedPreparedStatement
implements EngineCallableStatement {
    private boolean hasReturnOutputParameter;
    protected boolean wasNull;

    public EmbedCallableStatement(EmbedConnection embedConnection, String string, int n2, int n3, int n4) throws SQLException {
        super(embedConnection, string, false, n2, n3, n4, 2, null, null);
        ParameterValueSet parameterValueSet = this.getParms();
        this.hasReturnOutputParameter = parameterValueSet.hasReturnOutputParameter();
    }

    @Override
    protected void checkRequiresCallableStatement(Activation activation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean executeStatement(Activation activation, boolean bl, boolean bl2) throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.wasNull = false;
            try {
                this.getParms().validate();
            }
            catch (StandardException standardException) {
                throw EmbedResultSet.noStateChangeException(standardException);
            }
            boolean bl3 = super.executeStatement(activation, bl, bl2 && !this.hasReturnOutputParameter);
            ParameterValueSet parameterValueSet = this.getParms();
            if (this.hasReturnOutputParameter) {
                boolean bl4 = this.results.next();
                try {
                    DataValueDescriptor dataValueDescriptor = parameterValueSet.getReturnValueForSet();
                    dataValueDescriptor.setValueFromResultSet(this.results, 1, true);
                }
                catch (StandardException standardException) {
                    throw EmbedResultSet.noStateChangeException(standardException);
                }
                finally {
                    this.results.close();
                    this.results = null;
                }
                bl3 = false;
            }
            return bl3;
        }
    }

    @Override
    public final void registerOutParameter(int n2, int n3) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().registerOutParameter(n2 - 1, n3, -1);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public final void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        this.checkStatus();
        if (n4 < 0) {
            throw EmbedCallableStatement.newSQLException("XJ044.S", n4);
        }
        try {
            this.getParms().registerOutParameter(n2 - 1, n3, n4);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        this.registerOutParameter(n2, n3);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkStatus();
        return this.wasNull;
    }

    @Override
    public String getString(int n2) throws SQLException {
        this.checkStatus();
        try {
            String string = this.getParms().getParameterForGet(n2 - 1).getString();
            this.wasNull = string == null;
            return string;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n2 - 1);
            boolean bl = dataValueDescriptor.getBoolean();
            this.wasNull = !bl && dataValueDescriptor.isNull();
            return bl;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n2 - 1);
            byte by = dataValueDescriptor.getByte();
            this.wasNull = by == 0 && dataValueDescriptor.isNull();
            return by;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public short getShort(int n2) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n2 - 1);
            short s2 = dataValueDescriptor.getShort();
            this.wasNull = s2 == 0 && dataValueDescriptor.isNull();
            return s2;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public int getInt(int n2) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n2 - 1);
            int n3 = dataValueDescriptor.getInt();
            this.wasNull = n3 == 0 && dataValueDescriptor.isNull();
            return n3;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public long getLong(int n2) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n2 - 1);
            long l2 = dataValueDescriptor.getLong();
            this.wasNull = l2 == 0L && dataValueDescriptor.isNull();
            return l2;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public final BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n2 - 1);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            return SQLDecimal.getBigDecimal(dataValueDescriptor);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public final BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n2);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n3, 5);
        }
        return bigDecimal;
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n2 - 1);
            float f2 = dataValueDescriptor.getFloat();
            this.wasNull = (double)f2 == 0.0 && dataValueDescriptor.isNull();
            return f2;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n2 - 1);
            double d2 = dataValueDescriptor.getDouble();
            this.wasNull = d2 == 0.0 && dataValueDescriptor.isNull();
            return d2;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        this.checkStatus();
        try {
            byte[] byArray = this.getParms().getParameterForGet(n2 - 1).getBytes();
            this.wasNull = byArray == null;
            return byArray;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        this.checkStatus();
        try {
            Date date = this.getParms().getParameterForGet(n2 - 1).getDate(calendar);
            this.wasNull = date == null;
            return date;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        this.checkStatus();
        try {
            Time time = this.getParms().getParameterForGet(n2 - 1).getTime(calendar);
            this.wasNull = time == null;
            return time;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        this.checkStatus();
        try {
            Timestamp timestamp = this.getParms().getParameterForGet(n2 - 1).getTimestamp(calendar);
            this.wasNull = timestamp == null;
            return timestamp;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        return this.getDate(n2, this.getCal());
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        return this.getTime(n2, this.getCal());
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        return this.getTimestamp(n2, this.getCal());
    }

    @Override
    public final Object getObject(int n2) throws SQLException {
        this.checkStatus();
        try {
            Object object = this.getParms().getParameterForGet(n2 - 1).getObject();
            this.wasNull = object == null;
            return object;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Blob) {
            return (Blob)object;
        }
        throw EmbedCallableStatement.newSQLException("22005", Blob.class.getName(), Util.typeName(this.getParameterJDBCType(n2)));
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Clob) {
            return (Clob)object;
        }
        throw EmbedCallableStatement.newSQLException("22005", Clob.class.getName(), Util.typeName(this.getParameterJDBCType(n2)));
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkStatus();
        ParameterValueSet parameterValueSet = this.getParms();
        int n2 = parameterValueSet.getParameterCount();
        block4: for (int i2 = 1; i2 <= n2; ++i2) {
            switch (parameterValueSet.getParameterMode(i2)) {
                case 0: 
                case 1: {
                    continue block4;
                }
                case 2: 
                case 4: {
                    throw EmbedCallableStatement.newSQLException("XJ04C.S", new Object[0]);
                }
            }
        }
        super.addBatch();
    }

    @Override
    public final Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        this.checkStatus();
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.CallableStatement.getObject");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(n2);
    }

    @Override
    public final Ref getRef(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Array getArray(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void registerOutParameter(String string, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void registerOutParameter(String string, int n2, String string2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void registerOutParameter(String string, int n2, int n3) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Ref getRef(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Blob getBlob(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Clob getClob(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Array getArray(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNull(String string, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNull(String string, int n2, String string2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBoolean(String string, boolean bl) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final boolean getBoolean(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setByte(String string, byte by) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final byte getByte(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setShort(String string, short s2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final short getShort(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setInt(String string, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final int getInt(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setLong(String string, long l2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final long getLong(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setFloat(String string, float f2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final float getFloat(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setDouble(String string, double d2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final double getDouble(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final BigDecimal getBigDecimal(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setString(String string, String string2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final String getString(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBytes(String string, byte[] byArray) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final byte[] getBytes(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setDate(String string, Date date) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Date getDate(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Date getDate(String string, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setTime(String string, Time time) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Time getTime(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Time getTime(String string, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Timestamp getTimestamp(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setObject(String string, Object object, int n2, int n3) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Object getObject(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        this.checkStatus();
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.CallableStatement.getObject");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(string);
    }

    @Override
    public final void setObject(String string, Object object, int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setObject(String string, Object object) throws SQLException {
        throw Util.notImplemented();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Reader getCharacterStream(int n2) throws SQLException {
        this.checkStatus();
        switch (this.getParms().getParameterMode(n2)) {
            case 0: 
            case 1: {
                throw EmbedCallableStatement.newSQLException("XCL26.S", Integer.toString(n2));
            }
        }
        Reader reader = null;
        int n3 = this.getParameterJDBCType(n2);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                Object object;
                boolean bl = false;
                Object object2 = object = this.getConnectionSynchronization();
                synchronized (object2) {
                    try {
                        StringDataValue stringDataValue = (StringDataValue)this.getParms().getParameterForGet(n2 - 1);
                        if (stringDataValue.isNull()) {
                            break;
                        }
                        bl = true;
                        this.setupContextStack();
                        if (stringDataValue.hasStream()) {
                            CharacterStreamDescriptor characterStreamDescriptor = stringDataValue.getStreamWithDescriptor();
                            reader = new UTF8Reader(characterStreamDescriptor, this, object);
                        } else {
                            reader = new StringReader(stringDataValue.getString());
                        }
                    }
                    catch (Throwable throwable) {
                        throw EmbedResultSet.noStateChangeException(throwable);
                    }
                    finally {
                        if (bl) {
                            this.restoreContextStack();
                        }
                    }
                    break;
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                try {
                    InputStream inputStream = this.getBinaryStream(n2);
                    if (inputStream == null) break;
                    reader = new InputStreamReader(inputStream, "UTF-16BE");
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw EmbedCallableStatement.newSQLException(unsupportedEncodingException.getMessage(), new Object[0]);
                }
            }
            default: {
                throw EmbedCallableStatement.newSQLException("22005", "java.io.Reader", Util.typeName(n3));
            }
        }
        this.wasNull = reader == null;
        return reader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getBinaryStream(int n2) throws SQLException {
        int n3 = this.getParameterJDBCType(n2);
        switch (n3) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                break;
            }
            default: {
                throw EmbedCallableStatement.newSQLException("22005", "java.io.InputStream", Util.typeName(n3));
            }
        }
        boolean bl = false;
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n2 - 1);
                this.wasNull = dataValueDescriptor.isNull();
                if (this.wasNull) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                bl = true;
                this.setupContextStack();
                InputStream inputStream = dataValueDescriptor.hasStream() ? new BinaryToRawStream(dataValueDescriptor.getStream(), dataValueDescriptor) : new ByteArrayInputStream(dataValueDescriptor.getBytes());
                InputStream inputStream2 = inputStream;
                return inputStream2;
            }
            catch (Throwable throwable) {
                throw EmbedResultSet.noStateChangeException(throwable);
            }
            finally {
                if (bl) {
                    this.restoreContextStack();
                }
            }
        }
    }

    @Override
    public final Reader getCharacterStream(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Reader getNCharacterStream(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Reader getNCharacterStream(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final String getNString(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final String getNString(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBlob(String string, Blob blob) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setClob(String string, Clob clob) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final RowId getRowId(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final RowId getRowId(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setRowId(String string, RowId rowId) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNString(String string, String string2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNClob(String string, NClob nClob) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setClob(String string, Reader reader, long l2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBlob(String string, InputStream inputStream, long l2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNClob(String string, Reader reader, long l2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final NClob getNClob(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final NClob getNClob(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final SQLXML getSQLXML(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final SQLXML getSQLXML(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw Util.notImplemented("setAsciiStream(String,InputStream)");
    }

    @Override
    public final void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw Util.notImplemented("setBinaryStream(String,InputStream)");
    }

    @Override
    public final void setBlob(String string, InputStream inputStream) throws SQLException {
        throw Util.notImplemented("setBlob(String,InputStream)");
    }

    @Override
    public final void setCharacterStream(String string, Reader reader) throws SQLException {
        throw Util.notImplemented("setCharacterStream(String,Reader)");
    }

    @Override
    public final void setClob(String string, Reader reader) throws SQLException {
        throw Util.notImplemented("setClob(String,Reader)");
    }

    @Override
    public final void setNCharacterStream(String string, Reader reader) throws SQLException {
        throw Util.notImplemented("setNCharacterStream(String,Reader)");
    }

    @Override
    public final void setNClob(String string, Reader reader) throws SQLException {
        throw Util.notImplemented("setNClob(String,Reader)");
    }

    @Override
    public final void setAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setCharacterStream(String string, Reader reader, long l2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        this.checkStatus();
        if (clazz == null) {
            throw this.mismatchException("NULL", n2);
        }
        Object object = String.class.equals(clazz) ? this.getString(n2) : (BigDecimal.class.equals(clazz) ? this.getBigDecimal(n2) : (Boolean.class.equals(clazz) ? Boolean.valueOf(this.getBoolean(n2)) : (Byte.class.equals(clazz) ? Byte.valueOf(this.getByte(n2)) : (Short.class.equals(clazz) ? Short.valueOf(this.getShort(n2)) : (Integer.class.equals(clazz) ? Integer.valueOf(this.getInt(n2)) : (Long.class.equals(clazz) ? Long.valueOf(this.getLong(n2)) : (Float.class.equals(clazz) ? Float.valueOf(this.getFloat(n2)) : (Double.class.equals(clazz) ? Double.valueOf(this.getDouble(n2)) : (Date.class.equals(clazz) ? this.getDate(n2) : (Time.class.equals(clazz) ? this.getTime(n2) : (Timestamp.class.equals(clazz) ? this.getTimestamp(n2) : (Blob.class.equals(clazz) ? this.getBlob(n2) : (Clob.class.equals(clazz) ? this.getClob(n2) : (clazz.isArray() && clazz.getComponentType().equals(Byte.TYPE) ? (Object)this.getBytes(n2) : this.getObject(n2)))))))))))))));
        if (this.wasNull()) {
            object = null;
        }
        if (object == null || clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        throw this.mismatchException(clazz.getName(), n2);
    }

    private SQLException mismatchException(String string, int n2) throws SQLException {
        String string2 = this.getParameterMetaData().getParameterTypeName(n2);
        return EmbedCallableStatement.newSQLException("22005", string, string2);
    }

    @Override
    public final <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw Util.notImplemented();
    }
}

