/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.File;

public class PathUtil {
    public static final char SEP = File.separatorChar;
    public static final String SEP_STR = String.valueOf(SEP);

    private PathUtil() {
    }

    private static void basicPathChecks(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Path is null");
        }
        if (!string.equals(string.trim())) {
            throw new IllegalArgumentException("Path has not been trimmed: '" + string + "'");
        }
    }

    public static String getBaseName(String string) {
        PathUtil.basicPathChecks(string);
        int n2 = string.lastIndexOf(SEP);
        if (n2 != -1 && n2 != string.length() - 1) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    public static String getParent(String string) {
        int n2;
        PathUtil.basicPathChecks(string);
        if (string.equals(SEP_STR)) {
            return null;
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == SEP) {
            string = string.substring(0, string.length() - 1);
        }
        if ((n2 = string.lastIndexOf(SEP)) == 0) {
            return SEP_STR;
        }
        if (n2 > 0) {
            return string.substring(0, n2);
        }
        return null;
    }

    public static String join(String string, String string2) {
        if (string.charAt(string.length() - 1) == SEP) {
            return string + string2;
        }
        return string + SEP + string2;
    }
}

