/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.Clob;
import java.text.RuleBasedCollator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.CollatorSQLVarchar;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.StringDataValue;

public class SQLVarchar
extends SQLChar {
    @Override
    public String getTypeName() {
        return "VARCHAR";
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl) {
        try {
            return new SQLVarchar(this.getString());
        }
        catch (StandardException standardException) {
            return null;
        }
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLVarchar();
    }

    @Override
    public StringDataValue getValue(RuleBasedCollator ruleBasedCollator) {
        if (ruleBasedCollator == null) {
            return this;
        }
        CollatorSQLVarchar collatorSQLVarchar = new CollatorSQLVarchar(ruleBasedCollator);
        collatorSQLVarchar.copyState(this);
        return collatorSQLVarchar;
    }

    @Override
    public int getTypeFormatId() {
        return 85;
    }

    public SQLVarchar() {
    }

    public SQLVarchar(String string) {
        super(string);
    }

    public SQLVarchar(Clob clob) {
        super(clob);
    }

    public SQLVarchar(char[] cArray) {
        super(cArray);
    }

    @Override
    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.normalize(dataTypeDescriptor, dataValueDescriptor.getString());
    }

    @Override
    protected void normalize(DataTypeDescriptor dataTypeDescriptor, String string) throws StandardException {
        int n2 = dataTypeDescriptor.getMaximumWidth();
        int n3 = string.length();
        if (n3 > n2) {
            this.hasNonBlankChars(string, n2, n3);
            string = string.substring(0, n2);
        }
        this.setValue(string);
    }

    @Override
    public int typePrecedence() {
        return 10;
    }

    @Override
    protected final int growBy() {
        return 4096;
    }
}

