/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.DerbyIOException;
import org.apache.derby.iapi.services.io.LimitInputStream;

public final class RawToBinaryFormatStream
extends LimitInputStream {
    private int encodedOffset;
    private byte[] encodedLength;
    private boolean eof = false;
    private final int length;
    private final int maximumLength;
    private final String typeName;

    public RawToBinaryFormatStream(InputStream inputStream, int n2) {
        super(inputStream);
        if (n2 < 0) {
            throw new IllegalArgumentException("Stream length cannot be negative: " + n2);
        }
        this.length = n2;
        this.maximumLength = -1;
        this.typeName = null;
        this.setLimit(n2);
        if (n2 <= 31) {
            this.encodedLength = new byte[1];
            this.encodedLength[0] = (byte)(0x80 | n2 & 0xFF);
        } else if (n2 <= 65535) {
            this.encodedLength = new byte[3];
            this.encodedLength[0] = -96;
            this.encodedLength[1] = (byte)(n2 >> 8);
            this.encodedLength[2] = (byte)n2;
        } else {
            this.encodedLength = new byte[5];
            this.encodedLength[0] = -64;
            this.encodedLength[1] = (byte)(n2 >> 24);
            this.encodedLength[2] = (byte)(n2 >> 16);
            this.encodedLength[3] = (byte)(n2 >> 8);
            this.encodedLength[4] = (byte)n2;
        }
    }

    public RawToBinaryFormatStream(InputStream inputStream, int n2, String string) {
        super(inputStream);
        if (n2 < 0) {
            throw new IllegalArgumentException("Maximum length for a capped stream cannot be negative: " + n2);
        }
        if (string == null) {
            throw new IllegalArgumentException("Type name cannot be null");
        }
        this.length = -1;
        this.maximumLength = n2;
        this.typeName = string;
        this.encodedLength = new byte[4];
        this.setLimit(n2);
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S", new Object[0]));
        }
        if (this.encodedOffset < this.encodedLength.length) {
            return this.encodedLength[this.encodedOffset++] & 0xFF;
        }
        int n2 = super.read();
        if (n2 == -1) {
            this.checkSufficientData();
        }
        return n2;
    }

    private void checkSufficientData() throws IOException {
        this.eof = true;
        if (!this.limitInPlace) {
            return;
        }
        int n2 = this.clearLimit();
        if (this.length > -1 && n2 > 0) {
            throw new DerbyIOException(MessageService.getTextMessage("XJ023.S", new Object[0]), "XJ023.S");
        }
        if (n2 == 0) {
            int n3;
            try {
                n3 = super.read();
            }
            catch (IOException iOException) {
                n3 = -1;
            }
            if (n3 != -1) {
                if (this.length > -1) {
                    throw new DerbyIOException(MessageService.getTextMessage("XJ023.S", new Object[0]), "XJ023.S");
                }
                throw new DerbyIOException(MessageService.getTextMessage("22001", this.typeName, "XXXX", String.valueOf(this.maximumLength)), "22001");
            }
        }
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.eof) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S", new Object[0]));
        }
        int n5 = this.encodedLength.length - this.encodedOffset;
        if (n5 != 0) {
            if (n3 < n5) {
                n5 = n3;
            }
            System.arraycopy(this.encodedLength, this.encodedOffset, byArray, n2, n5);
            this.encodedOffset += n5;
            n2 += n5;
            if ((n3 -= n5) == 0) {
                return n5;
            }
        }
        if ((n4 = super.read(byArray, n2, n3)) < 0) {
            if (n5 != 0) {
                return n5;
            }
            this.checkSufficientData();
            return n4;
        }
        return n5 + n4;
    }
}

