/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.raw;

public final class ContainerLock {
    private final int type;
    private final int typeBit;
    private final int compat;
    public static final int C_NUMBER = 5;
    private static final boolean[][] C_COMPAT = new boolean[][]{{true, true, true, false, false}, {true, true, false, false, false}, {true, false, true, false, false}, {false, false, true, false, false}, {false, false, false, false, false}};
    private static String[] shortnames = new String[]{"IS", "IX", "S", "U", "X"};
    public static final ContainerLock CIS = new ContainerLock(0);
    public static final ContainerLock CIX = new ContainerLock(1);
    public static final ContainerLock CS = new ContainerLock(2);
    public static final ContainerLock CU = new ContainerLock(3);
    public static final ContainerLock CX = new ContainerLock(4);

    private ContainerLock(int n2) {
        this.type = n2;
        this.typeBit = 1 << n2;
        int n3 = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            if (!C_COMPAT[n2][i2]) continue;
            n3 |= 1 << i2;
        }
        this.compat = n3;
    }

    public int getType() {
        return this.type;
    }

    public boolean isCompatible(ContainerLock containerLock) {
        return (containerLock.typeBit & this.compat) != 0;
    }

    public String toString() {
        return shortnames[this.getType()];
    }
}

