/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;

public class RowUtil {
    public static final DataValueDescriptor[] EMPTY_ROW = new DataValueDescriptor[0];
    public static final FormatableBitSet EMPTY_ROW_BITSET = new FormatableBitSet(0);
    public static final FetchDescriptor EMPTY_ROW_FETCH_DESCRIPTOR = new FetchDescriptor(0);
    private static final FetchDescriptor[] ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS = new FetchDescriptor[]{EMPTY_ROW_FETCH_DESCRIPTOR, new FetchDescriptor(1, 1), new FetchDescriptor(2, 2), new FetchDescriptor(3, 3), new FetchDescriptor(4, 4), new FetchDescriptor(5, 5), new FetchDescriptor(6, 6), new FetchDescriptor(7, 7)};

    private RowUtil() {
    }

    public static DataValueDescriptor getColumn(DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet, int n2) {
        if (formatableBitSet == null) {
            return n2 < dataValueDescriptorArray.length ? dataValueDescriptorArray[n2] : null;
        }
        if (formatableBitSet.getLength() <= n2 || !formatableBitSet.isSet(n2)) {
            return null;
        }
        return n2 < dataValueDescriptorArray.length ? dataValueDescriptorArray[n2] : null;
    }

    public static Object getColumn(Object[] objectArray, FormatableBitSet formatableBitSet, int n2) {
        if (formatableBitSet == null) {
            return n2 < objectArray.length ? objectArray[n2] : null;
        }
        if (formatableBitSet.getLength() <= n2 || !formatableBitSet.isSet(n2)) {
            return null;
        }
        return n2 < objectArray.length ? objectArray[n2] : null;
    }

    public static FormatableBitSet getQualifierBitSet(Qualifier[][] qualifierArray) {
        FormatableBitSet formatableBitSet = new FormatableBitSet();
        if (qualifierArray != null) {
            for (int i2 = 0; i2 < qualifierArray.length; ++i2) {
                for (int i3 = 0; i3 < qualifierArray[i2].length; ++i3) {
                    int n2 = qualifierArray[i2][i3].getColumnId();
                    formatableBitSet.grow(n2 + 1);
                    formatableBitSet.set(n2);
                }
            }
        }
        return formatableBitSet;
    }

    public static int getNumberOfColumns(int n2, FormatableBitSet formatableBitSet) {
        int n3 = formatableBitSet.getLength();
        if (n2 > 0 && n2 < n3) {
            n3 = n2;
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!formatableBitSet.isSet(i2)) continue;
            ++n4;
        }
        return n4;
    }

    public static boolean isRowEmpty(DataValueDescriptor[] dataValueDescriptorArray) {
        if (dataValueDescriptorArray == null) {
            return true;
        }
        return dataValueDescriptorArray.length == 0;
    }

    public static int columnOutOfRange(DataValueDescriptor[] dataValueDescriptorArray, FormatableBitSet formatableBitSet, int n2) {
        if (formatableBitSet == null) {
            if (dataValueDescriptorArray.length > n2) {
                return n2;
            }
            return -1;
        }
        int n3 = formatableBitSet.getLength();
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!formatableBitSet.isSet(i2)) continue;
            return i2;
        }
        return -1;
    }

    public static int nextColumn(Object[] objectArray, FormatableBitSet formatableBitSet, int n2) {
        if (formatableBitSet != null) {
            int n3 = formatableBitSet.getLength();
            while (n2 < n3) {
                if (formatableBitSet.isSet(n2)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
        if (objectArray == null) {
            return -1;
        }
        return n2 < objectArray.length ? n2 : -1;
    }

    public static final FetchDescriptor getFetchDescriptorConstant(int n2) {
        if (n2 < ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS.length) {
            return ROWUTIL_FETCH_DESCRIPTOR_CONSTANTS[n2];
        }
        return new FetchDescriptor(n2, n2);
    }

    public static DataValueDescriptor[] newTemplate(DataValueFactory dataValueFactory, FormatableBitSet formatableBitSet, int[] nArray, int[] nArray2) throws StandardException {
        int n2 = nArray.length;
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n2];
        int n3 = formatableBitSet == null ? 0 : formatableBitSet.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (formatableBitSet != null && (n3 <= i2 || !formatableBitSet.isSet(i2))) continue;
            dataValueDescriptorArray[i2] = dataValueFactory.getNull(nArray[i2], nArray2[i2]);
        }
        return dataValueDescriptorArray;
    }

    public static DataValueDescriptor[] newRowFromTemplate(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length];
        int n2 = dataValueDescriptorArray.length;
        while (n2-- > 0) {
            if (dataValueDescriptorArray[n2] == null) continue;
            dataValueDescriptorArray2[n2] = dataValueDescriptorArray[n2].getNewNull();
        }
        return dataValueDescriptorArray2;
    }

    public static String toString(Object[] objectArray) {
        return null;
    }

    public static String toString(Hashtable hashtable) {
        return null;
    }

    public static final boolean qualifyRow(DataValueDescriptor[] dataValueDescriptorArray, Qualifier[][] qualifierArray) throws StandardException {
        Object object;
        int n2;
        boolean bl = true;
        for (n2 = 0; n2 < qualifierArray[0].length; ++n2) {
            bl = false;
            Qualifier qualifier = qualifierArray[0][n2];
            object = dataValueDescriptorArray[qualifier.getColumnId()];
            bl = object.compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
            if (qualifier.negateCompareResult()) {
                boolean bl2 = bl = !bl;
            }
            if (bl) continue;
            return false;
        }
        for (n2 = 1; n2 < qualifierArray.length; ++n2) {
            bl = false;
            for (int i2 = 0; i2 < qualifierArray[n2].length; ++i2) {
                object = qualifierArray[n2][i2];
                int n3 = object.getColumnId();
                DataValueDescriptor dataValueDescriptor = dataValueDescriptorArray[object.getColumnId()];
                bl = dataValueDescriptor.compare(object.getOperator(), object.getOrderable(), object.getOrderedNulls(), object.getUnknownRV());
                if (object.negateCompareResult()) {
                    boolean bl3 = bl = !bl;
                }
                if (bl) break;
            }
            if (!bl) break;
        }
        return bl;
    }
}

