/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.catalog.types.IndexDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.RowLocation;

public class IndexRowGenerator
implements IndexDescriptor,
Formatable {
    private IndexDescriptor id;
    private ExecutionFactory ef;

    public IndexRowGenerator(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int[] nArray, boolean[] blArray, int n2) {
        this.id = new IndexDescriptorImpl(string, bl, bl2, bl3, bl4, nArray, blArray, n2);
    }

    public IndexRowGenerator(IndexDescriptor indexDescriptor) {
        this.id = indexDescriptor;
    }

    public ExecIndexRow getIndexRowTemplate() {
        return this.getExecutionFactory().getIndexableRow(this.id.baseColumnPositions().length + 1);
    }

    public ExecIndexRow getNullIndexRow(ColumnDescriptorList columnDescriptorList, RowLocation rowLocation) throws StandardException {
        int[] nArray = this.id.baseColumnPositions();
        ExecIndexRow execIndexRow = this.getIndexRowTemplate();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            DataTypeDescriptor dataTypeDescriptor = columnDescriptorList.elementAt(nArray[i2] - 1).getType();
            execIndexRow.setColumn(i2 + 1, dataTypeDescriptor.getNull());
        }
        execIndexRow.setColumn(nArray.length + 1, rowLocation);
        return execIndexRow;
    }

    public void getIndexRow(ExecRow execRow, RowLocation rowLocation, ExecIndexRow execIndexRow, FormatableBitSet formatableBitSet) throws StandardException {
        int[] nArray = this.id.baseColumnPositions();
        int n2 = nArray.length;
        if (formatableBitSet == null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                execIndexRow.setColumn(i2 + 1, execRow.getColumn(nArray[i2]));
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n3 = nArray[i3];
                int n4 = 0;
                for (int i4 = 1; i4 <= n3; ++i4) {
                    if (!formatableBitSet.get(i4)) continue;
                    ++n4;
                }
                execIndexRow.setColumn(i3 + 1, execRow.getColumn(n4));
            }
        }
        execIndexRow.setColumn(n2 + 1, rowLocation);
    }

    public int[] getColumnCollationIds(ColumnDescriptorList columnDescriptorList) throws StandardException {
        int[] nArray = this.id.baseColumnPositions();
        int[] nArray2 = new int[nArray.length + 1];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = columnDescriptorList.elementAt(nArray[i2] - 1).getType().getCollationType();
        }
        nArray2[nArray2.length - 1] = 0;
        return nArray2;
    }

    public IndexDescriptor getIndexDescriptor() {
        return this.id;
    }

    public IndexRowGenerator() {
    }

    @Override
    public boolean isUniqueWithDuplicateNulls() {
        return this.id.isUniqueWithDuplicateNulls();
    }

    @Override
    public boolean hasDeferrableChecking() {
        return this.id.hasDeferrableChecking();
    }

    @Override
    public boolean isUniqueDeferrable() {
        return this.id.isUniqueDeferrable();
    }

    @Override
    public boolean isUnique() {
        return this.id.isUnique();
    }

    @Override
    public int[] baseColumnPositions() {
        return this.id.baseColumnPositions();
    }

    @Override
    public int getKeyColumnPosition(int n2) {
        return this.id.getKeyColumnPosition(n2);
    }

    @Override
    public int numberOfOrderedColumns() {
        return this.id.numberOfOrderedColumns();
    }

    @Override
    public String indexType() {
        return this.id.indexType();
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public boolean isAscending(Integer n2) {
        return this.id.isAscending(n2);
    }

    @Override
    public boolean isDescending(Integer n2) {
        return this.id.isDescending(n2);
    }

    @Override
    public boolean[] isAscending() {
        return this.id.isAscending();
    }

    @Override
    public void setBaseColumnPositions(int[] nArray) {
        this.id.setBaseColumnPositions(nArray);
    }

    @Override
    public void setIsAscending(boolean[] blArray) {
        this.id.setIsAscending(blArray);
    }

    @Override
    public void setNumberOfOrderedColumns(int n2) {
        this.id.setNumberOfOrderedColumns(n2);
    }

    public boolean equals(Object object) {
        return this.id.equals(object);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private ExecutionFactory getExecutionFactory() {
        if (this.ef == null) {
            ExecutionContext executionContext = (ExecutionContext)IndexRowGenerator.getContext("ExecutionContext");
            this.ef = executionContext.getExecutionFactory();
        }
        return this.ef;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.id = (IndexDescriptor)objectInput.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.id);
    }

    @Override
    public int getTypeFormatId() {
        return 268;
    }

    private static Context getContext(final String string) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContext(string);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContext(string);
            }
        });
    }
}

