/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;

public abstract class CompressedNumber {
    public static final int MAX_INT_STORED_SIZE = 4;
    public static final int MAX_LONG_STORED_SIZE = 8;
    public static final int MAX_COMPRESSED_INT_ONE_BYTE = 63;
    public static final int MAX_COMPRESSED_INT_TWO_BYTES = 16383;

    public static final int writeInt(DataOutput dataOutput, int n2) throws IOException {
        if (n2 < 0) {
            throw new IOException();
        }
        if (n2 <= 63) {
            dataOutput.writeByte(n2);
            return 1;
        }
        if (n2 <= 16383) {
            dataOutput.writeByte(0x40 | n2 >>> 8);
            dataOutput.writeByte(n2 & 0xFF);
            return 2;
        }
        dataOutput.writeByte((n2 >>> 24 | 0x80) & 0xFF);
        dataOutput.writeByte(n2 >>> 16 & 0xFF);
        dataOutput.writeByte(n2 >>> 8 & 0xFF);
        dataOutput.writeByte(n2 & 0xFF);
        return 4;
    }

    public static final int writeInt(OutputStream outputStream, int n2) throws IOException {
        if (n2 < 0) {
            throw new IOException();
        }
        if (n2 <= 63) {
            outputStream.write(n2);
            return 1;
        }
        if (n2 <= 16383) {
            outputStream.write(0x40 | n2 >>> 8);
            outputStream.write(n2 & 0xFF);
            return 2;
        }
        outputStream.write((n2 >>> 24 | 0x80) & 0xFF);
        outputStream.write(n2 >>> 16 & 0xFF);
        outputStream.write(n2 >>> 8 & 0xFF);
        outputStream.write(n2 & 0xFF);
        return 4;
    }

    public static final int readInt(DataInput dataInput) throws IOException {
        int n2 = dataInput.readUnsignedByte();
        if ((n2 & 0xFFFFFFC0) == 0) {
            return n2;
        }
        if ((n2 & 0x80) == 0) {
            return (n2 & 0x3F) << 8 | dataInput.readUnsignedByte();
        }
        return (n2 & 0x7F) << 24 | dataInput.readUnsignedByte() << 16 | dataInput.readUnsignedByte() << 8 | dataInput.readUnsignedByte();
    }

    public static final int readInt(InputStream inputStream) throws IOException {
        int n2 = InputStreamUtil.readUnsignedByte(inputStream);
        if ((n2 & 0xFFFFFFC0) == 0) {
            return n2;
        }
        if ((n2 & 0x80) == 0) {
            return (n2 & 0x3F) << 8 | InputStreamUtil.readUnsignedByte(inputStream);
        }
        return (n2 & 0x7F) << 24 | InputStreamUtil.readUnsignedByte(inputStream) << 16 | InputStreamUtil.readUnsignedByte(inputStream) << 8 | InputStreamUtil.readUnsignedByte(inputStream);
    }

    public static final int readInt(byte[] byArray, int n2) {
        byte by;
        if (((by = byArray[n2++]) & 0xFFFFFFC0) == 0) {
            return by;
        }
        if ((by & 0x80) == 0) {
            return (by & 0x3F) << 8 | byArray[n2] & 0xFF;
        }
        return (by & 0x7F) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
    }

    public static final int sizeInt(int n2) {
        if (n2 <= 63) {
            return 1;
        }
        if (n2 <= 16383) {
            return 2;
        }
        return 4;
    }

    public static final int writeLong(DataOutput dataOutput, long l2) throws IOException {
        if (l2 < 0L) {
            throw new IOException();
        }
        if (l2 <= 16383L) {
            dataOutput.writeByte((int)(l2 >>> 8 & 0xFFL));
            dataOutput.writeByte((int)(l2 & 0xFFL));
            return 2;
        }
        if (l2 <= 0x3FFFFFFFL) {
            dataOutput.writeByte((int)((l2 >>> 24 | 0x40L) & 0xFFL));
            dataOutput.writeByte((int)(l2 >>> 16 & 0xFFL));
            dataOutput.writeByte((int)(l2 >>> 8 & 0xFFL));
            dataOutput.writeByte((int)(l2 & 0xFFL));
            return 4;
        }
        dataOutput.writeByte((int)((l2 >>> 56 | 0x80L) & 0xFFL));
        dataOutput.writeByte((int)(l2 >>> 48 & 0xFFL));
        dataOutput.writeByte((int)(l2 >>> 40 & 0xFFL));
        dataOutput.writeByte((int)(l2 >>> 32 & 0xFFL));
        dataOutput.writeByte((int)(l2 >>> 24 & 0xFFL));
        dataOutput.writeByte((int)(l2 >>> 16 & 0xFFL));
        dataOutput.writeByte((int)(l2 >>> 8 & 0xFFL));
        dataOutput.writeByte((int)(l2 & 0xFFL));
        return 8;
    }

    public static final int writeLong(OutputStream outputStream, long l2) throws IOException {
        if (l2 < 0L) {
            throw new IOException();
        }
        if (l2 <= 16383L) {
            outputStream.write((int)(l2 >>> 8 & 0xFFL));
            outputStream.write((int)(l2 & 0xFFL));
            return 2;
        }
        if (l2 <= 0x3FFFFFFFL) {
            outputStream.write((int)((l2 >>> 24 | 0x40L) & 0xFFL));
            outputStream.write((int)(l2 >>> 16 & 0xFFL));
            outputStream.write((int)(l2 >>> 8 & 0xFFL));
            outputStream.write((int)(l2 & 0xFFL));
            return 4;
        }
        outputStream.write((int)((l2 >>> 56 | 0x80L) & 0xFFL));
        outputStream.write((int)(l2 >>> 48 & 0xFFL));
        outputStream.write((int)(l2 >>> 40 & 0xFFL));
        outputStream.write((int)(l2 >>> 32 & 0xFFL));
        outputStream.write((int)(l2 >>> 24 & 0xFFL));
        outputStream.write((int)(l2 >>> 16 & 0xFFL));
        outputStream.write((int)(l2 >>> 8 & 0xFFL));
        outputStream.write((int)(l2 & 0xFFL));
        return 8;
    }

    public static final long readLong(DataInput dataInput) throws IOException {
        int n2 = dataInput.readUnsignedByte();
        if ((n2 & 0xFFFFFFC0) == 0) {
            return n2 << 8 | dataInput.readUnsignedByte();
        }
        if ((n2 & 0x80) == 0) {
            return (n2 & 0x3F) << 24 | dataInput.readUnsignedByte() << 16 | dataInput.readUnsignedByte() << 8 | dataInput.readUnsignedByte();
        }
        return (long)(n2 & 0x7F) << 56 | (long)dataInput.readUnsignedByte() << 48 | (long)dataInput.readUnsignedByte() << 40 | (long)dataInput.readUnsignedByte() << 32 | (long)dataInput.readUnsignedByte() << 24 | (long)dataInput.readUnsignedByte() << 16 | (long)dataInput.readUnsignedByte() << 8 | (long)dataInput.readUnsignedByte();
    }

    public static final long readLong(InputStream inputStream) throws IOException {
        int n2 = InputStreamUtil.readUnsignedByte(inputStream);
        if ((n2 & 0xFFFFFFC0) == 0) {
            return n2 << 8 | InputStreamUtil.readUnsignedByte(inputStream);
        }
        if ((n2 & 0x80) == 0) {
            return (n2 & 0x3F) << 24 | InputStreamUtil.readUnsignedByte(inputStream) << 16 | InputStreamUtil.readUnsignedByte(inputStream) << 8 | InputStreamUtil.readUnsignedByte(inputStream);
        }
        long l2 = n2;
        return (l2 & 0x7FL) << 56 | (long)InputStreamUtil.readUnsignedByte(inputStream) << 48 | (long)InputStreamUtil.readUnsignedByte(inputStream) << 40 | (long)InputStreamUtil.readUnsignedByte(inputStream) << 32 | (long)InputStreamUtil.readUnsignedByte(inputStream) << 24 | (long)InputStreamUtil.readUnsignedByte(inputStream) << 16 | (long)InputStreamUtil.readUnsignedByte(inputStream) << 8 | (long)InputStreamUtil.readUnsignedByte(inputStream);
    }

    public static final long readLong(byte[] byArray, int n2) {
        byte by;
        if (((by = byArray[n2++]) & 0xFFFFFFC0) == 0) {
            return by << 8 | byArray[n2] & 0xFF;
        }
        if ((by & 0x80) == 0) {
            return (by & 0x3F) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
        }
        return (long)(by & 0x7F) << 56 | (long)(byArray[n2++] & 0xFF) << 48 | (long)(byArray[n2++] & 0xFF) << 40 | (long)(byArray[n2++] & 0xFF) << 32 | (long)(byArray[n2++] & 0xFF) << 24 | (long)(byArray[n2++] & 0xFF) << 16 | (long)(byArray[n2++] & 0xFF) << 8 | (long)(byArray[n2] & 0xFF);
    }

    public static final int sizeLong(long l2) {
        if (l2 <= 16383L) {
            return 2;
        }
        if (l2 <= 0x3FFFFFFFL) {
            return 4;
        }
        return 8;
    }
}

