/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.info;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public final class ProductVersionHolder
implements PrivilegedAction<Properties> {
    private static final int BAD_NUMBER = -1;
    private static final String ALPHA = "alpha";
    private static final String BETA = "beta";
    public static final int MAINT_ENCODING = 1000000;
    private String productVendorName;
    private String productName;
    private String productTechnologyName;
    private int majorVersion = -1;
    private int minorVersion = -1;
    private int maintVersion = -1;
    private int drdaMaintVersion = -1;
    private String buildNumber = "????";
    private Boolean isBeta;
    private String productGenus;

    private ProductVersionHolder() {
    }

    private ProductVersionHolder(String string, String string2, String string3, int n2, int n3, int n4, int n5, String string4, Boolean bl) {
        if (string != null) {
            this.productVendorName = string.trim();
        }
        if (string2 != null) {
            this.productName = string2.trim();
        }
        if (string3 != null) {
            this.productTechnologyName = string3.trim();
        }
        this.majorVersion = n2;
        this.minorVersion = n3;
        this.maintVersion = n4;
        this.drdaMaintVersion = n5;
        this.buildNumber = string4;
        this.isBeta = bl;
    }

    public static ProductVersionHolder getProductVersionHolder(String string, String string2, String string3, int n2, int n3, int n4, int n5, String string4, Boolean bl) {
        ProductVersionHolder productVersionHolder = new ProductVersionHolder(string, string2, string3, n2, n3, n4, n5, string4, bl);
        return productVersionHolder;
    }

    public static ProductVersionHolder getProductVersionHolderFromMyEnv(String string) {
        ProductVersionHolder productVersionHolder = new ProductVersionHolder();
        productVersionHolder.productGenus = string;
        Properties properties = AccessController.doPrivileged(productVersionHolder);
        if (properties == null) {
            return null;
        }
        return ProductVersionHolder.getProductVersionHolder(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProductVersionHolder getProductVersionHolderFromMyEnv(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            System.out.println("IOE " + iOException.getMessage());
            ProductVersionHolder productVersionHolder = null;
            return productVersionHolder;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return ProductVersionHolder.getProductVersionHolder(properties);
    }

    public static ProductVersionHolder getProductVersionHolder(Properties properties) {
        String string = properties.getProperty("derby.product.vendor");
        String string2 = properties.getProperty("derby.product.external.name");
        String string3 = properties.getProperty("derby.product.technology.name");
        int n2 = ProductVersionHolder.parseInt(properties.getProperty("derby.version.major"));
        int n3 = ProductVersionHolder.parseInt(properties.getProperty("derby.version.minor"));
        int n4 = ProductVersionHolder.parseInt(properties.getProperty("derby.version.maint"));
        int n5 = ProductVersionHolder.parseInt(properties.getProperty("derby.version.drdamaint"));
        String string4 = properties.getProperty("derby.build.number");
        Boolean bl = Boolean.valueOf(properties.getProperty("derby.version.beta"));
        return ProductVersionHolder.getProductVersionHolder(string, string2, string3, n2, n3, n4, n5, string4, bl);
    }

    public String getProductVendorName() {
        return this.productVendorName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductTechnologyName() {
        return this.productTechnologyName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMaintVersion() {
        return this.maintVersion;
    }

    public int getDrdaMaintVersion() {
        return this.drdaMaintVersion;
    }

    public int getFixPackVersion() {
        return this.maintVersion / 1000000;
    }

    public boolean isBeta() {
        return this.isBeta;
    }

    public boolean isAlpha() {
        return this.majorVersion >= 5 && this.minorVersion > 2 && this.maintVersion / 1000000 == 0;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public int getBuildNumberAsInt() {
        if (this.buildNumber == null) {
            return -1;
        }
        boolean bl = false;
        int n2 = this.buildNumber.indexOf(77);
        if (n2 == -1) {
            n2 = this.buildNumber.indexOf(58);
        } else {
            bl = true;
        }
        if (n2 == -1) {
            n2 = this.buildNumber.length();
        } else {
            bl = true;
        }
        try {
            int n3 = Integer.parseInt(this.buildNumber.substring(0, n2));
            if (bl) {
                n3 = -n3;
            }
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private static int parseInt(String string) {
        int n2 = -1;
        try {
            if (string != null) {
                n2 = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (n2 < 0) {
            n2 = -1;
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getProductVendorName());
        stringBuffer.append(" - ");
        stringBuffer.append(this.getProductName());
        stringBuffer.append(" - ");
        stringBuffer.append(this.getVersionBuildString(true));
        return stringBuffer.toString();
    }

    public String getSimpleVersionString() {
        return ProductVersionHolder.simpleVersionString(this.majorVersion, this.minorVersion, this.isBeta());
    }

    public static String simpleVersionString(int n2, int n3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2);
        stringBuffer.append('.');
        stringBuffer.append(n3);
        if (bl) {
            stringBuffer.append(' ');
            stringBuffer.append(BETA);
        }
        return stringBuffer.toString();
    }

    public static String fullVersionString(int n2, int n3, int n4, boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n2);
        stringBuffer.append('.');
        stringBuffer.append(n3);
        stringBuffer.append('.');
        String string2 = null;
        if (n2 == 5 && n3 <= 2 && n4 < 1000000) {
            stringBuffer.append(n4);
            if (bl) {
                string2 = BETA;
            }
        } else {
            int n5 = n4 / 1000000;
            int n6 = n4 % 1000000;
            stringBuffer.append(n5);
            stringBuffer.append('.');
            stringBuffer.append(n6);
            if (n5 == 0) {
                string2 = ALPHA;
            } else if (bl) {
                string2 = BETA;
            }
        }
        if (string2 != null) {
            stringBuffer.append(' ');
            stringBuffer.append(string2);
        }
        if (string != null) {
            stringBuffer.append(" - (");
            stringBuffer.append(string);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public String getVersionBuildString(boolean bl) {
        return ProductVersionHolder.fullVersionString(this.majorVersion, this.minorVersion, this.maintVersion, this.isBeta(), bl ? this.buildNumber : null);
    }

    @Override
    public final Properties run() {
        return this.loadProperties(this.productGenus);
    }

    private Properties loadProperties(String string) {
        String string2 = "/org/apache/derby/info/" + string + ".properties";
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        if (inputStream == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            return properties;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

