/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.derby.iapi.jdbc.BrokeredStatementControl;
import org.apache.derby.iapi.jdbc.EngineStatement;
import org.apache.derby.iapi.jdbc.ExceptionFactory;

public class BrokeredStatement
implements EngineStatement {
    final BrokeredStatementControl control;
    final int resultSetType;
    final int resultSetConcurrency;
    final int resultSetHoldability;
    private String cursorName;
    private Boolean escapeProcessing;

    BrokeredStatement(BrokeredStatementControl brokeredStatementControl) throws SQLException {
        this.control = brokeredStatementControl;
        this.resultSetType = this.getResultSetType();
        this.resultSetConcurrency = this.getResultSetConcurrency();
        this.resultSetHoldability = this.getResultSetHoldability();
    }

    @Override
    public final void addBatch(String string) throws SQLException {
        this.getStatement().addBatch(string);
    }

    @Override
    public final void clearBatch() throws SQLException {
        this.getStatement().clearBatch();
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        return this.getStatement().executeBatch();
    }

    @Override
    public final void cancel() throws SQLException {
        this.getStatement().cancel();
    }

    @Override
    public final boolean execute(String string) throws SQLException {
        return this.getStatement().execute(string);
    }

    @Override
    public final ResultSet executeQuery(String string) throws SQLException {
        return this.wrapResultSet(this.getStatement().executeQuery(string));
    }

    @Override
    public final int executeUpdate(String string) throws SQLException {
        return this.getStatement().executeUpdate(string);
    }

    @Override
    public void close() throws SQLException {
        this.control.closeRealStatement();
    }

    @Override
    public final Connection getConnection() throws SQLException {
        return this.getStatement().getConnection();
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        return this.getStatement().getFetchDirection();
    }

    @Override
    public final int getFetchSize() throws SQLException {
        return this.getStatement().getFetchSize();
    }

    @Override
    public final int getMaxFieldSize() throws SQLException {
        return this.getStatement().getMaxFieldSize();
    }

    @Override
    public final int getMaxRows() throws SQLException {
        return this.getStatement().getMaxRows();
    }

    @Override
    public final int getResultSetConcurrency() throws SQLException {
        return this.getStatement().getResultSetConcurrency();
    }

    @Override
    public final void setMaxFieldSize(int n2) throws SQLException {
        this.getStatement().setMaxFieldSize(n2);
    }

    @Override
    public final void setMaxRows(int n2) throws SQLException {
        this.getStatement().setMaxRows(n2);
    }

    @Override
    public final void setEscapeProcessing(boolean bl) throws SQLException {
        this.getStatement().setEscapeProcessing(bl);
        this.escapeProcessing = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.getStatement().getWarnings();
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.getStatement().clearWarnings();
    }

    @Override
    public final void setCursorName(String string) throws SQLException {
        this.getStatement().setCursorName(string);
        this.cursorName = string;
    }

    @Override
    public final ResultSet getResultSet() throws SQLException {
        return this.wrapResultSet(this.getStatement().getResultSet());
    }

    @Override
    public final int getUpdateCount() throws SQLException {
        return this.getStatement().getUpdateCount();
    }

    @Override
    public final boolean getMoreResults() throws SQLException {
        return this.getStatement().getMoreResults();
    }

    @Override
    public final int getResultSetType() throws SQLException {
        return this.getStatement().getResultSetType();
    }

    @Override
    public final void setFetchDirection(int n2) throws SQLException {
        this.getStatement().setFetchDirection(n2);
    }

    @Override
    public final void setFetchSize(int n2) throws SQLException {
        this.getStatement().setFetchSize(n2);
    }

    @Override
    public final int getQueryTimeout() throws SQLException {
        return this.getStatement().getQueryTimeout();
    }

    @Override
    public final void setQueryTimeout(int n2) throws SQLException {
        this.getStatement().setQueryTimeout(n2);
    }

    @Override
    public final boolean execute(String string, int n2) throws SQLException {
        return this.getStatement().execute(string, n2);
    }

    @Override
    public final boolean execute(String string, int[] nArray) throws SQLException {
        return this.getStatement().execute(string, nArray);
    }

    @Override
    public final boolean execute(String string, String[] stringArray) throws SQLException {
        return this.getStatement().execute(string, stringArray);
    }

    @Override
    public final int executeUpdate(String string, int n2) throws SQLException {
        int n3 = this.getStatement().executeUpdate(string, n2);
        return n3;
    }

    @Override
    public final int executeUpdate(String string, int[] nArray) throws SQLException {
        return this.getStatement().executeUpdate(string, nArray);
    }

    @Override
    public final int executeUpdate(String string, String[] stringArray) throws SQLException {
        return this.getStatement().executeUpdate(string, stringArray);
    }

    @Override
    public final boolean getMoreResults(int n2) throws SQLException {
        return this.getStatement().getMoreResults(n2);
    }

    @Override
    public final ResultSet getGeneratedKeys() throws SQLException {
        return this.wrapResultSet(this.getStatement().getGeneratedKeys());
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        int n2 = this.getStatement().getResultSetHoldability();
        return this.controlCheck().checkHoldCursors(n2);
    }

    public Statement createDuplicateStatement(Connection connection, Statement statement) throws SQLException {
        Statement statement2 = connection.createStatement(this.resultSetType, this.resultSetConcurrency, this.resultSetHoldability);
        this.setStatementState(statement, statement2);
        return statement2;
    }

    void setStatementState(Statement statement, Statement statement2) throws SQLException {
        if (this.cursorName != null) {
            statement2.setCursorName(this.cursorName);
        }
        if (this.escapeProcessing != null) {
            statement2.setEscapeProcessing(this.escapeProcessing);
        }
        statement2.setFetchDirection(statement.getFetchDirection());
        statement2.setFetchSize(statement.getFetchSize());
        statement2.setMaxFieldSize(statement.getMaxFieldSize());
        statement2.setMaxRows(statement.getMaxRows());
        statement2.setQueryTimeout(statement.getQueryTimeout());
    }

    public Statement getStatement() throws SQLException {
        return this.control.getRealStatement();
    }

    final ResultSet wrapResultSet(ResultSet resultSet) {
        return this.control.wrapResultSet(this, resultSet);
    }

    final BrokeredStatementControl controlCheck() throws SQLException {
        this.getStatement().getConnection();
        return this.control;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        this.checkIfClosed();
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.checkIfClosed();
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw this.unableToUnwrap(clazz);
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.getStatement().isClosed();
    }

    protected final void checkIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw ExceptionFactory.getInstance().getSQLException("XJ012.S", null, null, "Statement");
        }
    }

    final SQLException unableToUnwrap(Class clazz) {
        return ExceptionFactory.getInstance().getSQLException("XJ128.S", null, null, clazz);
    }

    @Override
    public final boolean isPoolable() throws SQLException {
        return this.getStatement().isPoolable();
    }

    @Override
    public final void setPoolable(boolean bl) throws SQLException {
        this.getStatement().setPoolable(bl);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        ((EngineStatement)this.getStatement()).closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return ((EngineStatement)this.getStatement()).isCloseOnCompletion();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeUpdate(string);
    }

    @Override
    public long executeLargeUpdate(String string, int n2) throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeUpdate(string, n2);
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeUpdate(string, nArray);
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        return ((EngineStatement)this.getStatement()).executeLargeUpdate(string, stringArray);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return ((EngineStatement)this.getStatement()).getLargeMaxRows();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return ((EngineStatement)this.getStatement()).getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long l2) throws SQLException {
        ((EngineStatement)this.getStatement()).setLargeMaxRows(l2);
    }
}

