/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.diag.DiagUtil;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.vti.VTICosting;
import org.apache.derby.vti.VTIEnvironment;
import org.apache.derby.vti.VTITemplate;

public class TransactionTable
extends VTITemplate
implements VTICosting {
    private TransactionInfo[] transactionTable;
    boolean initialized;
    int currentRow;
    private boolean wasNull;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("XID", 12, false, 15), EmbedResultSetMetaData.getResultColumnDescriptor("GLOBAL_XID", 12, true, 140), EmbedResultSetMetaData.getResultColumnDescriptor("USERNAME", 12, true, 128), EmbedResultSetMetaData.getResultColumnDescriptor("TYPE", 12, false, 30), EmbedResultSetMetaData.getResultColumnDescriptor("STATUS", 12, false, 8), EmbedResultSetMetaData.getResultColumnDescriptor("FIRST_INSTANT", 12, true, 20), EmbedResultSetMetaData.getResultColumnDescriptor("SQL_TEXT", 12, true, 32672)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public TransactionTable() throws StandardException {
        DiagUtil.checkAccess();
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    @Override
    public boolean next() throws SQLException {
        Object object;
        if (!this.initialized) {
            object = ConnectionUtil.getCurrentLCC();
            this.transactionTable = object.getTransactionExecute().getAccessManager().getTransactionInfo();
            this.initialized = true;
            this.currentRow = -1;
        }
        if (this.transactionTable == null) {
            return false;
        }
        ++this.currentRow;
        while (this.currentRow < this.transactionTable.length) {
            object = this.transactionTable[this.currentRow];
            if (object != null) {
                return true;
            }
            ++this.currentRow;
        }
        this.transactionTable = null;
        return false;
    }

    @Override
    public void close() {
        this.transactionTable = null;
    }

    @Override
    public String getString(int n2) {
        TransactionInfo transactionInfo = this.transactionTable[this.currentRow];
        String string = null;
        switch (n2) {
            case 1: {
                string = transactionInfo.getTransactionIdString();
                break;
            }
            case 2: {
                string = transactionInfo.getGlobalTransactionIdString();
                break;
            }
            case 3: {
                string = transactionInfo.getUsernameString();
                break;
            }
            case 4: {
                string = transactionInfo.getTransactionTypeString();
                break;
            }
            case 5: {
                string = transactionInfo.getTransactionStatusString();
                break;
            }
            case 6: {
                string = transactionInfo.getFirstLogInstantString();
                break;
            }
            case 7: {
                string = transactionInfo.getStatementTextString();
                string = StringUtil.truncate(string, 32672);
                break;
            }
            default: {
                string = null;
            }
        }
        this.wasNull = string == null;
        return string;
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public double getEstimatedRowCount(VTIEnvironment vTIEnvironment) {
        return 10000.0;
    }

    @Override
    public double getEstimatedCostPerInstantiation(VTIEnvironment vTIEnvironment) {
        return 100000.0;
    }

    @Override
    public boolean supportsMultipleInstantiations(VTIEnvironment vTIEnvironment) {
        return false;
    }
}

