/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.derby.client.ClientXid;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.am.XaException;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetXACallInfo;
import org.apache.derby.client.net.NetXAConnection;

public class NetXAResource
implements XAResource {
    private static final int INITIAL_CALLINFO_ELEMENTS = 1;
    static final ClientXid nullXid = new ClientXid();
    static final int XAFUNC_COMMIT = 1;
    private static final int XAFUNC_END = 2;
    private static final int XAFUNC_FORGET = 3;
    private static final int XAFUNC_PREPARE = 4;
    private static final int XAFUNC_RECOVER = 5;
    static final int XAFUNC_ROLLBACK = 6;
    private static final int XAFUNC_START = 7;
    private static final String XAFUNCSTR_NONE = "No XA Function";
    private static final String XAFUNCSTR_COMMIT = "XAResource.commit()";
    private static final String XAFUNCSTR_END = "XAResource.end()";
    private static final String XAFUNCSTR_FORGET = "XAResource.forget()";
    private static final String XAFUNCSTR_PREPARE = "XAResource.prepare()";
    private static final String XAFUNCSTR_RECOVER = "XAResource.recover()";
    private static final String XAFUNCSTR_ROLLBACK = "XAResource.rollback()";
    private static final String XAFUNCSTR_START = "XAResource.start()";
    SqlException exceptionsOnXA = null;
    NetXAConnection netXAConn_;
    NetConnection conn_;
    private boolean keepIsolationLevel;
    NetXACallInfo[] callInfoArray_ = new NetXACallInfo[1];
    private int timeoutSeconds = 0;

    public NetXAResource(XAConnection xAConnection, NetXAConnection netXAConnection) {
        this.conn_ = netXAConnection.getNetConnection();
        this.netXAConn_ = netXAConnection;
        netXAConnection.setNetXAResource(this);
        this.conn_.currXACallInfoOffset_ = 0;
        for (int i2 = 0; i2 < 1; ++i2) {
            this.callInfoArray_[i2] = new NetXACallInfo(null, 0, null);
        }
        this.callInfoArray_[0].actualConn_ = netXAConnection;
        this.callInfoArray_[0].saveConnectionVariables();
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int n2 = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "commit", xid, bl);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.xaFlags_ = bl ? 0x40000000 : 0;
        netXACallInfo.xid_ = xid;
        netXACallInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaCommit(this.conn_, xid);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaCommit(this.conn_);
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 1;
                n2 = this.xaRetValErrorAccumSQL(netXACallInfo, n2);
                netXACallInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
        }
        catch (SqlException sqlException) {
            n2 = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        if (n2 != 0) {
            this.throwXAException(n2);
        }
    }

    private int getSqlExceptionXAErrorCode(SqlException sqlException) {
        int n2 = sqlException.getErrorCode();
        return n2 == 40000 ? -7 : -3;
    }

    @Override
    public void end(Xid xid, int n2) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int n3 = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "end", xid, n2);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.xaFlags_ = n2;
        netXACallInfo.xid_ = xid;
        netXACallInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaEndUnitOfWork(this.conn_);
            netAgent.flowOutsideUOW();
            n3 = netAgent.netConnectionReply_.readXaEndUnitOfWork(this.conn_);
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 2;
                n3 = this.xaRetValErrorAccumSQL(netXACallInfo, n3);
                netXACallInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
        }
        catch (SqlException sqlException) {
            n3 = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        if (n3 != 0) {
            this.throwXAException(n3);
        } else {
            this.conn_.setXAState(0);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int n2 = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "forget", xid);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.xid_ = xid;
        netXACallInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaForget(netAgent.netConnection_, xid);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaForget(netAgent.netConnection_);
            netAgent.endReadChain();
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 3;
                n2 = this.xaRetValErrorAccumSQL(netXACallInfo, n2);
                netXACallInfo.xaRetVal_ = 0;
            }
        }
        catch (SqlException sqlException) {
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
            this.throwXAException(this.getSqlExceptionXAErrorCode(sqlException));
        }
        if (n2 != 0) {
            this.throwXAException(n2);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "getTransactionTimeout", new Object[0]);
        }
        this.exceptionsOnXA = null;
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "getTransactionTimeout", this.timeoutSeconds);
        }
        return this.timeoutSeconds;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "prepare", xid);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetAgent netAgent = this.conn_.netAgent_;
        int n2 = 0;
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.xid_ = xid;
        netXACallInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaPrepare(this.conn_);
            netAgent.flowOutsideUOW();
            n2 = netAgent.netConnectionReply_.readXaPrepare(this.conn_);
            if (netXACallInfo.xaRetVal_ != 0 && netXACallInfo.xaRetVal_ != 3) {
                netXACallInfo.xaFunction_ = 4;
                n2 = this.xaRetValErrorAccumSQL(netXACallInfo, n2);
                netXACallInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
        }
        catch (SqlException sqlException) {
            n2 = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        if (n2 != 0 && n2 != 3) {
            this.throwXAException(n2);
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "prepare", n2);
        }
        return n2;
    }

    @Override
    public Xid[] recover(int n2) throws XAException {
        int n3 = 0;
        NetAgent netAgent = this.conn_.netAgent_;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "recover", n2);
        }
        this.exceptionsOnXA = null;
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        Xid[] xidArray = null;
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.xaFlags_ = n2;
        netXACallInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaRecover(this.conn_, n2);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaRecover(this.conn_);
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 5;
                n3 = this.xaRetValErrorAccumSQL(netXACallInfo, n3);
                netXACallInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
            xidArray = this.conn_.getIndoubtTransactionIds();
        }
        catch (SqlException sqlException) {
            n3 = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        if (n3 != 0) {
            this.throwXAException(n3);
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "recover", xidArray);
        }
        return xidArray;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int n2 = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "rollback", xid);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.xid_ = xid;
        netXACallInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaRollback(this.conn_, xid);
            netAgent.flowOutsideUOW();
            n2 = netAgent.netConnectionReply_.readXaRollback(this.conn_);
            netAgent.endReadChain();
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 2;
                n2 = this.xaRetValErrorAccumSQL(netXACallInfo, n2);
                netXACallInfo.xaRetVal_ = 0;
            }
        }
        catch (SqlException sqlException) {
            n2 = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        if (n2 != 0) {
            this.throwXAException(n2);
        }
    }

    @Override
    public boolean setTransactionTimeout(int n2) throws XAException {
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "setTransactionTimeout", new Object[0]);
        }
        if (n2 < 0) {
            throw new XAException(-5);
        }
        this.exceptionsOnXA = null;
        this.timeoutSeconds = n2;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "setTransactionTimeout", true);
        }
        return true;
    }

    public void setKeepCurrentIsolationLevel(boolean bl) {
        this.keepIsolationLevel = bl;
    }

    public boolean keepCurrentIsolationLevel() {
        return this.keepIsolationLevel;
    }

    @Override
    public synchronized void start(Xid xid, int n2) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int n3 = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "start", xid, n2);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        try {
            if (this.conn_.autoCommit_) {
                this.conn_.flowAutoCommit();
            }
        }
        catch (SqlException sqlException) {
            n3 = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.xaFlags_ = n2;
        netXACallInfo.xid_ = xid;
        netXACallInfo.xaRetVal_ = 0;
        if (n2 == 0) {
            if (this.timeoutSeconds == Integer.MAX_VALUE) {
                netXACallInfo.xaTimeoutMillis_ = 0L;
            } else if (this.timeoutSeconds > 0) {
                netXACallInfo.xaTimeoutMillis_ = 1000 * this.timeoutSeconds;
            } else if (this.timeoutSeconds == 0) {
                netXACallInfo.xaTimeoutMillis_ = -1L;
            } else {
                this.throwXAException(-3);
            }
        }
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaStartUnitOfWork(this.conn_);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaStartUnitOfWork(this.conn_);
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 7;
                n3 = this.xaRetValErrorAccumSQL(netXACallInfo, n3);
                netXACallInfo.xaRetVal_ = 0;
            }
            if (n3 == 0) {
                this.conn_.setXAState(1);
            }
        }
        catch (SqlException sqlException) {
            n3 = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        if (n3 != 0) {
            this.throwXAException(n3);
        }
    }

    private String getXAExceptionText(int n2) {
        String string;
        switch (n2) {
            case 100: {
                string = "XA_RBROLLBACK";
                break;
            }
            case 101: {
                string = "XA_RBCOMMFAIL";
                break;
            }
            case 102: {
                string = "XA_RBDEADLOCK";
                break;
            }
            case 103: {
                string = "XA_RBINTEGRITY";
                break;
            }
            case 104: {
                string = "XA_RBOTHER";
                break;
            }
            case 105: {
                string = "XA_RBPROTO";
                break;
            }
            case 106: {
                string = "XA_RBTIMEOUT";
                break;
            }
            case 107: {
                string = "XA_RBTRANSIENT";
                break;
            }
            case 9: {
                string = "XA_NOMIGRATE";
                break;
            }
            case 8: {
                string = "XA_HEURHAZ";
                break;
            }
            case 7: {
                string = "XA_HEURCOM";
                break;
            }
            case 6: {
                string = "XA_HEURRB";
                break;
            }
            case 5: {
                string = "XA_HEURMIX";
                break;
            }
            case 4: {
                string = "XA_RETRY";
                break;
            }
            case 3: {
                string = "XA_RDONLY";
                break;
            }
            case -2: {
                string = "XAER_ASYNC";
                break;
            }
            case -3: {
                string = "XAER_RMERR";
                break;
            }
            case -4: {
                string = "XAER_NOTA";
                break;
            }
            case -5: {
                string = "XAER_INVAL";
                break;
            }
            case -6: {
                string = "XAER_PROTO";
                break;
            }
            case -7: {
                string = "XAER_RMFAIL";
                break;
            }
            case -8: {
                string = "XAER_DUPID";
                break;
            }
            case -9: {
                string = "XAER_OUTSIDE";
                break;
            }
            case 0: {
                string = "XA_OK";
                break;
            }
            default: {
                string = "Unknown Error";
            }
        }
        return string;
    }

    private void throwXAException(int n2) throws XAException {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getXAExceptionText(n2));
        SqlException sqlException = this.exceptionsOnXA;
        while (this.exceptionsOnXA != null) {
            stringBuilder.append(" : ").append(this.exceptionsOnXA.getMessage());
            this.exceptionsOnXA = this.exceptionsOnXA.getNextException();
        }
        XaException xaException = new XaException(this.conn_.agent_.logWriter_, sqlException, stringBuilder.toString());
        xaException.errorCode = n2;
        this.setXaStateForXAException(n2);
        throw xaException;
    }

    private void setXaStateForXAException(int n2) {
        switch (n2) {
            case -7: 
            case -3: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                this.conn_.setXAState(0);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl = false;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "isSameRM", xAResource);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        if (xAResource instanceof NetXAResource) {
            NetXAResource netXAResource = (NetXAResource)xAResource;
            if (this.conn_.databaseName_.equalsIgnoreCase(netXAResource.conn_.databaseName_)) {
                if (!this.conn_.netAgent_.server_.equalsIgnoreCase(netXAResource.conn_.netAgent_.server_)) {
                    try {
                        String string = this.processLocalHost(this.conn_.netAgent_.server_);
                        String string2 = this.processLocalHost(netXAResource.conn_.netAgent_.server_);
                        InetAddress inetAddress = InetAddress.getByName(string);
                        InetAddress inetAddress2 = InetAddress.getByName(string2);
                        if (!inetAddress.equals(inetAddress2)) {
                        }
                    }
                    catch (UnknownHostException unknownHostException) {}
                } else if (this.conn_.netAgent_.port_ == netXAResource.conn_.netAgent_.port_) {
                    bl = true;
                }
            }
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "isSameRM", bl);
        }
        return bl;
    }

    public static boolean xidsEqual(Xid xid, Xid xid2) {
        int n2;
        if (xid.getFormatId() != xid2.getFormatId()) {
            return false;
        }
        int n3 = xid.getGlobalTransactionId().length;
        if (n3 != xid2.getGlobalTransactionId().length) {
            return false;
        }
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid2.getGlobalTransactionId();
        for (n2 = 0; n2 < n3; ++n2) {
            if (byArray[n2] == byArray2[n2]) continue;
            return false;
        }
        n3 = xid.getBranchQualifier().length;
        if (n3 != xid2.getBranchQualifier().length) {
            return false;
        }
        byArray = xid.getBranchQualifier();
        byArray2 = xid2.getBranchQualifier();
        for (n2 = 0; n2 < n3; ++n2) {
            if (byArray[n2] == byArray2[n2]) continue;
            return false;
        }
        return true;
    }

    private void connectionClosedFailure() throws XAException {
        this.exceptionsOnXA = Utils.accumulateSQLException(new SqlException(null, new ClientMessageId("08003"), new Object[0]), this.exceptionsOnXA);
        this.throwXAException(-7);
    }

    private String getXAFuncStr(int n2) {
        switch (n2) {
            case 1: {
                return XAFUNCSTR_COMMIT;
            }
            case 2: {
                return XAFUNCSTR_END;
            }
            case 3: {
                return XAFUNCSTR_FORGET;
            }
            case 4: {
                return XAFUNCSTR_PREPARE;
            }
            case 5: {
                return XAFUNCSTR_RECOVER;
            }
            case 6: {
                return XAFUNCSTR_ROLLBACK;
            }
            case 7: {
                return XAFUNCSTR_START;
            }
        }
        return XAFUNCSTR_NONE;
    }

    protected int xaRetValErrorAccumSQL(NetXACallInfo netXACallInfo, int n2) {
        int n3 = netXACallInfo.xaRetVal_;
        if (n3 != 0) {
            SqlException sqlException = new SqlException(this.conn_.netAgent_.logWriter_, new ClientMessageId("XN019.S"), SqlCode.queuedXAError, this.getXAFuncStr(netXACallInfo.xaFunction_), this.getXAExceptionText(n3));
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
            if (n2 != 0 && n2 < 0) {
                return n2;
            }
        }
        return n3;
    }

    private String processLocalHost(String string) {
        if (string.equalsIgnoreCase("localhost")) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                String string2 = inetAddress.getHostName();
                return string2;
            }
            catch (SecurityException securityException) {
                return string;
            }
            catch (UnknownHostException unknownHostException) {
                return string;
            }
        }
        return string;
    }
}

