/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import javax.transaction.xa.Xid;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetResultSetRequest;
import org.apache.derby.client.net.NetXACallInfo;

class NetXAConnectionRequest
extends NetResultSetRequest {
    NetXAConnectionRequest(NetAgent netAgent, int n2) {
        super(netAgent, n2);
    }

    @Override
    public void writeLocalXACommit(NetConnection netConnection) throws SqlException {
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        Xid xid = netXACallInfo.xid_;
        this.buildSYNCCTLMigrate();
        this.buildSYNCCTLCommit(0x10000000, xid);
    }

    @Override
    public void writeLocalXARollback(NetConnection netConnection) throws SqlException {
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        this.buildSYNCCTLRollback(0x10000000);
    }

    @Override
    public void writeXaStartUnitOfWork(NetConnection netConnection) throws SqlException {
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        Xid xid = netXACallInfo.xid_;
        int n2 = netXACallInfo.xaFlags_;
        long l2 = netXACallInfo.xaTimeoutMillis_;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 9);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, n2);
        if (l2 >= 0L && n2 == 0) {
            this.writeXATimeout(6407, l2);
        }
        this.updateLengthBytes();
    }

    @Override
    public void writeXaEndUnitOfWork(NetConnection netConnection) throws SqlException {
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        Xid xid = netXACallInfo.xid_;
        int n2 = netXACallInfo.xaFlags_;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 11);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, n2);
        this.updateLengthBytes();
    }

    @Override
    protected void writeXaPrepare(NetConnection netConnection) throws SqlException {
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        Xid xid = netXACallInfo.xid_;
        int n2 = 0;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 1);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, n2);
        this.updateLengthBytes();
    }

    @Override
    protected void writeXaCommit(NetConnection netConnection, Xid xid) throws SqlException {
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        int n2 = netXACallInfo.xaFlags_;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 3);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, n2);
        this.updateLengthBytes();
    }

    @Override
    protected void writeXaRollback(NetConnection netConnection, Xid xid) throws SqlException {
        int n2 = 0;
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 4);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, n2);
        this.updateLengthBytes();
    }

    @Override
    protected void writeXaRecover(NetConnection netConnection, int n2) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 12);
        this.writeXAFlags(6403, n2);
        this.updateLengthBytes();
    }

    @Override
    protected void writeXaForget(NetConnection netConnection, Xid xid) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 6);
        this.writeXID(6145, xid);
        this.updateLengthBytes();
    }

    @Override
    public void writeSYNCType(int n2, int n3) {
        this.writeScalar1Byte(n2, n3);
    }

    @Override
    public void writeForget(int n2, int n3) {
        this.writeScalar1Byte(n2, n3);
    }

    @Override
    public void writeReleaseConversation(int n2, int n3) {
        this.writeScalar1Byte(n2, n3);
    }

    @Override
    void writeNullXID(int n2) {
        int n3 = -1;
        this.writeScalar4Bytes(n2, n3);
    }

    @Override
    void writeXID(int n2, Xid xid) throws SqlException {
        int n3 = 0;
        int n4 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        this.markLengthBytes(n2);
        n3 = 4;
        n3 += byArray2.length + 4;
        n3 += byArray.length + 4;
        this.write4Bytes(n4);
        this.write4Bytes(byArray.length);
        this.write4Bytes(byArray2.length);
        this.writeBytes(byArray);
        this.writeBytes(byArray2);
        this.updateLengthBytes();
    }

    @Override
    void writeXAFlags(int n2, int n3) {
        this.writeScalar4Bytes(n2, n3);
    }

    @Override
    void writeXATimeout(int n2, long l2) {
        this.writeScalar8Bytes(n2, l2);
    }

    @Override
    void buildSYNCCTLMigrate() throws SqlException {
    }

    @Override
    void buildSYNCCTLCommit(int n2, Xid xid) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 3);
        if (xid.getFormatId() != -1) {
            this.writeXID(6145, xid);
        } else {
            this.writeNullXID(6145);
        }
        this.writeXAFlags(6403, n2);
        this.updateLengthBytes();
    }

    @Override
    void buildSYNCCTLRollback(int n2) throws SqlException {
        this.createCommand();
        this.markLengthBytes(4181);
        this.writeSYNCType(4487, 4);
        this.writeNullXID(6145);
        this.writeXAFlags(6403, n2);
        this.updateLengthBytes();
    }
}

