/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.xa.Xid;
import org.apache.derby.client.ClientXid;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetResultSetReply;
import org.apache.derby.client.net.NetXACallInfo;

class NetXAConnectionReply
extends NetResultSetReply {
    NetXAConnectionReply(NetAgent netAgent, int n2) {
        super(netAgent, n2);
    }

    @Override
    public void readLocalXAStart(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
    }

    @Override
    public void readLocalXACommit(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(connectionCallbackInterface);
        this.endOfSameIdChainData();
        NetXACallInfo netXACallInfo = this.netAgent_.netConnection_.xares_.callInfoArray_[this.netAgent_.netConnection_.currXACallInfoOffset_];
        connectionCallbackInterface.completeLocalCommit();
    }

    @Override
    public void readLocalXARollback(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(connectionCallbackInterface);
        this.endOfSameIdChainData();
        connectionCallbackInterface.completeLocalRollback();
    }

    @Override
    void readXaStartUnitOfWork(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        boolean bl = netXACallInfo.xaFlags_ == 0x200000 || netXACallInfo.xaFlags_ == 0x8000000;
        netConnection.xares_.setKeepCurrentIsolationLevel(bl);
        this.endOfSameIdChainData();
    }

    @Override
    int readXaEndUnitOfWork(NetConnection netConnection) throws DisconnectException {
        netConnection.xares_.setKeepCurrentIsolationLevel(false);
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        int n2 = netXACallInfo.xaFlags_;
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
        if (n2 == 0x20000000) {
            return 100;
        }
        return 0;
    }

    @Override
    int readXaPrepare(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        int n2 = this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
        return n2;
    }

    @Override
    void readXaCommit(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        netConnection.completeLocalCommit();
    }

    @Override
    int readXaRollback(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        netConnection.completeLocalRollback();
        return 0;
    }

    @Override
    void readXaRecover(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
    }

    @Override
    void readXaForget(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
    }

    @Override
    int parseSYNCCRD(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        boolean bl = false;
        int n2 = CodePoint.SVRCOD_INFO;
        int n3 = 0;
        byte by = 0;
        NetConnection netConnection = this.netAgent_.netConnection_;
        this.parseLengthAndMatchCodePoint(4680);
        this.pushLengthOnCollectionStack();
        int n4 = this.peekCodePoint();
        while (n4 != -1) {
            boolean bl2 = false;
            if (n4 == 4425) {
                bl2 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n2 = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n4 = this.peekCodePoint();
            }
            if (n4 == 6404) {
                bl2 = true;
                netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_].xaRetVal_ = n3 = this.parseXARETVAL();
                n4 = this.peekCodePoint();
            }
            if (n4 == 4487) {
                bl2 = true;
                by = this.parseSYNCTYPE();
                n4 = this.peekCodePoint();
            }
            if (n4 == 6405) {
                bl2 = true;
                netConnection.setIndoubtTransactions(this.parseIndoubtList());
                n4 = this.peekCodePoint();
            }
            if (bl2) continue;
            this.doPrmnsprmSemantics(n4);
        }
        this.popCollectionStack();
        return n3;
    }

    @Override
    int parseXARETVAL() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6404);
        return this.readInt();
    }

    @Override
    byte parseSYNCTYPE() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4487);
        return this.readByte();
    }

    @Override
    int parseSYNCCTLreply(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        int n2 = this.peekCodePoint();
        if (n2 != 4680) {
            this.parseSYNCCTLError(n2);
            return -1;
        }
        int n3 = this.parseSYNCCRD(connectionCallbackInterface);
        n2 = this.peekCodePoint();
        while (n2 == 9236) {
            String string = this.parseSQLSTT();
            n2 = this.peekCodePoint();
        }
        if (n2 == 49152) {
            this.parsePBSD();
        }
        return n3;
    }

    private String parseSQLSTT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9236);
        return this.parseSQLSTTGRPNOCMorNOCS();
    }

    private String parseSQLSTTGRPNOCMorNOCS() throws DisconnectException {
        int n2 = this.readUnsignedByte();
        int n3 = 0;
        String string = null;
        int n4 = 0;
        if (n2 == 255) {
            n3 = this.readUnsignedByte();
            if (n3 == 255) {
                this.doDtamchrmSemantics();
            }
            n4 = this.readInt();
            string = this.readString(n4, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        } else {
            n4 = this.readInt();
            string = this.readString(n4, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
            n3 = this.readUnsignedByte();
        }
        return string;
    }

    @Override
    int parseXIDCNT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6406);
        return this.readUnsignedShort();
    }

    @Override
    Xid parseXID() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6145);
        int n2 = this.readInt();
        int n3 = this.readInt();
        int n4 = this.readInt();
        byte[] byArray = this.readBytes(n3);
        byte[] byArray2 = this.readBytes(n4);
        return new ClientXid(n2, byArray, byArray2);
    }

    @Override
    List<Xid> parseIndoubtList() throws DisconnectException {
        this.peekCodePoint();
        this.parseLengthAndMatchCodePoint(6405);
        int n2 = this.peekCodePoint();
        if (n2 == 6406) {
            this.parseXIDCNT();
            n2 = this.peekCodePoint();
        }
        ArrayList<Xid> arrayList = new ArrayList<Xid>();
        while (n2 == 6145) {
            Xid xid = this.parseXID();
            arrayList.add(xid);
            n2 = this.peekCodePoint();
        }
        return arrayList;
    }
}

